/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.RancidAdapterConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RancidAdapterConfigFactory
extends RancidAdapterConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(RancidAdapterConfigFactory.class);
    private static RancidAdapterConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public RancidAdapterConfigFactory(long currentVersion, InputStream reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(reader, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        OpennmsServerConfigFactory onmsSvrConfig = OpennmsServerConfigFactory.getInstance();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RANCID_CONFIG_FILE_NAME);
        LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
        FileInputStream reader = new FileInputStream(cfgFile);
        RancidAdapterConfigFactory config = new RancidAdapterConfigFactory(cfgFile.lastModified(), reader, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
        ((InputStream)reader).close();
        RancidAdapterConfigFactory.setInstance(config);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        RancidAdapterConfigFactory.init();
        RancidAdapterConfigFactory.getInstance().update();
    }

    public static synchronized RancidAdapterConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    private static synchronized void setInstance(RancidAdapterConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            this.getWriteLock().lock();
            try {
                long timestamp = System.currentTimeMillis();
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RANCID_CONFIG_FILE_NAME);
                LOG.debug("saveXml: saving config file at {}: {}", (Object)timestamp, (Object)cfgFile.getPath());
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
                fileWriter.write(xml);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                LOG.debug("saveXml: finished saving config file: {}", (Object)cfgFile.getPath());
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    public void update() throws IOException, MarshalException, ValidationException {
        this.getWriteLock().lock();
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RANCID_CONFIG_FILE_NAME);
            if (cfgFile.lastModified() > this.m_currentVersion) {
                this.m_currentVersion = cfgFile.lastModified();
                LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
                this.reloadXML(new FileInputStream(cfgFile));
                LOG.debug("init: finished loading config file: {}", (Object)cfgFile.getPath());
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }
}

