/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.BasicSchedule;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.RancidAdapterConfig;
import org.opennms.netmgt.config.rancid.adapter.ExcludeRange;
import org.opennms.netmgt.config.rancid.adapter.IncludeRange;
import org.opennms.netmgt.config.rancid.adapter.Mapping;
import org.opennms.netmgt.config.rancid.adapter.Package;
import org.opennms.netmgt.config.rancid.adapter.PolicyManage;
import org.opennms.netmgt.config.rancid.adapter.RancidConfiguration;
import org.opennms.netmgt.config.rancid.adapter.Schedule;
import org.opennms.netmgt.filter.FilterDaoFactory;

public abstract class RancidAdapterConfigManager
implements RancidAdapterConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private RancidConfiguration m_config;
    private static boolean m_verifyServer;
    private static String m_localServer;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<InetAddress>> m_pkgIpMap;
    private Map<Package, PolicyManage> m_pkgPolicyMap;

    public RancidAdapterConfigManager(InputStream reader, String serverName, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        m_localServer = serverName;
        m_verifyServer = verifyServer;
        this.reloadXML(reader);
    }

    public RancidAdapterConfigManager() {
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(InputStream reader) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            this.m_config = (RancidConfiguration)CastorUtils.unmarshal(RancidConfiguration.class, (InputStream)reader);
            this.createPolicyNamePkgMap();
            this.createUrlIpMap();
            this.createPackageIpListMap();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void createPolicyNamePkgMap() {
        this.m_pkgPolicyMap = new HashMap<Package, PolicyManage>();
        if (this.hasPolicies()) {
            for (PolicyManage pm : this.policies()) {
                this.m_pkgPolicyMap.put(pm.getPackage(), pm);
            }
        }
    }

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        if (this.hasPolicies()) {
            for (Package pkg : this.packages()) {
                for (String url : this.includeURLs(pkg)) {
                    List iplist = IpListFromUrl.parse((String)url);
                    if (iplist.size() <= 0) continue;
                    this.m_urlIPMap.put(url, iplist);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPackageIpListMap() {
        this.getWriteLock().lock();
        try {
            this.m_pkgIpMap = new HashMap<Package, List<InetAddress>>();
            if (this.hasPolicies()) {
                for (Package pkg : this.packages()) {
                    try {
                        List<InetAddress> ipList = this.getIpList(pkg);
                        LogUtils.debugf((Object)this, (String)"createPackageIpMap: package %s: ipList size = %d", (Object[])new Object[]{pkg.getName(), ipList.size()});
                        if (ipList.size() <= 0) continue;
                        this.m_pkgIpMap.put(pkg, ipList);
                    }
                    catch (Throwable t) {
                        LogUtils.errorf((Object)this, (Throwable)t, (String)"createPackageIpMap: failed to map package: %s to an IP List with filter \"%s\"", (Object[])new Object[]{pkg.getName(), pkg.getFilter().getContent()});
                    }
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private List<InetAddress> getIpList(Package pkg) {
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (m_verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(m_localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        LogUtils.debugf((Object)this, (String)"createPackageIpMap: package is %s. filter rules are %s", (Object[])new Object[]{pkg.getName(), filterRules.toString()});
        return FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
    }

    private boolean interfaceInPackage(String iface, Package pkg) {
        boolean filterPassed = false;
        InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
        List<InetAddress> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddr);
        }
        LogUtils.debugf((Object)this, (String)"interfaceInPackage: Interface %s passed filter for package %s?: %s", (Object[])new Object[]{iface, pkg.getName(), filterPassed});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        for (IncludeRange rng : pkg.getIncludeRange()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_include = true;
            break;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (String spec : pkg.getSpecific()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        for (ExcludeRange rng : pkg.getExcludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_exclude = true;
            break;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    private List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        for (Package pkg : this.packages()) {
            if (!this.interfaceInPackage(ipaddr, pkg)) continue;
            matchingPkgs.add(pkg.getName());
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDelay(String ipaddr) {
        this.getReadLock().lock();
        try {
            if (this.hasPolicyManage(ipaddr) && this.getPolicyManageWithoutTesting(ipaddr).hasDelay()) {
                long l = this.getPolicyManageWithoutTesting(ipaddr).getDelay();
                return l;
            }
            long l = this.getConfiguration().getDelay();
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRetries(String ipaddr) {
        this.getReadLock().lock();
        try {
            if (this.hasPolicyManage(ipaddr) && this.getPolicyManage(ipaddr).hasRetries()) {
                int n = this.getPolicyManageWithoutTesting(ipaddr).getRetries();
                return n;
            }
            int n = this.getConfiguration().getRetries();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean useCategories(String ipaddr) {
        this.getReadLock().lock();
        try {
            if (this.hasPolicyManage(ipaddr) && this.getPolicyManage(ipaddr).hasUseCategories()) {
                boolean bl = this.getPolicyManageWithoutTesting(ipaddr).getUseCategories();
                return bl;
            }
            boolean bl = this.getConfiguration().getUseCategories();
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getType(String sysoid) {
        this.getReadLock().lock();
        try {
            if (sysoid != null) {
                for (Mapping map : this.mappings()) {
                    if (!sysoid.startsWith(map.getSysoidMask())) continue;
                    String string = map.getType();
                    return string;
                }
            }
            String string = this.getConfiguration().getDefaultType();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurTimeInSchedule(String ipaddr) {
        this.getReadLock().lock();
        try {
            if (this.hasSchedule(ipaddr)) {
                GregorianCalendar cal = new GregorianCalendar();
                for (Schedule schedule : this.getSchedules(ipaddr)) {
                    if (!this.isTimeInSchedule(cal, schedule)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private boolean isTimeInSchedule(Calendar cal, Schedule schedule) {
        return BasicScheduleUtils.isTimeInSchedule((Calendar)cal, (BasicSchedule)BasicScheduleUtils.getRancidSchedule((Schedule)schedule));
    }

    private boolean hasPolicies() {
        return this.getConfiguration().getPolicies() != null;
    }

    private boolean hasPolicyManage(String ipaddress) {
        return this.getAllPackageMatches(ipaddress).size() > 0;
    }

    private PolicyManage getPolicyManage(String ipaddr) {
        if (this.hasPolicyManage(ipaddr)) {
            return this.getPolicyManageWithoutTesting(ipaddr);
        }
        return null;
    }

    private PolicyManage getPolicyManageWithoutTesting(String ipaddr) {
        String pkgname = this.getAllPackageMatches(ipaddr).get(0);
        for (Map.Entry<Package, PolicyManage> entry : this.m_pkgPolicyMap.entrySet()) {
            if (!entry.getKey().getName().equals(pkgname)) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSchedule(String ipaddress) {
        this.getReadLock().lock();
        try {
            if (this.hasPolicyManage(ipaddress)) {
                boolean bl = this.getPolicyManageWithoutTesting(ipaddress).getScheduleCount() > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Schedule> getSchedules(String ipaddress) {
        this.getReadLock().lock();
        try {
            if (this.hasPolicyManage(ipaddress)) {
                List list = this.getPolicyManageWithoutTesting(ipaddress).getScheduleCollection();
                return list;
            }
            ArrayList<Schedule> arrayList = new ArrayList<Schedule>();
            return arrayList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Package> packages() {
        this.getReadLock().lock();
        try {
            ArrayList<Package> pkgs = new ArrayList<Package>();
            if (this.hasPolicies()) {
                for (PolicyManage pm : this.policies()) {
                    pkgs.add(pm.getPackage());
                }
            }
            ArrayList<Package> arrayList = pkgs;
            return arrayList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Mapping> mappings() {
        this.getReadLock().lock();
        try {
            List list = this.getConfiguration().getMappingCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<PolicyManage> policies() {
        this.getReadLock().lock();
        try {
            List list = this.getConfiguration().getPolicies().getPolicyManageCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> includeURLs(Package pkg) {
        this.getReadLock().lock();
        try {
            List list = pkg.getIncludeUrlCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RancidConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            RancidConfiguration rancidConfiguration = this.m_config;
            return rancidConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }
}

