/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosdrx;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.HashMap;
import javax.oss.fm.monitor.NotifyAckStateChangedEvent;
import javax.oss.fm.monitor.NotifyAlarmCommentsEvent;
import javax.oss.fm.monitor.NotifyAlarmListRebuiltEvent;
import javax.oss.fm.monitor.NotifyChangedAlarmEvent;
import javax.oss.fm.monitor.NotifyClearedAlarmEvent;
import javax.oss.fm.monitor.NotifyNewAlarmEvent;
import javax.oss.util.IRPEvent;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.openoss.opennms.spring.dao.OnmsAlarmOssjMapper;
import org.openoss.opennms.spring.dao.OssDao;
import org.openoss.opennms.spring.dao.OssDaoOpenNMSImpl;
import org.openoss.ossj.fm.monitor.spring.AlarmEventReceiverEventHandler;
import org.openoss.ossj.fm.monitor.spring.OssBeanAlarmEventReceiver;

public class QoSDrxAlarmEventReceiverEventHandlerImpl2
implements AlarmEventReceiverEventHandler {
    private boolean initialised = false;
    public static int SPECIFY_OUTSTATION = 1;
    public static int USE_TYPE_INSTANCE = 2;
    private Integer almUpdateBehaviour = null;
    private String alarmUpdateBehaviour = null;
    private AssetRecordDao _assetRecordDao;
    private NodeDao _nodeDao;
    private AlarmDao _alarmDao;
    private DistPollerDao distPollerDao;
    private OssDao ossDao;
    private OnmsAlarmOssjMapper onmsAlarmOssjMapper;

    private static ThreadCategory getLog() {
        return ThreadCategory.getInstance(QoSDrxAlarmEventReceiverEventHandlerImpl2.class);
    }

    public void setalarmUpdateBehaviour(String _alarmUpdateBehaviour) {
        if (_alarmUpdateBehaviour == null) {
            throw new IllegalArgumentException("QoSDrxAlarmEventReceiverEventHandlerImpl().setalarmUpdateBehaviour(): Null value for alarmUpdateBehaviour");
        }
        this.alarmUpdateBehaviour = _alarmUpdateBehaviour;
        if (_alarmUpdateBehaviour.equals("USE_TYPE_INSTANCE")) {
            this.almUpdateBehaviour = USE_TYPE_INSTANCE;
            return;
        }
        if (_alarmUpdateBehaviour.equals("SPECIFY_OUTSTATION")) {
            this.almUpdateBehaviour = SPECIFY_OUTSTATION;
            return;
        }
        throw new IllegalArgumentException("QoSDrxAlarmEventReceiverEventHandlerImpl().setalarmUpdateBehaviour(): Unknown value for alarmUpdateBehaviour:" + _alarmUpdateBehaviour);
    }

    public void setAssetRecordDao(AssetRecordDao ar) {
        this._assetRecordDao = ar;
    }

    public void setNodeDao(NodeDao nodedao) {
        this._nodeDao = nodedao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this._alarmDao = alarmDao;
    }

    public void setDistPollerDao(DistPollerDao _distPollerDao) {
        this.distPollerDao = _distPollerDao;
    }

    public void setOssDao(OssDao _ossDao) {
        this.ossDao = _ossDao;
    }

    public void setOnmsAlarmOssjMapper(OnmsAlarmOssjMapper onmsAlarmOssjMapper) {
        this.onmsAlarmOssjMapper = onmsAlarmOssjMapper;
    }

    public synchronized void init() {
        if (this.initialised) {
            return;
        }
        try {
            this.ossDao.init();
            this.initialised = true;
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex, this.getClass().getSimpleName() + "init() problem initialising class");
        }
    }

    public void onNotifyNewAlarmEvent(NotifyNewAlarmEvent nnae, OssBeanAlarmEventReceiver callingAer) {
        block35: {
            ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
            String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyNewAlarmEvent(): ";
            if (log.isDebugEnabled()) {
                log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
            }
            if (!this.initialised) {
                log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
                return;
            }
            try {
                String applicationDN;
                String ossPrimaryKey;
                OnmsAlarm alarm;
                block36: {
                    OnmsSeverity onmsseverity;
                    alarm = null;
                    ossPrimaryKey = nnae.getAlarmKey().getAlarmPrimaryKey();
                    applicationDN = nnae.getAlarmKey().getApplicationDN();
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": Received an onNotifyNewAlarmEvent() - AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + " eventtime: " + nnae.getEventTime());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ":Using this OssDao (toString):" + this.ossDao.toString());
                    }
                    if (applicationDN == null || applicationDN.equals("") || ossPrimaryKey == null || ossPrimaryKey.equals("")) {
                        log.error(logheader + " ApplicatioDN or PrimaryKey not set");
                        break block35;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": Creating new alarm");
                    }
                    alarm = new OnmsAlarm();
                    alarm.setUei(OnmsAlarmOssjMapper.ossjAlarmTypeToUei(nnae.getAlarmType()));
                    alarm.setX733AlarmType(nnae.getAlarmType() == null ? "" : nnae.getAlarmType());
                    alarm.setX733ProbableCause((int)nnae.getProbableCause());
                    alarm.setTTicketState(null);
                    alarm.setTTicketId("");
                    alarm.setQosAlarmState("external_type");
                    alarm.setSuppressedUser("");
                    alarm.setSuppressedUntil(new Date());
                    alarm.setSuppressedTime(new Date());
                    try {
                        onmsseverity = OnmsAlarmOssjMapper.ossjSeveritytoOnmsSeverity(nnae.getPerceivedSeverity());
                    }
                    catch (IllegalArgumentException iae) {
                        log.error(logheader + " problem setting severity used default:'WARNING'. Exception:" + iae);
                        onmsseverity = OnmsSeverity.WARNING;
                    }
                    alarm.setSeverity(onmsseverity);
                    alarm.setReductionKey(":managedObjectInstance:" + nnae.getManagedObjectInstance() + ":managedObjectType:" + nnae.getManagedObjectClass() + ":ossPrimaryKey:-" + ossPrimaryKey + ":applicationDN:-" + applicationDN);
                    alarm.setOssPrimaryKey(ossPrimaryKey);
                    alarm.setOperInstruct(nnae.getProposedRepairActions());
                    OnmsNode node = new OnmsNode();
                    node.setId(new Integer(1));
                    alarm.setNode(node);
                    if (this.almUpdateBehaviour == null) {
                        log.error("RX:" + callingAer.getName() + ": This receiver's alarmUpdateBehaviour is not set: defaulting to update nodeID:1");
                    } else if (callingAer.getName() == null) {
                        log.error("RX:" + callingAer.getName() + ": This receiver has no name: default alarms will update nodeID:1");
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(logheader + " alarmUpdateBehaviour:" + this.almUpdateBehaviour + " " + this.alarmUpdateBehaviour);
                        }
                        if (this.almUpdateBehaviour.equals(SPECIFY_OUTSTATION)) {
                            if (log.isDebugEnabled()) {
                                log.debug(logheader + " SPECIFY_OUTSTATION looking for node with nodelabel:" + callingAer.getName());
                            }
                            try {
                                try {
                                    node = this.ossDao.findNodeByLabel(callingAer.getName());
                                }
                                catch (Exception ex) {
                                    log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node " + ex);
                                }
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE FOUND for this RX Name:" + callingAer.getName() + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId());
                                    }
                                    alarm.setNode(node);
                                    break block36;
                                }
                                log.error(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE NOT FOUND for this RX Name:" + callingAer.getName() + " setting node id to default NodeID: 1");
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                alarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex);
                            }
                        } else if (this.almUpdateBehaviour.equals(USE_TYPE_INSTANCE)) {
                            String managedObjectType = nnae.getManagedObjectClass();
                            String managedObjectInstance = nnae.getManagedObjectInstance();
                            if (log.isDebugEnabled()) {
                                log.debug(logheader + " USE_TYPE_INSTANCE looking for node with managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance);
                            }
                            try {
                                node = this.ossDao.findNodeByInstanceAndType(managedObjectInstance, managedObjectType);
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE FOUND for this RX Name:" + callingAer.getName() + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId());
                                    }
                                    alarm.setNode(node);
                                    break block36;
                                }
                                log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE NOT FOUND for this managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance + " setting node id to default NodeID: 1");
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                alarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex);
                            }
                        } else {
                            log.error(logheader + " Invalid value for alarmUpdateBehaviour:" + this.almUpdateBehaviour + " " + this.alarmUpdateBehaviour + " defaulting to update nodeID:1");
                        }
                    }
                }
                alarm.setMouseOverText("");
                alarm.setManagedObjectType(nnae.getManagedObjectClass());
                alarm.setManagedObjectInstance(nnae.getManagedObjectInstance());
                alarm.setLogMsg(nnae.getSpecificProblem());
                alarm.setIpAddr("localhost");
                alarm.setId(null);
                alarm.setFirstEventTime(nnae.getEventTime());
                alarm.setLastEventTime(nnae.getEventTime());
                alarm.setDistPoller((OnmsDistPoller)this.distPollerDao.get((Serializable)((Object)"localhost")));
                alarm.setDescription(nnae.getAdditionalText());
                alarm.setCounter(new Integer(1));
                alarm.setApplicationDN(applicationDN);
                alarm.setAlarmType(new Integer(1));
                HashMap m_details = new HashMap();
                alarm.setDetails(m_details);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": Creating Alarm: ");
                    }
                    OnmsAlarm updatedAlarm = this.ossDao.addCurrentAlarmForUniqueKey(alarm);
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": Created alarm:" + OssDaoOpenNMSImpl.alarmToString(updatedAlarm));
                    }
                }
                catch (Exception ex) {
                    log.error(logheader + ": problem creating new alarm AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + ": " + ex);
                }
            }
            catch (Exception e) {
                log.error(logheader + " Error : ", (Throwable)e);
            }
        }
    }

    public void onNotifyClearedAlarmEvent(NotifyClearedAlarmEvent nclae, OssBeanAlarmEventReceiver callingAer) {
        block14: {
            ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
            String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyClearedAlarmEvent(): ";
            if (log.isDebugEnabled()) {
                log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
            }
            if (!this.initialised) {
                log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
                return;
            }
            try {
                OnmsAlarm alarm = null;
                String ossPrimaryKey = nclae.getAlarmKey().getAlarmPrimaryKey();
                String applicationDN = nclae.getAlarmKey().getApplicationDN();
                if (log.isDebugEnabled()) {
                    log.debug(logheader + ": Received an onNotifyClearedAlarmEvent() - AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + " eventtime: " + nclae.getEventTime());
                }
                if (applicationDN == null || applicationDN.equals("") || ossPrimaryKey == null || ossPrimaryKey.equals("")) {
                    log.error(logheader + " ApplicatioDN or PrimaryKey not set");
                    break block14;
                }
                if (log.isDebugEnabled()) {
                    log.debug(logheader + ": trying to find existing alarm using getCurrentAlarmForUniqueKey");
                }
                if ((alarm = this.ossDao.getCurrentAlarmForUniqueKey(applicationDN, ossPrimaryKey)) == null) {
                    log.info(logheader + "WARNING Alarm does not exist with this Unique ID:- AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN);
                    break block14;
                }
                if (log.isDebugEnabled()) {
                    log.debug(logheader + ": found alarm alarmID:" + alarm.getId());
                }
                alarm.setSeverity(OnmsSeverity.CLEARED);
                alarm.setLastEventTime(nclae.getEventTime());
                alarm.setAlarmAckUser("ossjclearevent");
                alarm.setAlarmAckTime(new Date());
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": Alarm before update:" + OssDaoOpenNMSImpl.alarmToString(alarm));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": Updating Alarm using ossDao.updateCurrentAlarmForUniqueKey");
                    }
                    OnmsAlarm updatedAlarm = this.ossDao.updateCurrentAlarmForUniqueKey(alarm);
                    if (log.isDebugEnabled()) {
                        log.debug(logheader + ": Updated alarm:" + OssDaoOpenNMSImpl.alarmToString(updatedAlarm));
                    }
                }
                catch (Exception ex) {
                    log.error(logheader + ": problem clearing new alarm AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + ": " + ex);
                }
            }
            catch (Exception e) {
                log.error(logheader + " Error : ", (Throwable)e);
            }
        }
    }

    public void onNotifyAckStateChangedEvent(NotifyAckStateChangedEvent nasce, OssBeanAlarmEventReceiver callingAer) {
        ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyAckStateChangedEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
        }
        if (!this.initialised) {
            log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
            return;
        }
    }

    public void onNotifyAlarmCommentsEvent(NotifyAlarmCommentsEvent nace, OssBeanAlarmEventReceiver callingAer) {
        ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyAlarmCommentsEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
        }
        if (!this.initialised) {
            log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
            return;
        }
    }

    public void onNotifyAlarmListRebuiltEvent(NotifyAlarmListRebuiltEvent nalre, OssBeanAlarmEventReceiver callingAer) {
        ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyAlarmListRebuiltEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
        }
        if (!this.initialised) {
            log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
            return;
        }
    }

    public void onNotifyChangedAlarmEvent(NotifyChangedAlarmEvent nchae, OssBeanAlarmEventReceiver callingAer) {
        ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onNotifyChangedAlarmEvent(): ";
        if (log.isDebugEnabled()) {
            log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
        }
        if (!this.initialised) {
            log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
            return;
        }
    }

    public void onUnknownIRPEvt(IRPEvent irpevt, OssBeanAlarmEventReceiver callingAer) {
        ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onUnknownIRPEvt(): ";
        if (log.isDebugEnabled()) {
            log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
        }
        if (!this.initialised) {
            log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
            return;
        }
    }

    public void onunknownObjectMessage(Object objectMessage, OssBeanAlarmEventReceiver callingAer) {
        ThreadCategory log = QoSDrxAlarmEventReceiverEventHandlerImpl2.getLog();
        String logheader = "RX:" + callingAer.getName() + ":" + this.getClass().getSimpleName() + ".onunknownObjectMessage(): ";
        if (log.isDebugEnabled()) {
            log.debug(logheader + "\n    Statistics:" + callingAer.getRuntimeStatistics());
        }
        if (!this.initialised) {
            log.error(logheader + "event handler not initialised. init() must be called by receiver before handling any events");
            return;
        }
    }
}

