/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RMISecurityManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmValue;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.openoss.opennms.spring.dao.OnmsAlarmOssjMapper;
import org.openoss.opennms.spring.dao.OssDao;
import org.openoss.opennms.spring.qosd.AlarmListConnectionManager;
import org.openoss.opennms.spring.qosd.OpenNMSEventHandlerThread;
import org.openoss.opennms.spring.qosd.PropertiesLoader;
import org.openoss.opennms.spring.qosd.QoSD;
import org.openoss.opennms.spring.qosd.QoSDConfigFactory;
import org.openoss.opennms.spring.qosd.QoSDConfiguration;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmValue;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class QoSDimpl2
extends AbstractServiceDaemon
implements PausableFiber,
EventListener,
QoSD {
    private OssDao ossDao;
    private OnmsAlarmOssjMapper onmsAlarmOssjMapper;
    private AssetRecordDao assetRecordDao;
    private NodeDao nodeDao;
    private EventIpcManager eventIpcManager;
    private AlarmDao alarmDao;
    private AlarmListConnectionManager alarmListConnectionManager;
    private ClassPathXmlApplicationContext m_context = null;
    private QoSDConfiguration config = null;
    public PropertiesLoader props;
    private Properties env;
    private Hashtable<String, String> triggerUeiList;
    public static final String NAME = "OpenOSS.QoSD";
    private String m_stats = null;
    public boolean useUeiList = false;
    OpenNMSEventHandlerThread openNMSEventHandlerThread;

    public QoSDimpl2() {
        super(NAME);
    }

    public static ThreadCategory getLog() {
        return ThreadCategory.getInstance(QoSDimpl2.class);
    }

    @Override
    public void setOssDao(OssDao _ossDao) {
        this.ossDao = _ossDao;
    }

    @Override
    public void setOnmsAlarmOssjMapper(OnmsAlarmOssjMapper _onmsAlarmOssjMapper) {
        this.onmsAlarmOssjMapper = _onmsAlarmOssjMapper;
    }

    @Override
    public void setAssetRecordDao(AssetRecordDao ar) {
        this.assetRecordDao = ar;
    }

    @Override
    public void setNodeDao(NodeDao nodedao) {
        this.nodeDao = nodedao;
    }

    @Override
    public void setEventIpcManager(EventIpcManager evtIpcManager) {
        this.eventIpcManager = evtIpcManager;
    }

    @Override
    public void setAlarmDao(AlarmDao almDao) {
        this.alarmDao = almDao;
    }

    @Override
    public void setAlarmListConnectionManager(AlarmListConnectionManager alcm) {
        this.alarmListConnectionManager = alcm;
    }

    @Override
    public void setApplicationContext(ClassPathXmlApplicationContext m_context) {
        this.m_context = m_context;
    }

    protected void onInit() {
        ThreadCategory log = QoSDimpl2.getLog();
        log.info("Initialising QoSD");
    }

    protected void onStart() {
        String jnp_host;
        ThreadCategory log = QoSDimpl2.getLog();
        log.info("Qosd.start(): Preparing to load configuration");
        try {
            if (log.isDebugEnabled()) {
                log.debug("Qosd.start():setting application context for alarmListConnectionManager: m.context.toString:" + this.m_context.toString());
            }
            this.alarmListConnectionManager.setApplicationContext(this.m_context);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Qosd.start(): Error setting spring application context: " + ex);
        }
        try {
            this.config = QoSDConfigFactory.getConfig();
            log.info("QoSD QoSD-configuration.xml - Configuration Loaded Successfully");
            this.triggerUeiList = new Hashtable();
            String[] temp = this.config.getEventlist().getUei();
            for (int i = 0; i < temp.length; ++i) {
                this.triggerUeiList.put(temp[i], "1");
            }
        }
        catch (MarshalException mrshl_ex) {
            log.error("Qosd.start(): Marshal Exception thrown whilst getting QoSD configuration\n\t\t\t\tEnsure tags have correct names", (Throwable)mrshl_ex);
            throw new UndeclaredThrowableException(mrshl_ex);
        }
        catch (ValidationException vldtn_ex) {
            log.error("Qosd.start(): Validation Exception thrown whilst getting QoSD configuration\n\t\t\t\tMake sure all the tags are formatted correctly within QoSD-configuration.xml", (Throwable)vldtn_ex);
            throw new UndeclaredThrowableException(vldtn_ex);
        }
        catch (IOException io_ex) {
            String configFile = System.getProperty("opennms.home");
            if (configFile.endsWith(File.separator)) {
                configFile.substring(0, configFile.length() - 1);
            }
            configFile = configFile + "/etc/QoSD-configuration.xml";
            log.error("Qosd.start(): Failed to load configuration file: " + configFile + "\n\t\t\t\tMake sure that it exists", (Throwable)io_ex);
            throw new UndeclaredThrowableException(io_ex);
        }
        if (this.useUeiList) {
            log.info("Qosd.start(): useUeiList = true = using QoSD QoSD-configuration.xml UEI list selects which alarms are sent");
        }
        try {
            this.props = PropertiesLoader.getInstance();
        }
        catch (FileNotFoundException fnf_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            log.error("Qosd.start(): Could not find properties file: " + propertiesFilename, (Throwable)fnf_ex);
            throw new UndeclaredThrowableException(fnf_ex);
        }
        catch (IOException io_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            log.error("Qosd.start(): Could not read from properties file: " + propertiesFilename + "\n\t\t\t\tPlease check the file permissions", (Throwable)io_ex);
            throw new UndeclaredThrowableException(io_ex);
        }
        log.info("Qosd.start(): QosD Properties File Loaded");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        if (this.props.getProperty("org.openoss.opennms.spring.qosd.naming.provider") != null) {
            jnp_host = this.props.getProperty("org.openoss.opennms.spring.qosd.naming.provider");
            log.info("Using JNP: " + jnp_host);
        } else {
            log.warn("Qosd.start(): Naming provider property not set, Using default: jnp://jbossjmsserver1:1099");
            jnp_host = "jnp://jbossjmsserver1:1099";
        }
        this.env = new Properties();
        this.env.setProperty("java.naming.provider.url", jnp_host);
        this.env.setProperty("java.naming.factory.initial", this.props.getProperty("org.openoss.opennms.spring.qosd.naming.contextfactory"));
        this.env.setProperty("java.naming.factory.url.pkgs", this.props.getProperty("org.openoss.opennms.spring.qosd.naming.pkg"));
        try {
            this.alarmListConnectionManager.init(this.props, this.env);
            this.alarmListConnectionManager.start();
            log.info("Qosd.start(): Waiting Connection Manager Thread to get JMS connection");
            while (this.alarmListConnectionManager.getStatus() != 0) {
            }
            log.info("Qosd.start(): Connection Manager Thread JMS connection successfully registered");
            log.info("Qosd.start(): openNMS just restarted - sending alarm list rebuilt event");
            this.alarmListConnectionManager.reset_list("openNMS just restarted - alarm list rebuilt. Time:" + new Date());
        }
        catch (Throwable iae) {
            log.error("Qosd.start(): Exception caught starting alarmListConnectionManager", iae);
            throw new UndeclaredThrowableException(iae);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Qosd.start(): Using ossDao instance:" + (this.ossDao == null ? "IS NULL" : this.ossDao.toString()));
            }
            log.info("Qosd.start(): Initialising the Node and alarm Caches");
            this.ossDao.init();
            log.info("Qosd.start(): Set up ossDao call back interface to QoSD for forwarding changes to alarm list");
            this.ossDao.setQoSD(this);
        }
        catch (Throwable ex) {
            log.error("Qosd.start(): Exception caught setting callback interface from ossDao", ex);
            throw new UndeclaredThrowableException(ex);
        }
        log.info("Qosd.start(): initialising OpenNMSEventHandlerThread");
        try {
            this.openNMSEventHandlerThread = new OpenNMSEventHandlerThread();
            this.openNMSEventHandlerThread.setOssDao(this.ossDao);
            this.openNMSEventHandlerThread.init();
            this.openNMSEventHandlerThread.start();
        }
        catch (Throwable ex) {
            log.error("Qosd.start(): Exception caught initialising OpenNMSEventHandlerThread", ex);
            throw new UndeclaredThrowableException(ex);
        }
        log.info("Qosd.start(): openNMS just restarted - sending all alarms in rebuilt alarm list");
        try {
            this.openNMSEventHandlerThread.sendAlarmList();
        }
        catch (Exception e) {
            log.error("Qosd.start(): problem sending initial alarm list Error:", (Throwable)e);
        }
        log.info("Qosd.start(): Starting OpenNMS event listener");
        try {
            this.registerListener();
        }
        catch (Exception e) {
            log.error("Qosd.start(): problem registering event listener Error:", (Throwable)e);
        }
        log.info("QoSD Started");
    }

    protected void onStop() {
        ThreadCategory log = QoSDimpl2.getLog();
        log.info("Stopping QosD");
        try {
            this.unregisterListener();
        }
        catch (Throwable ex) {
            log.error("stop() Error unregistering the OpenNMS event listener. Error:", ex);
        }
        try {
            this.openNMSEventHandlerThread.kill();
        }
        catch (Throwable ex) {
            log.error("stop() Error killing openNMSEventHandlerThread. Error:", ex);
        }
        try {
            this.alarmListConnectionManager.kill();
        }
        catch (Throwable ex) {
            log.error("stop() Error killing alarmListConnectionManager. Error:", ex);
        }
        log.info("QosD Stopped");
    }

    protected void onResume() {
        ThreadCategory log = QoSDimpl2.getLog();
        log.info("Resuming QosD");
        this.registerListener();
        log.info("QosD Resumed");
    }

    protected void onPause() {
        ThreadCategory log = QoSDimpl2.getLog();
        log.info("Pausing QosD");
        this.unregisterListener();
        log.info("QosD Paused");
    }

    @Override
    public void registerListener() {
        ThreadCategory log = QoSDimpl2.getLog();
        ArrayList<String> ueiList = new ArrayList<String>();
        String[] temp = this.config.getEventlist().getUei();
        for (int i = 0; i < temp.length; ++i) {
            ueiList.add(temp[i]);
        }
        log.info("QosD Registering for " + temp.length + " types of event");
        this.eventIpcManager.addEventListener((EventListener)this, ueiList);
    }

    @Override
    public void unregisterListener() {
        ThreadCategory log = QoSDimpl2.getLog();
        log.info("QosD Unregistering for events");
        this.eventIpcManager.removeEventListener((EventListener)this);
    }

    @Override
    public void onEvent(Event event) {
        String s;
        ThreadCategory log = QoSDimpl2.getLog();
        if (log.isDebugEnabled()) {
            log.debug("Qosd.onEvent: OpenNMS Event Detected by QosD. uei '" + event.getUei() + "' Dbid(): " + event.getDbid() + "  event.getTime(): " + event.getTime());
        }
        if ((s = event.getUei()) == null) {
            return;
        }
        if ("uei.opennms.org/nodes/nodeAdded".equals(s) || "uei.opennms.org/nodes/nodeLabelChanged".equals(s) || "uei.opennms.org/nodes/nodeDeleted".equals(s) || "uei.opennms.org/nodes/assetInfoChanged".equals(s)) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("QosD.onEvent Event causing update to node list");
                }
                this.openNMSEventHandlerThread.updateNodeCache();
                return;
            }
            catch (Exception ex) {
                log.error("Qosd.onEvent. Problem calling openNMSEventHandlerThread.updateNodeCache(). Error:" + ex);
                return;
            }
        }
        if (event.getUei().equals("uei.opennms.org/vacuumd/alarmListChanged")) {
            if (log.isDebugEnabled()) {
                log.debug("QosD.onEvent received 'uei.opennms.org/vacuumd/alarmListChanged' event; Updating alarm list");
            }
        } else {
            try {
                if (event.getLogmsg().getDest().equals("donotpersist")) {
                    if (log.isDebugEnabled()) {
                        log.debug("QosD.onEvent Ignoring event marked as 'doNotPersist'. Event Uei:" + event.getUei());
                    }
                    return;
                }
                if (event.getAlarmData().getAlarmType() == 2) {
                    if (log.isDebugEnabled()) {
                        log.debug("Qosd.onEvent: uei '" + event.getUei() + "' Dbid(): " + event.getDbid() + " alarm type = 2 (clearing alarm) so ignoring.");
                    }
                    return;
                }
            }
            catch (NullPointerException e) {
                log.error("Qosd.onEvent: uei '" + event.getUei() + "' Dbid(): " + event.getDbid() + "' problem dealing with event. Check QoSD-configuration.xml.");
                return;
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("QosD.onEvent calling openNMSEventHandlerThread.sendAlarmList() to update list.");
            }
            this.openNMSEventHandlerThread.sendAlarmList();
        }
        catch (Exception ex) {
            log.error("Qosd.onEvent. Problem calling openNMSEventHandlerThread.sendAlarmList(). Error:" + ex);
        }
    }

    @Override
    public void sendAlarms() {
        ThreadCategory log = QoSDimpl2.getLog();
        Hashtable<AlarmKey, AlarmValue> ossjAlarmUpdateList = new Hashtable<AlarmKey, AlarmValue>();
        OnmsAlarm[] onmsAlarmUpdateList = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("sendAlarms() using ossDao to get current alarm list");
            }
            onmsAlarmUpdateList = this.ossDao.getAlarmCache();
        }
        catch (Throwable ex) {
            log.error("sendAlarms() Cannot retrieve alarms from ossDao.getAlarmCache()", ex);
            throw new UndeclaredThrowableException(ex, "sendAlarms() Cannot retrieve alarms from ossDao.getAlarmCache()");
        }
        if (log.isDebugEnabled()) {
            log.debug("sendAlarms() Alarms fetched. Processing each alarm in list.");
        }
        try {
            for (int i = 0; i < onmsAlarmUpdateList.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("sendAlarms() processing an OpenNMS alarm:");
                }
                if (this.useUeiList) {
                    if (log.isDebugEnabled()) {
                        log.debug("sendAlarms() useUeiList= true: using UeiList to determine alarms to send");
                    }
                    if (null == this.triggerUeiList.get(onmsAlarmUpdateList[i].getUei())) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("sendAlarms() alarm UEI not in QosD-configuration.xml. Not sending. alarmID:" + onmsAlarmUpdateList[i].getId() + " alarmUEI:" + onmsAlarmUpdateList[i].getUei());
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("sendAlarms() alarm UEI is in QosD-configuration.xml. Trying to send alarmID:" + onmsAlarmUpdateList[i].getId() + " alarmUEI:" + onmsAlarmUpdateList[i].getUei());
                    }
                }
                if (onmsAlarmUpdateList[i].getAlarmType() != 1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("sendAlarms() Alarm AlarmType !=1 ( not raise alarm ) Not sending alarmID:" + onmsAlarmUpdateList[i].getId() + " :alarmBuf[i].getQosAlarmState()=: " + onmsAlarmUpdateList[i].getQosAlarmState());
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("sendAlarms() Alarm AlarmType==1 ( raise alarm ) Sending alarmID:" + onmsAlarmUpdateList[i].getId() + " :alarmBuf[i].getQosAlarmState()=: " + onmsAlarmUpdateList[i].getQosAlarmState());
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("sendAlarms(): generating the OSS/J alarm specification:");
                    }
                    AlarmValue ossjAlarm = this.alarmListConnectionManager.makeAlarmValueFromSpec();
                    if (log.isDebugEnabled()) {
                        log.debug("sendAlarms(): OSS/J alarm specification:" + OOSSAlarmValue.converttoString((AlarmValue)ossjAlarm));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("sendAlarms(): onmsAlarmOssjMapper.populateOssjAlarmFromOpenNMSAlarm:");
                    }
                    ossjAlarm = this.onmsAlarmOssjMapper.populateOssjAlarmFromOpenNMSAlarm(ossjAlarm, onmsAlarmUpdateList[i]);
                    if (log.isDebugEnabled()) {
                        log.debug("buildList(): alarm specifcation:" + OOSSAlarmValue.converttoString((AlarmValue)ossjAlarm));
                    }
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("sendAlarms() including ACKNOWLEDGED and CLEARED alarms in alarm in list");
                        }
                        ossjAlarmUpdateList.put(ossjAlarm.getAlarmKey(), ossjAlarm);
                    }
                    catch (Throwable e) {
                        log.error("sendAlarms() error putting alarm in alarmList", e);
                    }
                    continue;
                }
                catch (Throwable ex) {
                    log.error("sendAlarms() error trying to populate alarm - alarm disguarded - check alarm definitons", ex);
                }
            }
        }
        catch (Throwable ex) {
            log.error("Qosd.sendAlarms(): Problem when building alarm list:", ex);
            throw new UndeclaredThrowableException(ex, "Qosd.sendAlarms(): Problem when building alarm list");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("QosD sendAlarms() - Alarm list built:");
                log.debug("QosD sendAlarms() - ******* Alarm List to be sent : primary keys");
                for (AlarmKey key : ossjAlarmUpdateList.keySet()) {
                    AlarmValue a = ossjAlarmUpdateList.get(key);
                    log.debug("QosD sendAlarms() key : " + key.getPrimaryKey() + "  AlarmValue.getAlarmChangedTime: " + a.getAlarmChangedTime());
                }
                log.debug("QosD sendAlarms() - ******* END OF LIST");
                log.debug("QosD sendAlarms() Sending alarm list to bean");
            }
            this.alarmListConnectionManager.send(ossjAlarmUpdateList);
        }
        catch (Throwable ex) {
            log.error("Qosd.sendAlarms(): Problem when sending alarm list:", ex);
            throw new UndeclaredThrowableException(ex, "Qosd.sendAlarms(): Problem when sending alarm list");
        }
    }

    @Override
    public String getStats() {
        return this.m_stats == null ? "No Stats Available" : this.m_stats.toString();
    }
}

