/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.dao;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.sql.DataSource;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.openoss.opennms.spring.dao.OssDao;
import org.openoss.opennms.spring.qosd.QoSD;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class OssDaoOpenNMSImpl
implements OssDao {
    private final Hashtable<Integer, OnmsAlarm> alarmCacheByID = new Hashtable();
    private final Hashtable<String, OnmsAlarm> alarmCacheByUniqueKey = new Hashtable();
    private final Hashtable<Integer, OnmsNode> nodeCacheByID = new Hashtable();
    private final Hashtable<String, OnmsNode> nodeCacheByLabel = new Hashtable();
    private final Hashtable<String, OnmsNode> nodeCacheByUniqueID = new Hashtable();
    protected DataSource _dataSource;
    protected AssetRecordDao _assetRecordDao;
    protected NodeDao _nodeDao;
    protected AlarmDao _alarmDao;
    protected TransactionTemplate transTemplate;
    private QoSD qoSD = null;
    private boolean initialised = false;

    private static ThreadCategory getLog() {
        return ThreadCategory.getInstance(OssDaoOpenNMSImpl.class);
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    @Override
    public void setAssetRecordDao(AssetRecordDao ar) {
        this._assetRecordDao = ar;
    }

    @Override
    public void setNodeDao(NodeDao nodedao) {
        this._nodeDao = nodedao;
    }

    @Override
    public void setAlarmDao(AlarmDao alarmDao) {
        this._alarmDao = alarmDao;
    }

    @Override
    public void setTransTemplate(TransactionTemplate _transTemplate) {
        this.transTemplate = _transTemplate;
    }

    @Override
    public void setQoSD(QoSD _qoSD) {
        this.qoSD = _qoSD;
    }

    @Override
    public synchronized void init() {
        if (this.initialised) {
            return;
        }
        try {
            this.localUpdateNodeCaches();
            this.localUpdateAlarmCache();
            this.initialised = true;
        }
        catch (Throwable ex) {
            throw new UndeclaredThrowableException(ex, this.getClass().getSimpleName() + "init() problem initialising class");
        }
    }

    @Override
    public synchronized OnmsAlarm addCurrentAlarmForUniqueKey(final OnmsAlarm alarm) {
        block12: {
            ThreadCategory log = OssDaoOpenNMSImpl.getLog();
            if (alarm == null || alarm.getId() != null) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm==null or alarmID!=null");
            }
            if (alarm.getAlarmType() != 1) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm.getAlarmType() not 'raise' alarm type '1'");
            }
            if (alarm.getApplicationDN() == null || alarm.getApplicationDN().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm ApplicationDN null or empty ");
            }
            if (alarm.getOssPrimaryKey() == null || alarm.getOssPrimaryKey().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm OssPrimaryKey null or empty");
            }
            OnmsAlarm checkAlarm = this.getCurrentAlarmForUniqueKey(alarm.getApplicationDN(), alarm.getOssPrimaryKey());
            if (checkAlarm != null) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Illegal value: alarm not unique in Current Alarm list: ApplicationDN:" + alarm.getApplicationDN() + " OssPrimaryKey:" + alarm.getOssPrimaryKey());
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): ALARM TO SAVE:\n" + OssDaoOpenNMSImpl.alarmToString(alarm));
                }
                String uniqueKey = alarm.getApplicationDN() + alarm.getOssPrimaryKey();
                this.transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus status) {
                        OssDaoOpenNMSImpl.this._alarmDao.save((Object)alarm);
                        return null;
                    }
                });
                this.alarmCacheByID.put(new Integer(alarm.getId()), alarm);
                this.alarmCacheByUniqueKey.put(uniqueKey, alarm);
            }
            catch (Throwable ex) {
                log.error("OssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey():Error creating alarm in database:", ex);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): ALARM SAVED" + OssDaoOpenNMSImpl.alarmToStringBrief(alarm));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): Sending Updated alarm list to QoSD");
                }
                this.sendAlarms();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block12;
                log.debug("\tOssDaoOpenNMSImpl().addCurrentAlarmForUniqueKey(): problem sending alarm to QoSD ( QoSD may not be running ):" + e);
            }
        }
        return alarm;
    }

    @Override
    public synchronized OnmsAlarm updateCurrentAlarmForUniqueKey(final OnmsAlarm alarm) {
        block13: {
            ThreadCategory log = OssDaoOpenNMSImpl.getLog();
            if (alarm == null || alarm.getId() == null) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm==null or alarmID==null");
            }
            if (alarm.getAlarmType() != 1) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm.getAlarmType() not 'raise' alarm type '1'");
            }
            if (alarm.getApplicationDN() == null || alarm.getApplicationDN().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm ApplicationDN null or empty ");
            }
            if (alarm.getOssPrimaryKey() == null || alarm.getOssPrimaryKey().equals("")) {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm OssPrimaryKey null or empty");
            }
            String uniqueKey = alarm.getApplicationDN() + alarm.getOssPrimaryKey();
            OnmsAlarm updateAlarm = this.getCurrentAlarmForUniqueKey(alarm.getApplicationDN(), alarm.getOssPrimaryKey());
            if (updateAlarm != null) {
                alarm.setId(updateAlarm.getId());
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: alarm to update in database" + OssDaoOpenNMSImpl.alarmToStringBrief(alarm));
                    }
                    this.transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                        public Object doInTransaction(TransactionStatus status) {
                            OssDaoOpenNMSImpl.this._alarmDao.update((Object)alarm);
                            return null;
                        }
                    });
                    this.alarmCacheByID.put(new Integer(alarm.getId()), alarm);
                    this.alarmCacheByUniqueKey.put(uniqueKey, alarm);
                }
                catch (Throwable ex) {
                    log.error("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey():Error updating alarm in database:", ex);
                    return null;
                }
            } else {
                throw new IllegalArgumentException("OssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey(): Illegal value: alarm not found in Current Alarm list: ApplicationDN:" + alarm.getApplicationDN() + " OssPrimaryKey:" + alarm.getOssPrimaryKey());
            }
            if (log.isDebugEnabled()) {
                log.debug("\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: Sending Updated alarm list Updated alarm" + OssDaoOpenNMSImpl.alarmToStringBrief(alarm));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: Sending Updated alarm list to QoSD");
                }
                this.sendAlarms();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block13;
                log.debug("\tOssDaoOpenNMSImpl().updateCurrentAlarmForUniqueKey: problem sending alarm to  QoSD:" + e);
            }
        }
        return alarm;
    }

    @Override
    public synchronized OnmsAlarm getCurrentAlarmForUniqueKey(String applicationDN, String ossPrimaryKey) {
        ThreadCategory log = OssDaoOpenNMSImpl.getLog();
        if (applicationDN == null || applicationDN.equals("")) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey(): Illegal value: alarm ApplicationDN null or empty ");
        }
        if (ossPrimaryKey == null || ossPrimaryKey.equals("")) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey(): Illegal value: alarm OssPrimaryKey null or empty");
        }
        OnmsAlarm alarm = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("\tOssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey: checking if alarm is in local alarm cache alarmCacheByID");
            }
            alarm = this.searchAlarmCacheForUniqueKey(applicationDN, ossPrimaryKey);
        }
        catch (Exception ex) {
            log.error("\tOssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey ERROR : ", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug("\tOssDaoOpenNMSImpl().getCurrentAlarmForUniqueKey: alarm result =" + OssDaoOpenNMSImpl.alarmToStringBrief(alarm));
        }
        return alarm;
    }

    private void localUpdateAlarmCache() {
        this.transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                OssDaoOpenNMSImpl.this.localUpdateAlarmCacheTransaction();
                return null;
            }
        });
    }

    private void localUpdateAlarmCacheTransaction() {
        ThreadCategory log = OssDaoOpenNMSImpl.getLog();
        List c = this._alarmDao.findAll();
        this.alarmCacheByID.clear();
        this.alarmCacheByUniqueKey.clear();
        OnmsAlarm[] alarms = c.toArray(new OnmsAlarm[c.size()]);
        for (int i = 0; i < alarms.length; ++i) {
            OnmsAlarm newalarm = alarms[i];
            if (newalarm.getNode() != null) {
                newalarm.getNode().getLabel();
            }
            this.alarmCacheByID.put(new Integer(newalarm.getId()), newalarm);
            if (newalarm.getApplicationDN() == null || newalarm.getOssPrimaryKey() == null || newalarm.getApplicationDN().equals("") || newalarm.getOssPrimaryKey().equals("")) continue;
            String uniqueKey = newalarm.getApplicationDN() + newalarm.getOssPrimaryKey();
            if (this.alarmCacheByUniqueKey.get(uniqueKey) == null) {
                this.alarmCacheByUniqueKey.put(uniqueKey, newalarm);
                continue;
            }
            log.error("\tOssDaoOpenNMSImpl().localUpdateAlarmCache(): ERROR - duplicate alarm uniqueKey in database =" + uniqueKey + " AlarmID:" + newalarm.getId());
        }
    }

    @Override
    public synchronized void updateAlarmCache() throws IllegalStateException {
        this.localUpdateAlarmCache();
    }

    @Override
    public synchronized void updateAlarmCacheAndSendAlarms() throws IllegalStateException {
        this.localUpdateAlarmCache();
        this.sendAlarms();
    }

    @Override
    public OnmsAlarm[] getAlarmCache() {
        OnmsAlarm[] returnAlarmCache = new OnmsAlarm[this.alarmCacheByID.size()];
        int i = 0;
        Enumeration<Integer> alarmIDS = this.alarmCacheByID.keys();
        while (alarmIDS.hasMoreElements()) {
            Integer alarmID = alarmIDS.nextElement();
            returnAlarmCache[i] = this.alarmCacheByID.get(alarmID);
            ++i;
        }
        return returnAlarmCache;
    }

    private void sendAlarms() {
        ThreadCategory log = OssDaoOpenNMSImpl.getLog();
        if (this.qoSD != null) {
            try {
                this.qoSD.sendAlarms();
            }
            catch (Exception ex) {
                log.error("\tOssDaoOpenNMSImpl().sendAlarms() Problem calling back to qoSD:", (Throwable)ex);
                throw new IllegalStateException("OssDaoOpenNMSImpl().sendAlarms() Problem calling back to qoSD:", ex);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("\tOssDaoOpenNMSImpl().sendAlarms(): QoSD not running - not calling back QoSD to send alarms");
        }
    }

    private OnmsAlarm searchAlarmCacheForUniqueKey(String applicationDN, String ossPrimaryKey) {
        ThreadCategory log = OssDaoOpenNMSImpl.getLog();
        String uniqueKey = applicationDN + ossPrimaryKey;
        OnmsAlarm alarm = this.alarmCacheByUniqueKey.get(uniqueKey);
        if (log.isDebugEnabled()) {
            log.debug("\tOssDaoOpenNMSImpl().searchAlarmBufForUniqueKey alarmCacheByID search result:" + OssDaoOpenNMSImpl.alarmToStringBrief(alarm));
        }
        return alarm;
    }

    private static String alarmToStringBrief(OnmsAlarm alarm) {
        String s = alarm == null ? "\n\t\tOnmsAlarm is Null" : "\n\t\tapplicationDN \t" + alarm.getApplicationDN() + "\t\tossPrimaryKey \t" + alarm.getOssPrimaryKey() + "\t\talarmID " + alarm.getId() + "\t\tSeverity():" + alarm.getSeverity().getId() + "\t\tAlarmAckUser():" + alarm.getAlarmAckUser() + "\t\tAlarmAckTime():" + alarm.getAlarmAckTime();
        return s;
    }

    public static String alarmToString(OnmsAlarm alarm) {
        String s = alarm == null ? "\n\t\tOnmsAlarm is Null" : "\n\t\teventUei \t" + alarm.getUei() + "\n" + "\t\tdpName \t" + (alarm.getDistPoller() == null ? null : alarm.getDistPoller().getName()) + "\n" + "\t\tnodeID \t" + (alarm.getNode() == null ? null : alarm.getNode().getId()) + "\n" + "\t\tipaddr \t" + alarm.getIpAddr() + "\n" + "\t\tserviceID \t" + (alarm.getServiceType() == null ? null : alarm.getServiceType().getId()) + "\n" + "\t\treductionKey \t" + alarm.getReductionKey() + "\n" + "\t\talarmType \t" + alarm.getAlarmType() + "\n" + "\t\tcounter \t" + alarm.getCounter() + "\n" + "\t\tseverity \t" + alarm.getSeverity().getId() + "\n" + "\t\tlastEventID \t" + (alarm.getLastEvent() == null ? null : alarm.getLastEvent().getId()) + "\n" + "\t\tfirstEventTime \t" + alarm.getFirstEventTime() + "\n" + "\t\tlastEventTime \t" + alarm.getLastEventTime() + "\n" + "\t\tdescription \t" + alarm.getDescription() + "\n" + "\t\tlogMsg \t" + alarm.getLogMsg() + "\n" + "\t\toperInstruct \t" + alarm.getOperInstruct() + "\n" + "\t\ttticketID \t" + alarm.getTTicketId() + "\n" + "\t\ttticketState \t" + alarm.getTTicketState() + "\n" + "\t\tmouseOverText \t" + alarm.getMouseOverText() + "\n" + "\t\tsuppressedUntil \t" + alarm.getSuppressedUntil() + "\n" + "\t\tsuppressedUser \t" + alarm.getSuppressedUser() + "\n" + "\t\tsuppressedTime \t" + alarm.getSuppressedTime() + "\n" + "\t\talarmAckUser \t" + alarm.getAlarmAckUser() + "\n" + "\t\talarmAckTime \t" + alarm.getAlarmAckTime() + "\n" + "\t\tclearKey   \t" + alarm.getClearKey() + "\n" + "\t\tmanagedObjectInstance \t" + alarm.getManagedObjectInstance() + "\n" + "\t\tmanagedObjectType \t" + alarm.getManagedObjectType() + "\n" + "\t\tapplicationDN \t" + alarm.getApplicationDN() + "\n" + "\t\tossPrimaryKey \t" + alarm.getOssPrimaryKey() + "\n" + "\t\talarmID \t" + alarm.getId() + "\n" + "\t\tqosAlarmState \t" + alarm.getQosAlarmState();
        return s;
    }

    @Override
    public OnmsNode findNodeByLabel(String label) {
        ThreadCategory log = OssDaoOpenNMSImpl.getLog();
        if (label == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByLabel: Illegal value: label null or empty ");
        }
        OnmsNode node = null;
        try {
            node = this.nodeCacheByLabel.get(label);
        }
        catch (Throwable ex) {
            log.error("\tOssDaoOpenNMSImpl().findNodeByLabel ERROR : ", ex);
        }
        return node;
    }

    @Override
    public OnmsNode findNodeByInstanceAndType(String managedObjectInstance, String managedObjectType) throws IllegalArgumentException {
        ThreadCategory log = OssDaoOpenNMSImpl.getLog();
        if (managedObjectInstance == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByInstanceType: Illegal value: managedObjectInstance null");
        }
        if (managedObjectType == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByInstanceType: Illegal value: label managedObjectType null");
        }
        String uniqueid = managedObjectInstance + managedObjectType;
        OnmsNode node = null;
        try {
            node = this.nodeCacheByUniqueID.get(uniqueid);
        }
        catch (Throwable ex) {
            log.error("\tOssDaoOpenNMSImpl().findNodeByInstanceAndType ERROR : ", ex);
        }
        return node;
    }

    @Override
    public OnmsNode findNodeByID(Integer nodeid) {
        if (nodeid == null) {
            throw new IllegalArgumentException("OssDaoOpenNMSImpl().findNodeByLabel: Illegal value: nodeid null or empty ");
        }
        OnmsNode node = null;
        try {
            node = this.nodeCacheByID.get(nodeid);
        }
        catch (Throwable ex) {
            OssDaoOpenNMSImpl.getLog().error("\tOssDaoOpenNMSImpl().findNodeByLabel ERROR : ", ex);
        }
        return node;
    }

    @Override
    public synchronized void updateNodeCaches() {
        this.localUpdateNodeCaches();
    }

    private void localUpdateNodeCaches() {
        block23: {
            ThreadCategory log = OssDaoOpenNMSImpl.getLog();
            try {
                OnmsNode node;
                this.nodeCacheByID.clear();
                this.nodeCacheByLabel.clear();
                this.nodeCacheByUniqueID.clear();
                if (log.isDebugEnabled()) {
                    log.debug("\tOssDaoOpenNMSImpl().updateNodeCaches - Updating Node Caches :");
                }
                List c = this._nodeDao.findAll();
                OnmsNode[] nodelist = c.toArray(new OnmsNode[c.size()]);
                for (int i = 0; i < nodelist.length; ++i) {
                    OnmsNode node2 = nodelist[i];
                    try {
                        String mot;
                        this.nodeCacheByID.put(node2.getId(), node2);
                        if (node2.getLabel() != null) {
                            if (this.nodeCacheByLabel.get(node2.getLabel()) != null) {
                                log.info("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " Node Label:" + node2.getId() + " is duplicated");
                            } else {
                                this.nodeCacheByLabel.put(node2.getLabel(), node2);
                            }
                        } else {
                            log.info("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " Node Label is NULL. Not putting node in nodeCacheByLabel");
                        }
                        final OnmsAssetRecord assetRecord = node2.getAssetRecord();
                        if (assetRecord == null) {
                            log.info("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " assetRecord is NULL. Not putting node in nodeCacheByUniqueID");
                            continue;
                        }
                        String moi = assetRecord.getManagedObjectInstance();
                        if (moi == null || "".equals(moi)) {
                            String fid = node2.getForeignId() == null ? "" : node2.getForeignId();
                            String fsrc = node2.getForeignSource() == null ? "" : node2.getForeignSource();
                            String label = node2.getLabel() == null ? "" : node2.getLabel();
                            moi = "Label:" + label + ":ForeignSource:" + fsrc + ":ForeignId():" + fid;
                            log.info("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " ManagedObjectInstance is NULL. Setting  ManagedObjectInstance to: " + moi);
                            assetRecord.setManagedObjectInstance(moi);
                        }
                        if ((mot = assetRecord.getManagedObjectType()) == null || "".equals(mot)) {
                            mot = "UNSPECIFIED_TYPE";
                            log.info("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + "ManagedObjectType was NULL. Setting ManagedObjectType to: " + mot);
                            assetRecord.setManagedObjectType(mot);
                        }
                        this.transTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                            public Object doInTransaction(TransactionStatus status) {
                                OssDaoOpenNMSImpl.this._assetRecordDao.update((Object)assetRecord);
                                return null;
                            }
                        });
                        String uniqueid = assetRecord.getManagedObjectInstance() + assetRecord.getManagedObjectType();
                        if (this.nodeCacheByUniqueID.get(uniqueid) != null) {
                            log.info("\tOssDaoOpenNMSImpl().updateNodeCaches WARNING node.getId():" + node2.getId() + " Unique ID is duplicated. Unique ID = ManagedObjectInstance:" + assetRecord.getManagedObjectInstance() + "+ ManagedObjectType:" + assetRecord.getManagedObjectType());
                            continue;
                        }
                        this.nodeCacheByUniqueID.put(uniqueid, node2);
                        continue;
                    }
                    catch (Throwable ex) {
                        log.error("\tOssDaoOpenNMSImpl().updateNodeCaches Error updating node caches: ERROR : ", ex);
                    }
                }
                if (!log.isDebugEnabled()) break block23;
                log.debug("\tOssDaoOpenNMSImpl().updateNodeCaches - Updated nodeCacheByID : contents :");
                try {
                    for (Integer id : this.nodeCacheByID.keySet()) {
                        node = this.nodeCacheByID.get(id);
                        log.debug("\t\tKey: Node ID:" + id + "\tNodeLabel:" + node.getLabel());
                    }
                }
                catch (Exception e) {
                    log.error("\tOssDaoOpenNMSImpl().updateNodeCaches: Problem listing nodeCacheByLabel contents Error:", (Throwable)e);
                }
                log.debug("\tOssDaoOpenNMSImpl().updateNodeCaches - Updated nodeCacheByLabel : contents :");
                try {
                    for (String label : this.nodeCacheByLabel.keySet()) {
                        node = this.nodeCacheByLabel.get(label);
                        log.debug("\t\tKey: Label:" + label + "\tNodeID:" + node.getId());
                    }
                }
                catch (Exception e) {
                    log.error("\tOssDaoOpenNMSImpl().updateNodeCaches: Problem listing nodeCacheByLabel contents. Error:", (Throwable)e);
                }
                try {
                    log.debug("\tOssDaoOpenNMSImpl().updateNodeCaches - Updated nodeCacheByUniqueID : contents :");
                    for (String uniqueID : this.nodeCacheByUniqueID.keySet()) {
                        node = this.nodeCacheByUniqueID.get(uniqueID);
                        log.debug("\t\tKey: uniqueID:" + uniqueID + "\tNodeID:" + node.getId());
                    }
                }
                catch (Exception e) {
                    log.error("\tOssDaoOpenNMSImpl().updateNodeCaches: Problem listing nodeCacheByUniqueID contents Error:", (Throwable)e);
                }
            }
            catch (Throwable ex) {
                log.error("\tOssDaoOpenNMSImpl().updateNodeCaches ERROR : ", ex);
            }
        }
    }
}

