/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.dao.api.RequisitionedCategoryAssociationDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.support.CreateIfNecessaryTemplate;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PathElement;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.RequisitionedCategoryAssociation;
import org.opennms.netmgt.model.events.AddEventVisitor;
import org.opennms.netmgt.model.events.DeleteEventVisitor;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.events.UpdateEventVisitor;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.LocationAwareDetectorClient;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterfaceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.service.DefaultHostnameResolver;
import org.opennms.netmgt.provision.service.EventAccumulator;
import org.opennms.netmgt.provision.service.HostnameResolver;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.PluginRegistry;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.snmp.SnmpProfileMapper;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DefaultProvisionService
implements ProvisionService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProvisionService.class);
    private static final String FOREIGN_SOURCE_FOR_DISCOVERED_NODES = null;
    public static final String PROVISIOND = "Provisiond";
    @Autowired
    private MonitoringLocationDao m_monitoringLocationDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private RequisitionedCategoryAssociationDao m_categoryAssociationDao;
    @Autowired
    @Qualifier(value="transactionAware")
    private EventForwarder m_eventForwarder;
    @Autowired
    @Qualifier(value="fastFused")
    private ForeignSourceRepository m_foreignSourceRepository;
    @Autowired
    @Qualifier(value="fastFilePending")
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    @Autowired
    private PluginRegistry m_pluginRegistry;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private HostnameResolver m_hostnameResolver;
    @Autowired
    private LocationAwareDetectorClient m_locationAwareDetectorClient;
    @Autowired
    private LocationAwareDnsLookupClient m_locationAwareDnsLookuClient;
    @Autowired
    private LocationAwareSnmpClient m_locationAwareSnmpClient;
    @Autowired
    private SnmpProfileMapper snmpProfileMapper;
    private final ThreadLocal<Map<String, OnmsServiceType>> m_typeCache = new ThreadLocal();
    private final ThreadLocal<Map<String, OnmsCategory>> m_categoryCache = new ThreadLocal();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        RequisitionFileUtils.deleteAllSnapshots((ForeignSourceRepository)this.m_pendingForeignSourceRepository);
        this.m_hostnameResolver = new DefaultHostnameResolver(this.m_locationAwareDnsLookuClient);
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return System.getProperty("org.opennms.provisiond.enableDiscovery", "true").equalsIgnoreCase("true");
    }

    private void updateLocation(OnmsNode node) {
        if (node.getLocation() == null) {
            node.setLocation(this.m_monitoringLocationDao.getDefaultLocation());
        } else {
            node.setLocation(this.createLocationIfNecessary(node.getLocation().getLocationName()));
        }
    }

    @Override
    @Transactional
    public void insertNode(OnmsNode node) {
        this.updateLocation(node);
        this.m_nodeDao.save((Object)node);
        this.m_nodeDao.flush();
        AddEventVisitor visitor = new AddEventVisitor(this.m_eventForwarder);
        node.visit((EntityVisitor)visitor);
    }

    @Override
    @Transactional
    public void updateNode(OnmsNode node, String rescanExisting) {
        this.updateLocation(node);
        OnmsNode dbNode = this.m_nodeDao.getHierarchy(node.getId());
        String prevLocation = dbNode.getLocation().getLocationName();
        String currentLocation = node.getLocation().getLocationName();
        node.setCategories(dbNode.getCategories());
        EventAccumulator accumulator = new EventAccumulator(this.m_eventForwarder);
        dbNode.mergeNode(node, (EventForwarder)accumulator, false);
        this.updateNodeHostname(dbNode);
        this.m_nodeDao.update((Object)dbNode);
        this.m_nodeDao.flush();
        if (!prevLocation.equals(currentLocation)) {
            accumulator.sendNow(EventUtils.createNodeLocationChangedEvent((String)PROVISIOND, (Integer)dbNode.getId(), (String)dbNode.getLabel(), (String)prevLocation, (String)currentLocation));
        }
        accumulator.flush();
        UpdateEventVisitor eventAccumlator = new UpdateEventVisitor(this.m_eventForwarder, rescanExisting);
        dbNode.visit((EntityVisitor)eventAccumlator);
    }

    private void updateNodeHostname(OnmsNode node) {
        if (OnmsNode.NodeLabelSource.HOSTNAME.equals((Object)node.getLabelSource()) || OnmsNode.NodeLabelSource.ADDRESS.equals((Object)node.getLabelSource())) {
            OnmsIpInterface primary = node.getPrimaryInterface();
            if (primary == null && node.getIpInterfaces() != null) {
                primary = (OnmsIpInterface)node.getIpInterfaces().iterator().next();
            }
            InetAddress primaryAddr = primary.getIpAddress();
            String primaryHostname = this.getHostnameResolver().getHostname(primaryAddr, node.getLocation().getLocationName());
            if (primaryHostname == null && node.getLabel() != null && OnmsNode.NodeLabelSource.HOSTNAME.equals((Object)node.getLabelSource())) {
                LOG.warn("Previous node label source for address {} was hostname, but it does not currently resolve.  Skipping update.", (Object)InetAddressUtils.str((InetAddress)primaryAddr));
                return;
            }
            for (OnmsIpInterface iface : node.getIpInterfaces()) {
                InetAddress addr = iface.getIpAddress();
                String ipAddress = InetAddressUtils.str((InetAddress)addr);
                String hostname = this.getHostnameResolver().getHostname(addr, node.getLocation().getLocationName());
                if (iface.equals(primary)) {
                    LOG.debug("Node Label was set by hostname or address.  Re-setting.");
                    if (hostname == null || ipAddress.equals(hostname)) {
                        node.setLabel(ipAddress);
                        node.setLabelSource(OnmsNode.NodeLabelSource.ADDRESS);
                    } else {
                        node.setLabel(hostname);
                        node.setLabelSource(OnmsNode.NodeLabelSource.HOSTNAME);
                    }
                }
                if (hostname == null) {
                    iface.setIpHostName(ipAddress);
                    continue;
                }
                iface.setIpHostName(hostname);
            }
        } else {
            LOG.debug("Node label source ({}) is not host or address. Skipping update.", (Object)node.getLabelSource());
        }
    }

    @Override
    @Transactional
    public void deleteNode(Integer nodeId) {
        LOG.debug("deleteNode: nodeId={}", (Object)nodeId);
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        if (node != null) {
            DeleteEventVisitor visitor = new DeleteEventVisitor(this.m_eventForwarder);
            this.m_nodeDao.delete((Object)node);
            this.m_nodeDao.flush();
            node.visit((EntityVisitor)visitor);
        }
    }

    @Override
    @Transactional
    public void deleteInterface(Integer nodeId, String ipAddr) {
        LOG.debug("deleteInterface: nodeId={}, addr={}", (Object)nodeId, (Object)ipAddr);
        OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddr);
        if (iface != null) {
            OnmsNode node = iface.getNode();
            boolean lastInterface = node.getIpInterfaces().size() == 1;
            DeleteEventVisitor visitor = new DeleteEventVisitor(this.m_eventForwarder);
            node.removeIpInterface(iface);
            this.m_nodeDao.saveOrUpdate((Object)node);
            this.m_nodeDao.flush();
            iface.visit((EntityVisitor)visitor);
            if (lastInterface) {
                LOG.debug("Deleting node {}", (Object)nodeId);
                this.m_nodeDao.delete((Object)node);
                this.m_nodeDao.flush();
                node.visit((EntityVisitor)visitor);
            }
        }
    }

    @Override
    @Transactional
    public void deleteService(Integer nodeId, InetAddress addr, String svcName) {
        LOG.debug("deleteService: nodeId={}, addr={}, service={}", new Object[]{nodeId, addr, svcName});
        OnmsMonitoredService service = this.m_monitoredServiceDao.get(nodeId, addr, svcName);
        if (service != null) {
            OnmsIpInterface iface = service.getIpInterface();
            OnmsNode node = iface.getNode();
            boolean lastService = iface.getMonitoredServices().size() == 1;
            boolean lastInterface = node.getIpInterfaces().size() == 1;
            DeleteEventVisitor visitor = new DeleteEventVisitor(this.m_eventForwarder);
            iface.removeMonitoredService(service);
            this.m_nodeDao.saveOrUpdate((Object)node);
            this.m_nodeDao.flush();
            service.visit((EntityVisitor)visitor);
            if (lastService) {
                LOG.debug("Deleting interface {} from node {}", (Object)InetAddressUtils.str((InetAddress)iface.getIpAddress()), (Object)nodeId);
                node.removeIpInterface(iface);
                this.m_nodeDao.saveOrUpdate((Object)node);
                this.m_nodeDao.flush();
                iface.visit((EntityVisitor)visitor);
                if (lastInterface) {
                    LOG.debug("Deleting node {}", (Object)nodeId);
                    this.m_nodeDao.delete((Object)node);
                    this.m_nodeDao.flush();
                    node.visit((EntityVisitor)visitor);
                }
            }
        }
    }

    private void assertNotNull(Object o, String format, Object ... args) {
        if (o == null) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    @Override
    @Transactional
    public OnmsIpInterface updateIpInterfaceAttributes(final Integer nodeId, final OnmsIpInterface scannedIface) {
        OnmsSnmpInterface snmpInterface = scannedIface.getSnmpInterface();
        if (snmpInterface != null && snmpInterface.getIfIndex() != null) {
            scannedIface.setSnmpInterface(this.updateSnmpInterfaceAttributes(nodeId, snmpInterface));
        }
        return (OnmsIpInterface)new UpsertTemplate<OnmsIpInterface, IpInterfaceDao>(this.m_transactionManager, this.m_ipInterfaceDao){

            protected OnmsIpInterface query() {
                OnmsIpInterface dbIface = DefaultProvisionService.this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, InetAddressUtils.str((InetAddress)scannedIface.getIpAddress()));
                LOG.debug("Updating interface attributes for DB interface {} for node {} with ip {}", new Object[]{dbIface, nodeId, InetAddressUtils.str((InetAddress)scannedIface.getIpAddress())});
                return dbIface;
            }

            protected OnmsIpInterface doUpdate(OnmsIpInterface dbIface) {
                EventAccumulator accumulator = new EventAccumulator(DefaultProvisionService.this.m_eventForwarder);
                if (dbIface.isManaged() && !scannedIface.isManaged()) {
                    Set monSvcs = dbIface.getMonitoredServices();
                    for (OnmsMonitoredService monSvc : monSvcs) {
                        monSvc.visit((EntityVisitor)new DeleteEventVisitor((EventForwarder)accumulator));
                    }
                    monSvcs.clear();
                }
                dbIface.updateSnmpInterface(scannedIface);
                dbIface.mergeInterfaceAttributes(scannedIface);
                LOG.info("Updating IpInterface {}", (Object)dbIface);
                DefaultProvisionService.this.m_ipInterfaceDao.update((Object)dbIface);
                DefaultProvisionService.this.m_ipInterfaceDao.flush();
                accumulator.flush();
                return dbIface;
            }

            protected OnmsIpInterface doInsert() {
                OnmsNode dbNode = (OnmsNode)DefaultProvisionService.this.m_nodeDao.load((Serializable)nodeId);
                DefaultProvisionService.this.assertNotNull(dbNode, "no node found with nodeId %d", new Object[]{nodeId});
                scannedIface.setNode(dbNode);
                DefaultProvisionService.this.saveOrUpdate(scannedIface);
                DefaultProvisionService.this.m_ipInterfaceDao.flush();
                AddEventVisitor visitor = new AddEventVisitor(DefaultProvisionService.this.m_eventForwarder);
                scannedIface.visit((EntityVisitor)visitor);
                return scannedIface;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsSnmpInterface updateSnmpInterfaceAttributes(final Integer nodeId, final OnmsSnmpInterface snmpInterface) {
        return (OnmsSnmpInterface)new UpsertTemplate<OnmsSnmpInterface, SnmpInterfaceDao>(this.m_transactionManager, this.m_snmpInterfaceDao){

            public OnmsSnmpInterface query() {
                OnmsSnmpInterface dbSnmpIface = DefaultProvisionService.this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(nodeId, snmpInterface.getIfIndex());
                LOG.debug("nodeId = {}, ifIndex = {}, dbSnmpIface = {}", new Object[]{nodeId, snmpInterface.getIfIndex(), dbSnmpIface});
                return dbSnmpIface;
            }

            public OnmsSnmpInterface doUpdate(OnmsSnmpInterface dbSnmpIface) {
                dbSnmpIface.mergeSnmpInterfaceAttributes(snmpInterface);
                LOG.info("Updating SnmpInterface {}", (Object)dbSnmpIface);
                DefaultProvisionService.this.m_snmpInterfaceDao.update((Object)dbSnmpIface);
                DefaultProvisionService.this.m_snmpInterfaceDao.flush();
                return dbSnmpIface;
            }

            public OnmsSnmpInterface doInsert() {
                OnmsNode dbNode = (OnmsNode)DefaultProvisionService.this.m_nodeDao.load((Serializable)nodeId);
                DefaultProvisionService.this.assertNotNull(dbNode, "no node found with nodeId %d", new Object[]{nodeId});
                snmpInterface.setNode(dbNode);
                LOG.info("Saving SnmpInterface {}", (Object)snmpInterface);
                DefaultProvisionService.this.m_snmpInterfaceDao.save((Object)snmpInterface);
                DefaultProvisionService.this.m_snmpInterfaceDao.flush();
                return snmpInterface;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsMonitoredService addMonitoredService(Integer ipInterfaceId, String svcName) {
        OnmsIpInterface iface = (OnmsIpInterface)this.m_ipInterfaceDao.get((Serializable)ipInterfaceId);
        this.assertNotNull(iface, "could not find interface with id %d", ipInterfaceId);
        return this.addMonitoredService(iface, svcName);
    }

    private OnmsMonitoredService addMonitoredService(final OnmsIpInterface iface, final String svcName) {
        final OnmsServiceType svcType = this.createServiceTypeIfNecessary(svcName);
        return (OnmsMonitoredService)new CreateIfNecessaryTemplate<OnmsMonitoredService, MonitoredServiceDao>(this.m_transactionManager, this.m_monitoredServiceDao){

            protected OnmsMonitoredService query() {
                return iface.getMonitoredServiceByServiceType(svcName);
            }

            protected OnmsMonitoredService doInsert() {
                OnmsMonitoredService svc = new OnmsMonitoredService(iface, svcType);
                svc.setStatus("A");
                DefaultProvisionService.this.m_ipInterfaceDao.saveOrUpdate((Object)iface);
                DefaultProvisionService.this.m_ipInterfaceDao.flush();
                AddEventVisitor visitor = new AddEventVisitor(DefaultProvisionService.this.m_eventForwarder);
                svc.visit((EntityVisitor)visitor);
                return svc;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsMonitoredService addMonitoredService(Integer nodeId, String ipAddress, String svcName) {
        OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
        this.assertNotNull(iface, "could not find interface with nodeid %d and ipAddr %s", nodeId, ipAddress);
        return this.addMonitoredService(iface, svcName);
    }

    @Override
    @Transactional
    public OnmsMonitoredService updateMonitoredServiceState(Integer nodeId, String ipAddress, final String svcName) {
        final OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
        this.assertNotNull(iface, "could not find interface with nodeid %d and ipAddr %s", nodeId, ipAddress);
        return (OnmsMonitoredService)new UpsertTemplate<OnmsMonitoredService, MonitoredServiceDao>(this.m_transactionManager, this.m_monitoredServiceDao){

            protected OnmsMonitoredService query() {
                return iface.getMonitoredServiceByServiceType(svcName);
            }

            protected OnmsMonitoredService doUpdate(OnmsMonitoredService dbObj) {
                LOG.debug("current status of service {} on node with IP {} is {} ", new Object[]{dbObj.getServiceName(), dbObj.getIpAddress().getHostAddress(), dbObj.getStatus()});
                switch (dbObj.getStatus()) {
                    case "S": {
                        LOG.debug("suspending polling for service {} on node with IP {}", (Object)dbObj.getServiceName(), (Object)dbObj.getIpAddress().getHostAddress());
                        dbObj.setStatus("F");
                        DefaultProvisionService.this.m_monitoredServiceDao.update((Object)dbObj);
                        this.sendEvent("uei.opennms.org/internal/poller/suspendPollingService", dbObj);
                        break;
                    }
                    case "R": {
                        LOG.debug("resume polling for service {} on node with IP {}", (Object)dbObj.getServiceName(), (Object)dbObj.getIpAddress().getHostAddress());
                        dbObj.setStatus("A");
                        DefaultProvisionService.this.m_monitoredServiceDao.update((Object)dbObj);
                        this.sendEvent("uei.opennms.org/internal/poller/resumePollingService", dbObj);
                        break;
                    }
                    case "A": {
                        break;
                    }
                    case "N": {
                        break;
                    }
                    default: {
                        LOG.warn("Unhandled state: {}", (Object)dbObj.getStatus());
                    }
                }
                return dbObj;
            }

            protected OnmsMonitoredService doInsert() {
                return null;
            }

            private void sendEvent(String eventUEI, OnmsMonitoredService dbObj) {
                EventBuilder bldr = new EventBuilder(eventUEI, "ProvisionService");
                bldr.setNodeid((long)dbObj.getNodeId().intValue());
                bldr.setInterface(dbObj.getIpAddress());
                bldr.setService(dbObj.getServiceName());
                DefaultProvisionService.this.m_eventForwarder.sendNow(bldr.getEvent());
            }
        }.execute();
    }

    @Override
    @Transactional
    public void clearCache() {
        this.m_nodeDao.clear();
        this.m_nodeDao.flush();
    }

    @Override
    public OnmsMonitoringLocation createLocationIfNecessary(String locationName) {
        if (locationName == null) {
            return this.createLocationIfNecessary("Default");
        }
        OnmsMonitoringLocation location = new OnmsMonitoringLocation();
        location.setLocationName(locationName);
        location.setMonitoringArea(locationName);
        return this.createLocationDefIfNecessary(location);
    }

    protected OnmsMonitoringLocation createLocationDefIfNecessary(final OnmsMonitoringLocation location) {
        return (OnmsMonitoringLocation)new CreateIfNecessaryTemplate<OnmsMonitoringLocation, MonitoringLocationDao>(this.m_transactionManager, this.m_monitoringLocationDao){

            protected OnmsMonitoringLocation query() {
                return (OnmsMonitoringLocation)((MonitoringLocationDao)this.m_dao).get((Serializable)((Object)location.getLocationName()));
            }

            public OnmsMonitoringLocation doInsert() {
                ((MonitoringLocationDao)this.m_dao).save((Object)location);
                ((MonitoringLocationDao)this.m_dao).flush();
                return location;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsNode getRequisitionedNode(String foreignSource, String foreignId) throws ForeignSourceRepositoryException {
        OnmsNodeRequisition nodeReq = null;
        try {
            nodeReq = this.m_foreignSourceRepository.getNodeRequisition(foreignSource, foreignId);
        }
        catch (ForeignSourceRepositoryException foreignSourceRepositoryException) {
            // empty catch block
        }
        if (nodeReq == null) {
            LOG.warn("nodeReq for node {}:{} cannot be null!", (Object)foreignSource, (Object)foreignId);
            return null;
        }
        OnmsNode node = nodeReq.constructOnmsNodeFromRequisition();
        HashSet<OnmsCategory> dbCategories = new HashSet<OnmsCategory>();
        for (OnmsCategory category : node.getCategories()) {
            dbCategories.add(this.createCategoryIfNecessary(category.getName()));
        }
        node.setCategories(dbCategories);
        if (node.getLocation() == null || Strings.isNullOrEmpty((String)node.getLocation().getLocationName())) {
            node.setLocation(this.m_monitoringLocationDao.getDefaultLocation());
        }
        node.visit((EntityVisitor)new ServiceTypeFulfiller());
        return node;
    }

    @Override
    @Transactional
    public OnmsServiceType createServiceTypeIfNecessary(String serviceName) {
        this.preloadExistingTypes();
        OnmsServiceType type = this.m_typeCache.get().get(serviceName);
        if (type == null) {
            type = this.loadServiceType(serviceName);
            this.m_typeCache.get().put(serviceName, type);
        }
        return type;
    }

    @Override
    @Transactional
    public OnmsCategory createCategoryIfNecessary(String name) {
        this.preloadExistingCategories();
        OnmsCategory category = this.m_categoryCache.get().get(name);
        if (category == null) {
            category = this.loadCategory(name);
            this.m_categoryCache.get().put(category.getName(), category);
        }
        return category;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Integer> getForeignIdToNodeIdMap(String foreignSource) {
        return this.m_nodeDao.getForeignIdToNodeIdMap(foreignSource);
    }

    @Override
    @Transactional
    public void setNodeParentAndDependencies(String foreignSource, String foreignId, String parentForeignSource, String parentForeignId, String parentNodeLabel) {
        OnmsNode node = this.findNodebyForeignId(foreignSource, foreignId);
        if (node == null) {
            return;
        }
        OnmsNode parent = this.findParent(parentForeignSource, parentForeignId, parentNodeLabel);
        this.setParent(node, parent);
        this.setPathDependency(node, parent);
        this.m_nodeDao.update((Object)node);
        this.m_nodeDao.flush();
    }

    private void preloadExistingTypes() {
        if (this.m_typeCache.get() == null) {
            this.m_typeCache.set(this.loadServiceTypeMap());
        }
    }

    @Transactional(readOnly=true)
    private Map<String, OnmsServiceType> loadServiceTypeMap() {
        HashMap<String, OnmsServiceType> serviceTypeMap = new HashMap<String, OnmsServiceType>();
        for (OnmsServiceType svcType : this.m_serviceTypeDao.findAll()) {
            serviceTypeMap.put(svcType.getName(), svcType);
        }
        return serviceTypeMap;
    }

    @Transactional
    private OnmsServiceType loadServiceType(final String serviceName) {
        return (OnmsServiceType)new CreateIfNecessaryTemplate<OnmsServiceType, ServiceTypeDao>(this.m_transactionManager, this.m_serviceTypeDao){

            protected OnmsServiceType query() {
                return DefaultProvisionService.this.m_serviceTypeDao.findByName(serviceName);
            }

            public OnmsServiceType doInsert() {
                OnmsServiceType type = new OnmsServiceType(serviceName);
                DefaultProvisionService.this.m_serviceTypeDao.save((Object)type);
                DefaultProvisionService.this.m_serviceTypeDao.flush();
                return type;
            }
        }.execute();
    }

    private void preloadExistingCategories() {
        if (this.m_categoryCache.get() == null) {
            this.m_categoryCache.set(this.loadCategoryMap());
        }
    }

    @Transactional(readOnly=true)
    private Map<String, OnmsCategory> loadCategoryMap() {
        HashMap<String, OnmsCategory> categoryMap = new HashMap<String, OnmsCategory>();
        for (OnmsCategory category : this.m_categoryDao.findAll()) {
            categoryMap.put(category.getName(), category);
        }
        return categoryMap;
    }

    @Transactional
    private OnmsCategory loadCategory(final String name) {
        return (OnmsCategory)new CreateIfNecessaryTemplate<OnmsCategory, CategoryDao>(this.m_transactionManager, this.m_categoryDao){

            protected OnmsCategory query() {
                return DefaultProvisionService.this.m_categoryDao.findByName(name);
            }

            public OnmsCategory doInsert() {
                OnmsCategory category = new OnmsCategory(name);
                DefaultProvisionService.this.m_categoryDao.save((Object)category);
                DefaultProvisionService.this.m_categoryDao.flush();
                return category;
            }
        }.execute();
    }

    @Transactional(readOnly=true)
    private OnmsNode findNodebyNodeLabel(String label) {
        List nodes = this.m_nodeDao.findByLabel(label);
        if (nodes.size() == 1) {
            return (OnmsNode)nodes.iterator().next();
        }
        LOG.error("Unable to locate a unique node using label {}: {} nodes found.  Ignoring relationship.", (Object)label, (Object)nodes.size());
        return null;
    }

    @Transactional(readOnly=true)
    private OnmsNode findNodebyForeignId(String foreignSource, String foreignId) {
        return this.m_nodeDao.findByForeignId(foreignSource, foreignId);
    }

    @Transactional(readOnly=true)
    private OnmsNode findParent(String foreignSource, String parentForeignId, String parentNodeLabel) {
        if (parentForeignId != null) {
            return this.findNodebyForeignId(foreignSource, parentForeignId);
        }
        if (parentNodeLabel != null) {
            return this.findNodebyNodeLabel(parentNodeLabel);
        }
        return null;
    }

    private void setPathDependency(OnmsNode node, OnmsNode parent) {
        if (node == null) {
            return;
        }
        OnmsIpInterface critIface = null;
        if (parent != null) {
            critIface = parent.getCriticalInterface();
        }
        LOG.info("Setting criticalInterface of node: {} to: {}", (Object)node, (Object)critIface);
        node.setPathElement(critIface == null ? null : new PathElement(InetAddressUtils.str((InetAddress)critIface.getIpAddress()), "ICMP"));
    }

    @Transactional
    private void setParent(OnmsNode node, OnmsNode parent) {
        if (node == null) {
            return;
        }
        LOG.info("Setting parent of node: {} to: {}", (Object)node, (Object)parent);
        node.setParent(parent);
        this.m_nodeDao.update((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional(readOnly=true)
    public NodeScanSchedule getScheduleForNode(int nodeId, boolean force) {
        return this.createScheduleForNode((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId)), force);
    }

    @Override
    @Transactional(readOnly=true)
    public List<NodeScanSchedule> getScheduleForNodes() {
        Assert.notNull((Object)this.m_nodeDao, (String)"Node DAO is null and is not supposed to be");
        List nodes = this.isDiscoveryEnabled() ? this.m_nodeDao.findAll() : this.m_nodeDao.findAllProvisionedNodes();
        ArrayList<NodeScanSchedule> scheduledNodes = new ArrayList<NodeScanSchedule>();
        for (OnmsNode node : nodes) {
            NodeScanSchedule nodeScanSchedule = this.createScheduleForNode(node, false);
            if (nodeScanSchedule == null) continue;
            scheduledNodes.add(nodeScanSchedule);
        }
        return scheduledNodes;
    }

    private NodeScanSchedule createScheduleForNode(OnmsNode node, boolean force) {
        Assert.notNull((Object)node, (String)"Node may not be null");
        String actualForeignSource = node.getForeignSource();
        if (actualForeignSource == null && !this.isDiscoveryEnabled()) {
            LOG.info("Not scheduling node {} to be scanned since it has a null foreignSource and handling of discovered nodes is disabled in provisiond", (Object)node);
            return null;
        }
        String effectiveForeignSource = actualForeignSource == null ? "default" : actualForeignSource;
        try {
            DateTime now;
            DateTime nextPoll;
            ForeignSource fs = this.m_foreignSourceRepository.getForeignSource(effectiveForeignSource);
            Duration scanInterval = fs.getScanInterval();
            if (scanInterval.getMillis() <= 0L) {
                LOG.debug("Node ({}/{}/{}) scan interval is zero, skipping schedule.", new Object[]{node.getId(), node.getForeignSource(), node.getForeignId()});
                return null;
            }
            Duration initialDelay = Duration.ZERO;
            if (node.getLastCapsdPoll() != null && !force && (nextPoll = new DateTime(node.getLastCapsdPoll().getTime()).plus((ReadableDuration)scanInterval)).isAfter((ReadableInstant)(now = new DateTime()))) {
                initialDelay = new Duration((ReadableInstant)now, (ReadableInstant)nextPoll);
            }
            return new NodeScanSchedule(node.getId(), actualForeignSource, node.getForeignId(), node.getLocation(), initialDelay, scanInterval);
        }
        catch (ForeignSourceRepositoryException e) {
            LOG.warn("unable to get foreign source '{}' from repository", (Object)effectiveForeignSource, (Object)e);
            return null;
        }
    }

    @Override
    public void setForeignSourceRepository(ForeignSourceRepository foreignSourceRepository) {
        this.m_foreignSourceRepository = foreignSourceRepository;
    }

    public ForeignSourceRepository getForeignSourceRepository() {
        return this.m_foreignSourceRepository;
    }

    @Override
    public Requisition loadRequisition(Resource resource) {
        Requisition r = this.m_foreignSourceRepository.importResourceRequisition(resource);
        r.updateLastImported();
        this.m_foreignSourceRepository.save(r);
        this.m_foreignSourceRepository.flush();
        return r;
    }

    @Override
    @Transactional
    public OnmsNode updateNodeAttributes(final OnmsNode node) {
        return (OnmsNode)new UpsertTemplate<OnmsNode, NodeDao>(this.m_transactionManager, this.m_nodeDao){
            private final List<String> m_categoriesAdded;
            private final List<String> m_categoriesDeleted;
            {
                super(x0, (OnmsDao)x1);
                this.m_categoriesAdded = new ArrayList<String>();
                this.m_categoriesDeleted = new ArrayList<String>();
            }

            protected OnmsNode query() {
                return DefaultProvisionService.this.getDbNode(node);
            }

            private boolean handleCategoryChanges(OnmsNode dbNode) {
                OnmsNodeRequisition req;
                String foreignSource = dbNode.getForeignSource();
                ArrayList<String> categories = new ArrayList<String>();
                boolean changed = false;
                if (foreignSource != null && (req = DefaultProvisionService.this.m_foreignSourceRepository.getNodeRequisition(foreignSource, dbNode.getForeignId())) != null && req.getNode() != null) {
                    for (RequisitionCategory requisitionCategory : req.getNode().getCategories()) {
                        categories.add(requisitionCategory.getName());
                    }
                }
                for (String cat : node.getRequisitionedCategories()) {
                    categories.add(cat);
                }
                LOG.debug("Node {}/{}/{} has the following requisitioned categories: {}", new Object[]{dbNode.getId(), foreignSource, dbNode.getForeignId(), categories});
                ArrayList reqCats = new ArrayList(DefaultProvisionService.this.m_categoryAssociationDao.findByNodeId(dbNode.getId()));
                Iterator reqIter = reqCats.iterator();
                while (reqIter.hasNext()) {
                    RequisitionedCategoryAssociation requisitionedCategoryAssociation = (RequisitionedCategoryAssociation)reqIter.next();
                    String categoryName = requisitionedCategoryAssociation.getCategory().getName();
                    if (categories.contains(categoryName)) {
                        categories.remove(categoryName);
                        continue;
                    }
                    LOG.debug("Node {}/{}/{} no longer has the category: {}", new Object[]{dbNode.getId(), foreignSource, dbNode.getForeignId(), categoryName});
                    this.m_categoriesDeleted.add(categoryName);
                    dbNode.removeCategory(requisitionedCategoryAssociation.getCategory());
                    node.removeCategory(requisitionedCategoryAssociation.getCategory());
                    reqIter.remove();
                    DefaultProvisionService.this.m_categoryAssociationDao.delete((Object)requisitionedCategoryAssociation);
                    changed = true;
                }
                for (String string : categories) {
                    this.m_categoriesAdded.add(string);
                    OnmsCategory onmsCat = DefaultProvisionService.this.createCategoryIfNecessary(string);
                    RequisitionedCategoryAssociation r = new RequisitionedCategoryAssociation(dbNode, onmsCat);
                    node.addCategory(onmsCat);
                    dbNode.addCategory(onmsCat);
                    DefaultProvisionService.this.m_categoryAssociationDao.saveOrUpdate((Object)r);
                    changed = true;
                }
                DefaultProvisionService.this.m_categoryAssociationDao.flush();
                return changed;
            }

            protected OnmsNode doUpdate(OnmsNode dbNode) {
                if (dbNode.getLocation() == null) {
                    dbNode.setLocation(DefaultProvisionService.this.createLocationIfNecessary(node.getLocation() == null ? null : node.getLocation().getLocationName()));
                }
                LOG.debug("Associating node {}/{}/{} with location: {}", new Object[]{dbNode.getId(), dbNode.getForeignSource(), dbNode.getForeignId(), dbNode.getLocation()});
                EventAccumulator accumulator = new EventAccumulator(DefaultProvisionService.this.m_eventForwarder);
                boolean changed = this.handleCategoryChanges(dbNode);
                dbNode.mergeNodeAttributes(node, (EventForwarder)accumulator);
                node.getAssetRecord().setId(dbNode.getAssetRecord().getId());
                node.setId(dbNode.getId());
                dbNode.mergeAssets(node);
                DefaultProvisionService.this.updateNodeHostname(dbNode);
                OnmsNode ret = DefaultProvisionService.this.saveOrUpdate(dbNode);
                if (changed) {
                    accumulator.sendNow(EventUtils.createNodeCategoryMembershipChangedEvent((String)DefaultProvisionService.PROVISIOND, (Integer)ret.getId(), (String)ret.getLabel(), (String[])this.m_categoriesAdded.toArray(new String[0]), (String[])this.m_categoriesDeleted.toArray(new String[0])));
                    LOG.debug("Node {}/{}/{} categories changed: {}", new Object[]{dbNode.getId(), dbNode.getForeignSource(), dbNode.getForeignId(), DefaultProvisionService.this.getCategoriesForNode(dbNode)});
                } else {
                    LOG.debug("Node {}/{}/{} categories unchanged: {}", new Object[]{dbNode.getId(), dbNode.getForeignSource(), dbNode.getForeignId(), DefaultProvisionService.this.getCategoriesForNode(dbNode)});
                }
                if (dbNode.getLocation() != null && node.getLocation() != null && !node.getLocation().getLocationName().equals(dbNode.getLocation().getLocationName())) {
                    accumulator.sendNow(EventUtils.createNodeLocationChangedEvent((String)DefaultProvisionService.PROVISIOND, (Integer)ret.getId(), (String)ret.getLabel(), (String)ret.getLocation().getLocationName(), (String)node.getLocation().getLocationName()));
                }
                accumulator.flush();
                return ret;
            }

            protected OnmsNode doInsert() {
                return DefaultProvisionService.this.saveOrUpdate(node);
            }
        }.execute();
    }

    public Set<String> getCategoriesForNode(OnmsNode node) {
        TreeSet<String> categories = new TreeSet<String>();
        for (OnmsCategory cat : node.getCategories()) {
            categories.add(cat.getName());
        }
        return categories;
    }

    @Transactional(readOnly=true)
    private OnmsNode getDbNode(OnmsNode node) {
        OnmsNode dbNode = node.getId() != null ? (OnmsNode)this.m_nodeDao.get((Serializable)node.getId()) : this.m_nodeDao.findByForeignId(node.getForeignSource(), node.getForeignId());
        return dbNode;
    }

    @Transactional
    private OnmsNode saveOrUpdate(OnmsNode node) {
        HashSet<OnmsCategory> updatedCategories = new HashSet<OnmsCategory>();
        Iterator it = node.getCategories().iterator();
        while (it.hasNext()) {
            OnmsCategory category = (OnmsCategory)it.next();
            if (category.getId() != null) continue;
            it.remove();
            updatedCategories.add(this.createCategoryIfNecessary(category.getName()));
        }
        node.getCategories().addAll(updatedCategories);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
        return node;
    }

    @Transactional
    private OnmsIpInterface saveOrUpdate(OnmsIpInterface iface) {
        iface.visit((EntityVisitor)new ServiceTypeFulfiller());
        LOG.info("SaveOrUpdating IpInterface {}", (Object)iface);
        this.m_ipInterfaceDao.saveOrUpdate((Object)iface);
        this.m_ipInterfaceDao.flush();
        return iface;
    }

    @Override
    public List<PluginConfig> getDetectorsForForeignSource(String foreignSourceName) {
        ForeignSource foreignSource = this.m_foreignSourceRepository.getForeignSource(foreignSourceName);
        this.assertNotNull(foreignSource, "Expected a foreignSource with name %s", foreignSourceName);
        return foreignSource.getDetectors();
    }

    @Override
    public List<NodePolicy> getNodePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(NodePolicy.class, foreignSourceName);
    }

    @Override
    public List<IpInterfacePolicy> getIpInterfacePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(IpInterfacePolicy.class, foreignSourceName);
    }

    @Override
    public List<SnmpInterfacePolicy> getSnmpInterfacePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(SnmpInterfacePolicy.class, foreignSourceName);
    }

    public <T> List<T> getPluginsForForeignSource(Class<T> pluginClass, String foreignSourceName) {
        ForeignSource foreignSource = this.m_foreignSourceRepository.getForeignSource(foreignSourceName);
        this.assertNotNull(foreignSource, "Expected a foreignSource with name %s", foreignSourceName);
        List configs = foreignSource.getPolicies();
        if (configs == null) {
            return Collections.emptyList();
        }
        ArrayList<T> plugins = new ArrayList<T>(configs.size());
        for (PluginConfig config : configs) {
            T plugin = this.m_pluginRegistry.getPluginInstance(pluginClass, config);
            if (plugin == null) {
                LOG.trace("Configured plugin is not appropropriate for policy class {}: {}", pluginClass, (Object)config);
                continue;
            }
            plugins.add(plugin);
        }
        return plugins;
    }

    @Override
    @Transactional
    public void deleteObsoleteInterfaces(Integer nodeId, Date scanStamp) {
        List obsoleteInterfaces = this.m_nodeDao.findObsoleteIpInterfaces(nodeId, scanStamp);
        EventAccumulator accumulator = new EventAccumulator(this.m_eventForwarder);
        for (OnmsIpInterface iface : obsoleteInterfaces) {
            iface.visit((EntityVisitor)new DeleteEventVisitor((EventForwarder)accumulator));
        }
        this.m_nodeDao.deleteObsoleteInterfaces(nodeId, scanStamp);
        accumulator.flush();
    }

    @Override
    @Transactional
    public void updateNodeScanStamp(Integer nodeId, Date scanStamp) {
        this.m_nodeDao.updateNodeScanStamp(nodeId, scanStamp);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional
    public OnmsIpInterface setIsPrimaryFlag(Integer nodeId, String ipAddress) {
        if (nodeId == null) {
            LOG.debug("nodeId is null!");
            return null;
        }
        if (ipAddress == null) {
            LOG.debug("ipAddress is null!");
            return null;
        }
        OnmsIpInterface svcIface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
        if (svcIface == null) {
            LOG.info("unable to find IPInterface for nodeId={}, ipAddress={}", (Object)nodeId, (Object)ipAddress);
            return null;
        }
        OnmsIpInterface primaryIface = null;
        if (svcIface.isPrimary()) {
            primaryIface = svcIface;
        } else if (svcIface.getNode().getPrimaryInterface() == null) {
            svcIface.setIsSnmpPrimary(PrimaryType.PRIMARY);
            this.m_ipInterfaceDao.saveOrUpdate((Object)svcIface);
            this.m_ipInterfaceDao.flush();
            primaryIface = svcIface;
        } else {
            svcIface.setIsSnmpPrimary(PrimaryType.SECONDARY);
            this.m_ipInterfaceDao.saveOrUpdate((Object)svcIface);
            this.m_ipInterfaceDao.flush();
        }
        this.m_ipInterfaceDao.initialize((Object)primaryIface);
        return primaryIface;
    }

    @Override
    @Transactional
    public OnmsIpInterface getPrimaryInterfaceForNode(OnmsNode node) {
        OnmsNode dbNode = this.getDbNode(node);
        if (dbNode == null) {
            return null;
        }
        OnmsIpInterface primaryIface = dbNode.getPrimaryInterface();
        if (primaryIface != null) {
            this.m_ipInterfaceDao.initialize((Object)primaryIface);
            this.m_ipInterfaceDao.initialize((Object)primaryIface.getMonitoredServices());
        }
        return primaryIface;
    }

    @Override
    @Transactional
    public OnmsNode createUndiscoveredNode(final String ipAddress, String foreignSource, String locationString) {
        String effectiveLocationName;
        final String effectiveForeignSource = foreignSource == null ? FOREIGN_SOURCE_FOR_DISCOVERED_NODES : foreignSource;
        OnmsNode node = (OnmsNode)new UpsertTemplate<OnmsNode, NodeDao>(this.m_transactionManager, this.m_nodeDao, effectiveLocationName = MonitoringLocationUtils.isDefaultLocationName((String)locationString) ? null : locationString, locationString){
            final /* synthetic */ String val$effectiveLocationName;
            final /* synthetic */ String val$locationString;
            {
                this.val$effectiveLocationName = string3;
                this.val$locationString = string4;
                super(x0, (OnmsDao)x1);
            }

            protected OnmsNode query() {
                return DefaultProvisionService.this.m_nodeDao.findByForeignSourceAndIpAddress(effectiveForeignSource, ipAddress).stream().filter(n -> {
                    String existingLocationName = MonitoringLocationUtils.getLocationNameOrNullIfDefault((OnmsNode)n);
                    return Objects.equals(existingLocationName, this.val$effectiveLocationName);
                }).findFirst().orElse(null);
            }

            protected OnmsNode doUpdate(OnmsNode existingNode) {
                return null;
            }

            protected OnmsNode doInsert() {
                Date now = new Date();
                OnmsMonitoringLocation location = DefaultProvisionService.this.createLocationIfNecessary(this.val$locationString);
                OnmsNode node = new OnmsNode(location);
                String hostname = DefaultProvisionService.this.getHostnameResolver().getHostname(InetAddressUtils.addr((String)ipAddress), this.val$locationString);
                if (hostname == null || ipAddress.equals(hostname)) {
                    node.setLabel(ipAddress);
                    node.setLabelSource(OnmsNode.NodeLabelSource.ADDRESS);
                } else {
                    node.setLabel(hostname);
                    node.setLabelSource(OnmsNode.NodeLabelSource.HOSTNAME);
                }
                node.setForeignSource(effectiveForeignSource);
                node.setType(OnmsNode.NodeType.ACTIVE);
                node.setLastCapsdPoll(now);
                OnmsIpInterface iface = new OnmsIpInterface(InetAddressUtils.addr((String)ipAddress), node);
                iface.setIsManaged("M");
                iface.setIpHostName(hostname);
                iface.setIsSnmpPrimary(PrimaryType.NOT_ELIGIBLE);
                iface.setIpLastCapsdPoll(now);
                DefaultProvisionService.this.m_nodeDao.save((Object)node);
                DefaultProvisionService.this.m_nodeDao.flush();
                return node;
            }
        }.execute();
        if (node != null) {
            if (effectiveForeignSource != null) {
                node.setForeignId(node.getNodeId());
                this.createUpdateRequistion(ipAddress, node, effectiveLocationName, effectiveForeignSource);
            }
            node.visit((EntityVisitor)new AddEventVisitor(this.m_eventForwarder));
        }
        return node;
    }

    private boolean createUpdateRequistion(String addrString, OnmsNode node, String locationName, String m_foreignSource) {
        LOG.debug("Creating/Updating requistion {} for newSuspect {}...", (Object)m_foreignSource, (Object)addrString);
        try {
            Requisition r = null;
            if (m_foreignSource != null && (r = this.m_foreignSourceRepository.getRequisition(m_foreignSource)) == null) {
                r = new Requisition(m_foreignSource);
            }
            r.updateDateStamp();
            RequisitionNode rn = new RequisitionNode();
            RequisitionInterface iface = new RequisitionInterface();
            iface.setDescr("disc-if");
            iface.setIpAddr(addrString);
            iface.setManaged(Boolean.valueOf(true));
            iface.setSnmpPrimary(PrimaryType.PRIMARY);
            iface.setStatus(Integer.valueOf(1));
            RequisitionInterfaceCollection ric = new RequisitionInterfaceCollection();
            ric.add((Object)iface);
            rn.setInterfaces((Collection)ric.getObjects());
            rn.setBuilding(m_foreignSource);
            rn.setForeignId(node.getForeignId());
            rn.setNodeLabel(node.getLabel());
            rn.setLocation(locationName);
            r.putNode(rn);
            this.m_foreignSourceRepository.save(r);
            this.m_foreignSourceRepository.flush();
        }
        catch (ForeignSourceRepositoryException e) {
            LOG.error("Couldn't create/update requistion for newSuspect " + addrString, (Throwable)e);
            return false;
        }
        LOG.debug("Created/Updated requistion {} for newSuspect {}.", (Object)m_foreignSource, (Object)addrString);
        return true;
    }

    @Override
    @Transactional
    public OnmsNode getNode(Integer nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        this.m_nodeDao.initialize((Object)node);
        this.m_nodeDao.initialize((Object)node.getCategories());
        this.m_nodeDao.initialize((Object)node.getIpInterfaces());
        this.m_nodeDao.initialize((Object)node.getLocation());
        return node;
    }

    @Override
    @Transactional
    public OnmsNode getDbNodeInitCat(Integer nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        this.m_nodeDao.initialize((Object)node);
        this.m_nodeDao.initialize((Object)node.getCategories());
        this.m_nodeDao.initialize((Object)node.getLocation());
        return node;
    }

    @Override
    public void setHostnameResolver(HostnameResolver resolver) {
        this.m_hostnameResolver = resolver;
    }

    @Override
    public HostnameResolver getHostnameResolver() {
        return this.m_hostnameResolver;
    }

    @Override
    public LocationAwareDetectorClient getLocationAwareDetectorClient() {
        return this.m_locationAwareDetectorClient;
    }

    @Override
    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.m_locationAwareSnmpClient;
    }

    @Override
    public SnmpProfileMapper getSnmpProfileMapper() {
        return this.snmpProfileMapper;
    }

    @Override
    public LocationAwareDnsLookupClient getLocationAwareDnsLookupClient() {
        return this.m_locationAwareDnsLookuClient;
    }

    private final class ServiceTypeFulfiller
    extends AbstractEntityVisitor {
        private ServiceTypeFulfiller() {
        }

        public void visitMonitoredService(OnmsMonitoredService monSvc) {
            OnmsServiceType dbType = monSvc.getServiceType();
            if (dbType.getId() == null) {
                dbType = DefaultProvisionService.this.createServiceTypeIfNecessary(dbType.getName());
            }
            monSvc.setServiceType(dbType);
        }
    }
}

