/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.stream.Collectors;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.foreignsource.PluginParameter;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DetectorRunner
implements Async<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorRunner.class);
    private final ProvisionService m_service;
    private final PluginConfig m_detectorConfig;
    private final Integer m_nodeId;
    private final InetAddress m_address;
    private final OnmsMonitoringLocation m_location;

    public DetectorRunner(ProvisionService service, PluginConfig detectorConfig, Integer nodeId, InetAddress address, OnmsMonitoringLocation location) {
        this.m_service = service;
        this.m_detectorConfig = detectorConfig;
        this.m_nodeId = nodeId;
        this.m_address = address;
        this.m_location = location;
    }

    public void supplyAsyncThenAccept(Callback<Boolean> cb) {
        try {
            LOG.info("Attemping to detect service {} on address {} at location {}", new Object[]{this.m_detectorConfig.getName(), this.getHostAddress(), this.getLocationName()});
            this.m_service.getLocationAwareDetectorClient().detect().withClassName(this.m_detectorConfig.getPluginClass()).withAddress(this.m_address).withNodeId(this.m_nodeId).withLocation(this.getLocationName()).withAttributes(this.m_detectorConfig.getParameters().stream().collect(Collectors.toMap(PluginParameter::getKey, PluginParameter::getValue))).execute().whenComplete((res, ex) -> {
                LOG.info("Completed detector execution for service {} on address {} at location {}", new Object[]{this.m_detectorConfig.getName(), this.getHostAddress(), this.getLocationName()});
                if (ex != null) {
                    cb.handleException(ex);
                } else {
                    cb.accept(res);
                }
            });
        }
        catch (Throwable e) {
            cb.handleException(e);
        }
    }

    private String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.m_address);
    }

    private String getLocationName() {
        return this.m_location != null ? this.m_location.getLocationName() : null;
    }

    public String toString() {
        return String.format("Run detector %s on address %s", this.m_detectorConfig.getName(), this.getHostAddress());
    }
}

