/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.LocationAwareDetectorClient;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.HostnameResolver;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

public interface ProvisionService {
    public boolean isDiscoveryEnabled();

    public void clearCache();

    @Transactional
    public OnmsMonitoringLocation createLocationIfNecessary(String var1);

    @Transactional
    public void updateNode(OnmsNode var1, String var2);

    @Transactional
    public OnmsNode updateNodeAttributes(OnmsNode var1);

    @Transactional
    public OnmsNode getDbNodeInitCat(Integer var1);

    @Transactional
    public OnmsIpInterface updateIpInterfaceAttributes(Integer var1, OnmsIpInterface var2);

    @Transactional
    public OnmsSnmpInterface updateSnmpInterfaceAttributes(Integer var1, OnmsSnmpInterface var2);

    @Transactional
    public OnmsMonitoredService addMonitoredService(Integer var1, String var2);

    @Transactional
    public OnmsMonitoredService addMonitoredService(Integer var1, String var2, String var3);

    @Transactional
    public OnmsMonitoredService updateMonitoredServiceState(Integer var1, String var2, String var3);

    @Transactional
    public OnmsNode getRequisitionedNode(String var1, String var2);

    @Transactional
    public void deleteNode(Integer var1);

    @Transactional
    public void deleteInterface(Integer var1, String var2);

    @Transactional
    public void deleteService(Integer var1, InetAddress var2, String var3);

    @Transactional
    public void insertNode(OnmsNode var1);

    @Transactional
    public OnmsServiceType createServiceTypeIfNecessary(String var1);

    @Transactional
    public OnmsCategory createCategoryIfNecessary(String var1);

    @Transactional(readOnly=true)
    public Map<String, Integer> getForeignIdToNodeIdMap(String var1);

    @Transactional
    public void setNodeParentAndDependencies(String var1, String var2, String var3, String var4, String var5);

    public List<NodeScanSchedule> getScheduleForNodes();

    public NodeScanSchedule getScheduleForNode(int var1, boolean var2);

    public void setForeignSourceRepository(ForeignSourceRepository var1);

    public Requisition loadRequisition(Resource var1);

    public List<PluginConfig> getDetectorsForForeignSource(String var1);

    public List<NodePolicy> getNodePoliciesForForeignSource(String var1);

    public List<IpInterfacePolicy> getIpInterfacePoliciesForForeignSource(String var1);

    public List<SnmpInterfacePolicy> getSnmpInterfacePoliciesForForeignSource(String var1);

    @Transactional
    public void updateNodeScanStamp(Integer var1, Date var2);

    @Transactional
    public void deleteObsoleteInterfaces(Integer var1, Date var2);

    @Transactional
    public OnmsIpInterface setIsPrimaryFlag(Integer var1, String var2);

    @Transactional
    public OnmsIpInterface getPrimaryInterfaceForNode(OnmsNode var1);

    @Transactional
    public OnmsNode createUndiscoveredNode(String var1, String var2, String var3);

    @Transactional
    public OnmsNode getNode(Integer var1);

    public HostnameResolver getHostnameResolver();

    public void setHostnameResolver(HostnameResolver var1);

    public LocationAwareDetectorClient getLocationAwareDetectorClient();

    public LocationAwareSnmpClient getLocationAwareSnmpClient();

    public LocationAwareDnsLookupClient getLocationAwareDnsLookupClient();
}

