/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.Collection;
import java.util.Map;
import org.opennms.core.tasks.BatchTask;
import org.opennms.netmgt.provision.persist.AbstractRequisitionVisitor;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.Phase;
import org.opennms.netmgt.provision.service.lifecycle.annotations.Activity;
import org.opennms.netmgt.provision.service.lifecycle.annotations.ActivityProvider;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.ImportOperationsManager;
import org.opennms.netmgt.provision.service.operations.RequisitionImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

@ActivityProvider
public class CoreImportActivities {
    private static final Logger LOG = LoggerFactory.getLogger(CoreImportActivities.class);
    private final ProvisionService m_provisionService;

    public CoreImportActivities(ProvisionService provisionService) {
        this.m_provisionService = provisionService;
    }

    @Activity(lifecycle="import", phase="validate", schedulingHint="import")
    public RequisitionImport loadSpecFile(Resource resource) {
        RequisitionImport ri = new RequisitionImport();
        CoreImportActivities.info("Loading requisition from resource {}", resource);
        try {
            Requisition specFile = this.m_provisionService.loadRequisition(resource);
            ri.setRequisition(specFile);
            CoreImportActivities.debug("Finished loading requisition.", new Object[0]);
        }
        catch (Throwable t) {
            ri.abort(t);
        }
        return ri;
    }

    @Activity(lifecycle="import", phase="audit", schedulingHint="import")
    public ImportOperationsManager auditNodes(RequisitionImport ri, String rescanExisting) {
        if (ri.isAborted()) {
            CoreImportActivities.info("The import has been aborted, skipping audit phase import.", new Object[0]);
            return null;
        }
        Requisition specFile = ri.getRequisition();
        CoreImportActivities.info("Auditing nodes for requisition {}. The parameter {} was set to {} during import.", specFile, "importRescanExisting", rescanExisting);
        String foreignSource = specFile.getForeignSource();
        Map<String, Integer> foreignIdsToNodes = this.m_provisionService.getForeignIdToNodeIdMap(foreignSource);
        ImportOperationsManager opsMgr = new ImportOperationsManager(foreignIdsToNodes, this.m_provisionService, rescanExisting);
        opsMgr.setForeignSource(foreignSource);
        opsMgr.auditNodes(specFile);
        CoreImportActivities.debug("Finished auditing nodes.", new Object[0]);
        return opsMgr;
    }

    @Activity(lifecycle="import", phase="scan", schedulingHint="import")
    public static void scanNodes(Phase currentPhase, ImportOperationsManager opsMgr, RequisitionImport ri) {
        if (ri.isAborted()) {
            CoreImportActivities.info("The import has been aborted, skipping scan phase import.", new Object[0]);
            return;
        }
        CoreImportActivities.info("Scheduling nodes for phase {}", new Object[]{currentPhase});
        Collection<ImportOperation> operations = opsMgr.getOperations();
        for (ImportOperation op : operations) {
            LifeCycleInstance nodeScan = currentPhase.createNestedLifeCycle("nodeImport");
            CoreImportActivities.debug("Created lifecycle {} for operation {}", nodeScan, op);
            nodeScan.setAttribute("operation", op);
            nodeScan.setAttribute("requisitionImport", ri);
            nodeScan.trigger();
        }
    }

    @Activity(lifecycle="nodeImport", phase="scan", schedulingHint="import")
    public static void scanNode(ImportOperation operation, RequisitionImport ri, String rescanExisting) {
        if (ri.isAborted()) {
            CoreImportActivities.info("The import has been aborted, skipping scan phase nodeImport.", new Object[0]);
            return;
        }
        if (rescanExisting == null || Boolean.valueOf(rescanExisting).booleanValue()) {
            CoreImportActivities.info("Running scan phase of {}, the parameter {} was set to {} during import.", operation, "importRescanExisting", rescanExisting);
            operation.scan();
            CoreImportActivities.info("Finished Running scan phase of {}", operation);
        } else {
            CoreImportActivities.info("Skipping scan phase of {}, because the parameter {} was set to {} during import.", operation, "importRescanExisting", rescanExisting);
        }
    }

    @Activity(lifecycle="nodeImport", phase="persist", schedulingHint="import")
    public static void persistNode(ImportOperation operation, RequisitionImport ri) {
        if (ri.isAborted()) {
            CoreImportActivities.info("The import has been aborted, skipping persist phase.", new Object[0]);
            return;
        }
        CoreImportActivities.info("Running persist phase of {}", operation);
        operation.persist();
        CoreImportActivities.info("Finished Running persist phase of {}", operation);
    }

    @Activity(lifecycle="import", phase="relate", schedulingHint="import")
    public void relateNodes(final BatchTask currentPhase, RequisitionImport ri) {
        if (ri.isAborted()) {
            CoreImportActivities.info("The import has been aborted, skipping relate phase.", new Object[0]);
            return;
        }
        CoreImportActivities.info("Running relate phase", new Object[0]);
        final Requisition requisition = ri.getRequisition();
        AbstractRequisitionVisitor visitor = new AbstractRequisitionVisitor(){

            public void visitNode(OnmsNodeRequisition nodeReq) {
                LOG.debug("Scheduling relate of node {}", (Object)nodeReq);
                currentPhase.add(CoreImportActivities.parentSetter(CoreImportActivities.this.m_provisionService, nodeReq, requisition.getForeignSource()));
            }
        };
        requisition.visit((RequisitionVisitor)visitor);
        LOG.info("Finished Running relate phase");
    }

    private static Runnable parentSetter(final ProvisionService provisionService, final OnmsNodeRequisition nodeReq, final String foreignSource) {
        return new Runnable(){

            @Override
            public void run() {
                provisionService.setNodeParentAndDependencies(foreignSource, nodeReq.getForeignId(), nodeReq.getParentForeignSource() == null ? foreignSource : nodeReq.getParentForeignSource(), nodeReq.getParentForeignId(), nodeReq.getParentNodeLabel());
                provisionService.clearCache();
            }

            public String toString() {
                return "set parent for node " + nodeReq.getNodeLabel();
            }
        };
    }

    protected static void info(String format, Object ... args) {
        LOG.info(format, args);
    }

    protected static void debug(String format, Object ... args) {
        LOG.debug(format, args);
    }

    protected static void warn(String format, Object ... args) {
        LOG.warn(format, args);
    }
}

