/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.opennms.netmgt.provision.persist.AbstractRequisitionVisitor;
import org.opennms.netmgt.provision.persist.OnmsAssetRequisition;
import org.opennms.netmgt.provision.persist.OnmsIpInterfaceRequisition;
import org.opennms.netmgt.provision.persist.OnmsMonitoredServiceRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeCategoryRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.service.operations.ImportOperationsManager;
import org.opennms.netmgt.provision.service.operations.SaveOrUpdateOperation;

public class RequisitionAccountant
extends AbstractRequisitionVisitor {
    private final ImportOperationsManager m_opsMgr;
    private SaveOrUpdateOperation m_currentOp;

    public RequisitionAccountant(ImportOperationsManager opsMgr) {
        this.m_opsMgr = opsMgr;
    }

    public void visitNode(OnmsNodeRequisition nodeReq) {
        this.m_currentOp = this.m_opsMgr.foundNode(nodeReq.getForeignId(), nodeReq.getNodeLabel(), nodeReq.getLocation(), nodeReq.getBuilding(), nodeReq.getCity());
    }

    public void completeNode(OnmsNodeRequisition nodeReq) {
        this.m_currentOp = null;
    }

    public void visitInterface(OnmsIpInterfaceRequisition ifaceReq) {
        this.m_currentOp.foundInterface(ifaceReq.getIpAddr().trim(), ifaceReq.getDescr(), ifaceReq.getSnmpPrimary(), ifaceReq.getManaged(), ifaceReq.getStatus());
    }

    public void visitMonitoredService(OnmsMonitoredServiceRequisition svcReq) {
        this.m_currentOp.foundMonitoredService(svcReq.getServiceName());
    }

    public void visitNodeCategory(OnmsNodeCategoryRequisition catReq) {
        this.m_currentOp.foundCategory(catReq.getName());
    }

    public void visitAsset(OnmsAssetRequisition assetReq) {
        this.m_currentOp.foundAsset(assetReq.getName(), assetReq.getValue());
    }
}

