/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.text.ParseException;
import java.util.stream.Collectors;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.url.GenericURLFactory;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.opennms.netmgt.dao.api.ProvisiondConfigurationDao;
import org.opennms.netmgt.provision.service.ImportJob;
import org.opennms.netmgt.provision.service.Provisioner;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.JobFactory;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.StringUtils;

public class ImportScheduler
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ImportScheduler.class);
    protected static final String JOB_GROUP = "Provisiond";
    @Autowired
    private Scheduler m_scheduler;
    @Autowired
    private Provisioner m_provisioner;
    @Autowired
    private ProvisiondConfigurationDao m_configDao;
    private Object m_lock = new Object();
    private JobFactory m_importJobFactory;

    protected ImportScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        try {
            this.getScheduler().setJobFactory(this.getImportJobFactory());
        }
        catch (SchedulerException e) {
            LOG.error("afterPropertiesSet: couldn't set proper JobFactory for scheduler", (Throwable)e);
        }
        GenericURLFactory.initialize();
        this.buildImportSchedule();
    }

    public void start() throws SchedulerException {
        this.getScheduler().start();
    }

    public void pause() throws SchedulerException {
        this.getScheduler().pauseAll();
    }

    public void standBy() throws SchedulerException {
        this.getScheduler().standby();
    }

    public void resume() throws SchedulerException {
        this.getScheduler().resumeAll();
    }

    public void stop() throws SchedulerException {
        this.getScheduler().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildImportSchedule() throws Exception {
        LOG.info("rebuildImportSchedule: acquiring lock...");
        Object object = this.m_lock;
        synchronized (object) {
            LOG.debug("rebuildImportSchedule: lock acquired.  reloading configuration.");
            try {
                this.m_configDao.reloadConfiguration();
                LOG.debug("rebuildImportSchedule: removing current import jobs from schedule...");
                this.removeCurrentJobsFromSchedule();
                LOG.debug("rebuildImportSchedule: recreating import schedule based on configuration...");
                this.buildImportSchedule();
                this.printCurrentSchedule();
            }
            catch (DataAccessResourceFailureException e) {
                LOG.error("rebuildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                throw new IllegalStateException(e);
            }
            catch (SchedulerException e) {
                LOG.error("rebuildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                throw e;
            }
        }
        LOG.info("rebuildImportSchedule: schedule rebuilt and lock released.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCurrentJobsFromSchedule() throws SchedulerException {
        this.printCurrentSchedule();
        Object object = this.m_lock;
        synchronized (object) {
            for (JobKey key : this.m_scheduler.getJobKeys(GroupMatcher.groupEquals((String)JOB_GROUP))) {
                String jobName = key.getName();
                try {
                    this.getScheduler().deleteJob(new JobKey(jobName, JOB_GROUP));
                }
                catch (SchedulerException e) {
                    LOG.error("removeCurrentJobsFromSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
            }
        }
        this.printCurrentSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildImportSchedule() {
        Object object = this.m_lock;
        synchronized (object) {
            for (RequisitionDef def : this.m_configDao.getDefs()) {
                JobDetailImpl detail = null;
                CronTriggerImpl trigger = null;
                try {
                    detail = new JobDetailImpl(def.getImportName(), JOB_GROUP, ImportJob.class, false, false);
                    detail.getJobDataMap().put("url", def.getImportUrlResource());
                    detail.getJobDataMap().put("rescanExisting", def.getRescanExisting());
                    trigger = new CronTriggerImpl(def.getImportName(), JOB_GROUP, def.getCronSchedule());
                    trigger.setMisfireInstruction(2);
                    this.getScheduler().scheduleJob((JobDetail)detail, (Trigger)trigger);
                }
                catch (ParseException e) {
                    LOG.error("buildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
                catch (SchedulerException e) {
                    LOG.error("buildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
            }
        }
        this.printCurrentSchedule();
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setProvisioner(Provisioner provisioner) {
        this.m_provisioner = provisioner;
    }

    protected final Provisioner getProvisioner() {
        return this.m_provisioner;
    }

    public void setImportJobFactory(JobFactory importJobFactory) {
        this.m_importJobFactory = importJobFactory;
    }

    public JobFactory getImportJobFactory() {
        return this.m_importJobFactory;
    }

    private void printCurrentSchedule() {
        try {
            LOG.info("calendarNames: {}", (Object)String.join((CharSequence)", ", this.getScheduler().getCalendarNames().toArray(new String[0])));
            LOG.info("current executing jobs: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCurrentlyExecutingJobs().toArray()));
            LOG.info("current job names: {}", (Object)this.getScheduler().getJobKeys(GroupMatcher.groupEquals((String)JOB_GROUP)).stream().map(Key::getName).collect(Collectors.joining(", ")));
            LOG.info("scheduler metadata: {}", (Object)this.getScheduler().getMetaData());
            LOG.info("trigger names: {}", (Object)this.getScheduler().getTriggerKeys(GroupMatcher.groupEquals((String)JOB_GROUP)).stream().map(Key::getName).collect(Collectors.joining(", ")));
            for (TriggerKey key : this.getScheduler().getTriggerKeys(GroupMatcher.groupEquals((String)JOB_GROUP))) {
                String triggerName = key.getName();
                CronTrigger t = (CronTrigger)this.getScheduler().getTrigger(key);
                LOG.info("trigger: {}, calendar name: {}, cron expression: {}, URL: {}, rescanExisting: {}, next fire time: {}, previous fire time: {}, time zone: {}, priority: {}", new Object[]{triggerName, t.getCalendarName(), t.getCronExpression(), t.getJobDataMap().get((Object)"url"), t.getJobDataMap().get((Object)"rescanExisting"), t.getNextFireTime(), t.getPreviousFireTime(), t.getTimeZone(), t.getPriority()});
            }
        }
        catch (Throwable e) {
            LOG.error("printCurrentSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }
}

