/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.opennms.netmgt.provision.service.ImportJob;
import org.opennms.netmgt.provision.service.Provisioner;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class ImportJobFactory
implements JobFactory {
    private Provisioner m_provisioner;

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        Class<ImportJob> jobClass = this.getJobClass(jobDetail);
        ImportJob job = null;
        try {
            job = jobClass.newInstance();
            job.setProvisioner(this.getProvisioner());
            return job;
        }
        catch (Throwable e) {
            SchedulerException se = new SchedulerException("failed to create job class: " + jobDetail.getJobClass().getName() + "; " + e.getLocalizedMessage(), e);
            throw se;
        }
    }

    private Class<ImportJob> getJobClass(JobDetail jobDetail) {
        return jobDetail.getJobClass();
    }

    public void setProvisioner(Provisioner provisioner) {
        this.m_provisioner = provisioner;
    }

    private Provisioner getProvisioner() {
        return this.m_provisioner;
    }
}

