/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.text.ParseException;
import java.util.Arrays;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.url.GenericURLFactory;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.opennms.netmgt.dao.api.ProvisiondConfigurationDao;
import org.opennms.netmgt.provision.service.ImportJob;
import org.opennms.netmgt.provision.service.Provisioner;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.StringUtils;

public class ImportScheduler
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ImportScheduler.class);
    protected static final String JOB_GROUP = "Provisiond";
    @Autowired
    private Scheduler m_scheduler;
    @Autowired
    private Provisioner m_provisioner;
    @Autowired
    private ProvisiondConfigurationDao m_configDao;
    private Object m_lock = new Object();
    private JobFactory m_importJobFactory;

    protected ImportScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        try {
            this.getScheduler().setJobFactory(this.getImportJobFactory());
        }
        catch (SchedulerException e) {
            LOG.error("afterPropertiesSet: couldn't set proper JobFactory for scheduler", (Throwable)e);
        }
        GenericURLFactory.initialize();
        this.buildImportSchedule();
    }

    public void start() throws SchedulerException {
        this.getScheduler().start();
    }

    public void pause() throws SchedulerException {
        this.getScheduler().pauseAll();
    }

    public void standBy() throws SchedulerException {
        this.getScheduler().standby();
    }

    public void resume() throws SchedulerException {
        this.getScheduler().resumeAll();
    }

    public void stop() throws SchedulerException {
        this.getScheduler().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildImportSchedule() throws Exception {
        LOG.info("rebuildImportSchedule: acquiring lock...");
        Object object = this.m_lock;
        synchronized (object) {
            LOG.debug("rebuildImportSchedule: lock acquired.  reloading configuration.");
            try {
                this.m_configDao.reloadConfiguration();
                LOG.debug("rebuildImportSchedule: removing current import jobs from schedule...");
                this.removeCurrentJobsFromSchedule();
                LOG.debug("rebuildImportSchedule: recreating import schedule based on configuration...");
                this.buildImportSchedule();
                this.printCurrentSchedule();
            }
            catch (DataAccessResourceFailureException e) {
                LOG.error("rebuildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                throw new IllegalStateException(e);
            }
            catch (SchedulerException e) {
                LOG.error("rebuildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                throw e;
            }
        }
        LOG.info("rebuildImportSchedule: schedule rebuilt and lock released.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCurrentJobsFromSchedule() throws SchedulerException {
        this.printCurrentSchedule();
        Object object = this.m_lock;
        synchronized (object) {
            for (String jobName : Arrays.asList(this.m_scheduler.getJobNames(JOB_GROUP))) {
                try {
                    this.getScheduler().deleteJob(jobName, JOB_GROUP);
                }
                catch (SchedulerException e) {
                    LOG.error("removeCurrentJobsFromSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
            }
        }
        this.printCurrentSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildImportSchedule() {
        Object object = this.m_lock;
        synchronized (object) {
            for (RequisitionDef def : this.m_configDao.getDefs()) {
                JobDetail detail = null;
                CronTrigger trigger = null;
                try {
                    detail = new JobDetail(def.getImportName(), JOB_GROUP, ImportJob.class, false, false, false);
                    detail.getJobDataMap().put("url", def.getImportUrlResource());
                    detail.getJobDataMap().put("rescanExisting", def.getRescanExisting());
                    trigger = new CronTrigger(def.getImportName(), JOB_GROUP, def.getCronSchedule());
                    trigger.setMisfireInstruction(2);
                    this.getScheduler().scheduleJob(detail, (Trigger)trigger);
                }
                catch (ParseException e) {
                    LOG.error("buildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
                catch (SchedulerException e) {
                    LOG.error("buildImportSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
                }
            }
        }
        this.printCurrentSchedule();
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setProvisioner(Provisioner provisioner) {
        this.m_provisioner = provisioner;
    }

    protected final Provisioner getProvisioner() {
        return this.m_provisioner;
    }

    public void setImportJobFactory(JobFactory importJobFactory) {
        this.m_importJobFactory = importJobFactory;
    }

    public JobFactory getImportJobFactory() {
        return this.m_importJobFactory;
    }

    private void printCurrentSchedule() {
        try {
            LOG.info("calendarNames: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCalendarNames()));
            LOG.info("current executing jobs: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getCurrentlyExecutingJobs().toArray()));
            LOG.info("current job names: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getJobNames(JOB_GROUP)));
            LOG.info("scheduler metadata: {}", (Object)this.getScheduler().getMetaData());
            LOG.info("trigger names: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.getScheduler().getTriggerNames(JOB_GROUP)));
            for (String triggerName : Arrays.asList(this.getScheduler().getTriggerNames(JOB_GROUP))) {
                CronTrigger t = (CronTrigger)this.getScheduler().getTrigger(triggerName, JOB_GROUP);
                LOG.info("trigger: {}, calendar name: {}, cron expression: {}, URL: {}, rescanExisting: {}, next fire time: {}, time zone: {}, priority: {}", new Object[]{triggerName, t.getCalendarName(), t.getCronExpression(), t.getJobDataMap().get((Object)"url"), t.getJobDataMap().get((Object)"rescanExisting"), t.getNextFireTime(), t.getPreviousFireTime(), t.getTimeZone(), t.getPriority()});
            }
        }
        catch (Throwable e) {
            LOG.error("printCurrentSchedule: {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
    }
}

