/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import com.google.common.collect.Lists;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.snmp.IfTable;
import org.opennms.netmgt.provision.service.snmp.IfXTable;
import org.opennms.netmgt.provision.service.snmp.IpAddrTable;
import org.opennms.netmgt.provision.service.snmp.IpAddressTable;
import org.opennms.netmgt.provision.service.snmp.SystemGroup;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanManager {
    private static final Logger LOG = LoggerFactory.getLogger(ScanManager.class);
    private final LocationAwareSnmpClient m_locationAwareSnmpClient;
    private final InetAddress m_address;
    private SystemGroup m_systemGroup;
    private IfTable m_ifTable;
    private IpAddrTable m_ipAddrTable;
    private IpAddressTable m_ipAddressTable;
    private IfXTable m_ifXTable;

    ScanManager(LocationAwareSnmpClient locationAwareSnmpClient, InetAddress address) {
        this.m_locationAwareSnmpClient = Objects.requireNonNull(locationAwareSnmpClient);
        this.m_address = address;
    }

    public SystemGroup getSystemGroup() {
        return this.m_systemGroup;
    }

    public IfTable getIfTable() {
        return this.m_ifTable;
    }

    public IpAddrTable getIpAddrTable() {
        return this.m_ipAddrTable;
    }

    public IpAddressTable getIpAddressTable() {
        return this.m_ipAddressTable;
    }

    public IfXTable getIfXTable() {
        return this.m_ifXTable;
    }

    InetAddress getNetMask(int ifIndex) {
        InetAddress ipAddressNetmask = this.getIpAddressTable().getNetMask(ifIndex);
        if (ipAddressNetmask == null) {
            return this.getIpAddrTable().getNetMask(ifIndex);
        }
        return ipAddressNetmask;
    }

    boolean isSnmpDataForInterfacesUpToDate() {
        return !this.getIfTable().failed() && !this.getIpAddrTable().failed() || !this.getIpAddressTable().failed();
    }

    boolean isSnmpDataForNodeUpToDate() {
        return !this.getSystemGroup().failed();
    }

    void updateSnmpData(OnmsNode node) {
        try {
            this.m_systemGroup = new SystemGroup(this.m_address);
            TreeSet<SnmpInstId> ipAddrs = new TreeSet<SnmpInstId>();
            HashSet<InetAddress> ipAddresses = new HashSet<InetAddress>();
            for (OnmsIpInterface iface : node.getIpInterfaces()) {
                InetAddress addr = iface.getIpAddress();
                if (addr != null && addr instanceof Inet4Address) {
                    ipAddrs.add(new SnmpInstId(InetAddressUtils.toOid((InetAddress)addr)));
                }
                ipAddresses.add(addr);
            }
            this.m_ipAddrTable = new IpAddrTable(this.m_address, ipAddrs);
            this.m_ipAddressTable = IpAddressTable.createTable(this.m_address, ipAddresses);
            AggregateTracker tracker = new AggregateTracker((Collection)Lists.newArrayList((Object[])new Collectable[]{this.m_systemGroup, this.m_ipAddrTable, this.m_ipAddressTable}));
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(this.m_address, MonitoringLocationDao.getLocationNameOrNullIfDefault((OnmsNode)node));
            try {
                this.m_locationAwareSnmpClient.walk(agentConfig, (CollectionTracker)tracker).withDescription("system/ipAddrTable/ipAddressTable").withLocation(node.getLocation() == null ? null : node.getLocation().getLocationName()).execute().get();
            }
            catch (ExecutionException addr) {
                // empty catch block
            }
            TreeSet<SnmpInstId> ifIndices = new TreeSet<SnmpInstId>();
            for (Integer n : this.m_ipAddrTable.getIfIndices()) {
                ifIndices.add(new SnmpInstId(n.intValue()));
            }
            this.m_ifTable = new IfTable(this.m_address, ifIndices);
            this.m_ifXTable = new IfXTable(this.m_address, ifIndices);
            tracker = new AggregateTracker((Collection)Lists.newArrayList((Object[])new Collectable[]{this.m_systemGroup, this.m_ifTable, this.m_ifXTable}));
            try {
                this.m_locationAwareSnmpClient.walk(agentConfig, (CollectionTracker)tracker).withDescription("ifTable/ifXTable").withLocation(node.getLocation() == null ? null : node.getLocation().getLocationName()).execute().get();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            this.m_systemGroup.updateSnmpDataForNode(node);
            for (SnmpInstId snmpInstId : ifIndices) {
                this.m_ifTable.updateSnmpInterfaceData(node, snmpInstId.toInt());
            }
            for (SnmpInstId snmpInstId : ifIndices) {
                this.m_ifXTable.updateSnmpInterfaceData(node, snmpInstId.toInt());
            }
            for (SnmpInstId snmpInstId : ipAddrs) {
                this.m_ipAddrTable.updateIpInterfaceData(node, snmpInstId.toString());
            }
            for (InetAddress inetAddress : ipAddresses) {
                this.m_ipAddressTable.updateIpInterfaceData(node, InetAddressUtils.str((InetAddress)inetAddress));
            }
        }
        catch (InterruptedException e) {
            LOG.info("thread interrupted while updating SNMP data", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public AggregateTracker createCollectionTracker() {
        return new AggregateTracker((Collectable[])new CollectionTracker[]{this.getSystemGroup(), this.getIfTable(), this.getIpAddrTable(), this.getIfXTable(), this.getIpAddressTable()});
    }
}

