/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.opennms.netmgt.provision.service.WorkDuration;

public class WorkEffort {
    private String m_name;
    private long m_totalTime;
    private long m_sectionCount;
    private ThreadLocal<WorkDuration> m_pendingSection = new ThreadLocal();

    public WorkEffort(String name) {
        this.m_name = name;
    }

    public void begin() {
        WorkDuration pending = new WorkDuration();
        pending.start();
        this.m_pendingSection.set(pending);
    }

    public void end() {
        WorkDuration pending = this.m_pendingSection.get();
        ++this.m_sectionCount;
        this.m_totalTime += pending.getLength();
    }

    public long getTotalTime() {
        return this.m_totalTime;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Total ").append(this.m_name).append(": ");
        buf.append((double)this.m_totalTime / 1000.0).append(" thread-seconds");
        if (this.m_sectionCount > 0L) {
            buf.append(" Avg ").append(this.m_name).append(": ");
            buf.append((double)this.m_totalTime / (double)this.m_sectionCount).append(" ms per node");
        }
        return buf.toString();
    }
}

