/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

public class WorkDuration {
    private String m_name = null;
    private long m_start = -1L;
    private long m_end = -1L;

    public WorkDuration() {
        this(null);
    }

    public WorkDuration(String name) {
        this.m_name = name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void start() {
        this.m_start = System.currentTimeMillis();
    }

    public void end() {
        this.m_end = System.currentTimeMillis();
    }

    public long getLength() {
        if (this.m_start == -1L) {
            return 0L;
        }
        long end = this.m_end == -1L ? System.currentTimeMillis() : this.m_end;
        return end - this.m_start;
    }

    public String toString() {
        return (this.m_name == null ? "" : this.m_name + ": ") + (this.m_start == -1L ? "has not begun" : this.elapsedTime());
    }

    private String elapsedTime() {
        long duration = this.getLength();
        long hours = duration / 3600000L;
        long mins = (duration %= 3600000L) / 60000L;
        long secs = (duration %= 60000L) / 1000L;
        long millis = duration % 1000L;
        StringBuffer elapsed = new StringBuffer();
        if (hours > 0L) {
            elapsed.append(hours).append("h ");
        }
        if (mins > 0L) {
            elapsed.append(mins).append("m ");
        }
        if (secs > 0L) {
            elapsed.append(secs).append("s ");
        }
        if (millis > 0L) {
            elapsed.append(millis).append("ms");
        }
        return elapsed.toString();
    }
}

