/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.service.snmp.IpAddrTableEntry;
import org.opennms.netmgt.provision.service.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddrTable
extends SnmpTable<IpAddrTableEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(IpAddrTable.class);

    public IpAddrTable(InetAddress address) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList);
    }

    public IpAddrTable(InetAddress address, Set<SnmpInstId> ipAddrs) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList, ipAddrs);
    }

    @Override
    protected IpAddrTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IpAddrTableEntry();
    }

    public Set<Integer> getIfIndices() {
        TreeSet<Integer> ifIndices = new TreeSet<Integer>();
        for (IpAddrTableEntry entry : this.getEntries()) {
            Integer ifIndex = entry.getIpAdEntIfIndex();
            if (ifIndex == null) continue;
            ifIndices.add(ifIndex);
        }
        return ifIndices;
    }

    public InetAddress getIfAddress(int ifIndex) {
        IpAddrTableEntry entry = this.getEntryByIfIndex(ifIndex);
        return entry == null ? null : entry.getIpAdEntAddr();
    }

    public InetAddress getNetMask(int ifIndex) {
        IpAddrTableEntry entry = this.getEntryByIfIndex(ifIndex);
        return entry == null ? null : entry.getIpAdEntNetMask();
    }

    public InetAddress getNetMask(InetAddress address) {
        return this.getEntry(address) == null ? null : this.getEntry(address).getIpAdEntNetMask();
    }

    public Integer getIfIndex(InetAddress address) {
        return this.getEntry(address) == null ? null : this.getEntry(address).getIpAdEntIfIndex();
    }

    public IpAddrTableEntry getEntryByIfIndex(int ifIndex) {
        if (this.getEntries() == null) {
            return null;
        }
        for (IpAddrTableEntry entry : this.getEntries()) {
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            return entry;
        }
        return null;
    }

    public IpAddrTableEntry getEntry(InetAddress address) {
        return (IpAddrTableEntry)((Object)this.getEntry(new SnmpInstId(InetAddressUtils.str((InetAddress)address))));
    }

    public void updateIpInterfaceData(OnmsNode node) {
        for (IpAddrTableEntry entry : this.getEntries()) {
            this.updateIpInterfaceData(node, InetAddressUtils.str((InetAddress)entry.getIpAdEntAddr()));
        }
    }

    public void updateIpInterfaceData(OnmsNode node, String ipAddr) {
        InetAddress inetAddr;
        Integer ifIndex;
        OnmsIpInterface ipIf = node.getIpInterfaceByIpAddress(ipAddr);
        if (ipIf == null) {
            ipIf = new OnmsIpInterface(ipAddr, node);
        }
        if ((ifIndex = this.getIfIndex(inetAddr = ipIf.getIpAddress())) != null) {
            InetAddress mask;
            OnmsSnmpInterface snmpIf = node.getSnmpInterfaceWithIfIndex(ifIndex.intValue());
            if (snmpIf == null) {
                snmpIf = new OnmsSnmpInterface(node, ifIndex);
            }
            if ((mask = this.getNetMask(inetAddr)) != null) {
                snmpIf.setNetMask(mask);
            }
            snmpIf.setCollectionEnabled(true);
            ipIf.setSnmpInterface(snmpIf);
        }
        ipIf.setIpHostName(ipAddr);
    }

    public Set<String> getIpAddresses() {
        LinkedHashSet<String> ipAddrs = new LinkedHashSet<String>();
        for (SnmpInstId inst : this.getInstances()) {
            ipAddrs.add(inst.toString());
        }
        return ipAddrs;
    }
}

