/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.dns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Type;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class DnsRequisitionUrlConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(DnsRequisitionUrlConnection.class);
    private static final String EXPRESSION_ARG = "expression";
    private static final String SERVICES_ARG = "services";
    private static final String FID_HASH_SRC_ARG = "foreignidhashsource";
    private static final String[] HASH_IP_KEYWORDS = new String[]{"ip", "addr"};
    private static final String[] HASH_LABEL_KEYWORDS = new String[]{"name", "label"};
    private static final String QUERY_ARG_SEPARATOR = "&";
    public static final String URL_SCHEME = "dns://";
    public static final String PROTOCOL = "dns";
    private String m_zone;
    private Long m_serial;
    private Boolean m_fallback;
    private TSIG m_key;
    private URL m_url;
    private int m_port;
    private String m_foreignSource;
    private int m_foreignIdHashSource;
    private String[] m_services;
    private static Map<String, String> m_args;

    public DnsRequisitionUrlConnection(URL url) throws MalformedURLException {
        super(url);
        m_args = DnsRequisitionUrlConnection.getUrlArgs(url);
        DnsRequisitionUrlConnection.validateDnsUrl(url);
        this.m_url = url;
        this.m_port = url.getPort() == -1 ? 53 : url.getPort();
        this.m_zone = DnsRequisitionUrlConnection.parseZone(url);
        this.m_foreignSource = DnsRequisitionUrlConnection.parseForeignSource(url);
        this.m_foreignIdHashSource = this.getForeignIdHashSource();
        this.m_services = this.getServices();
        if (this.m_zone == null) {
            throw new IllegalArgumentException("Specified Zone is null");
        }
        this.m_serial = 0L;
        this.m_fallback = Boolean.FALSE;
        this.m_key = null;
    }

    private String[] getServices() {
        String[] services = new String[]{"ICMP", "SNMP"};
        if (DnsRequisitionUrlConnection.getArgs() != null && DnsRequisitionUrlConnection.getArgs().get(SERVICES_ARG) != null) {
            services = DnsRequisitionUrlConnection.getArgs().get(SERVICES_ARG).split(",");
        }
        return services;
    }

    private int getForeignIdHashSource() {
        int result = 0;
        if (DnsRequisitionUrlConnection.getArgs() != null && DnsRequisitionUrlConnection.getArgs().get(FID_HASH_SRC_ARG) != null) {
            String hashSourceArg = DnsRequisitionUrlConnection.getArgs().get(FID_HASH_SRC_ARG).toLowerCase();
            for (String keyword : HASH_IP_KEYWORDS) {
                if (!hashSourceArg.contains(keyword)) continue;
                result = 2;
                break;
            }
            for (String keyword : HASH_LABEL_KEYWORDS) {
                if (!hashSourceArg.contains(keyword)) continue;
                ++result;
                break;
            }
        }
        return result;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Requisition r = this.buildRequisitionFromZoneTransfer();
            stream = new ByteArrayInputStream(this.jaxBMarshal(r).getBytes());
        }
        catch (IOException e) {
            LOG.warn("getInputStream: Problem getting input stream", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            String message = "Problem getting input stream: " + e;
            LOG.warn(message, e);
            throw new IOExceptionWithCause(message, e);
        }
        return stream;
    }

    private Requisition buildRequisitionFromZoneTransfer() throws IOException, ZoneTransferException {
        ZoneTransferIn xfer = null;
        List<Record> records = null;
        LOG.debug("connecting to host {}:{}", (Object)this.m_url.getHost(), (Object)this.m_port);
        try {
            xfer = ZoneTransferIn.newIXFR((Name)new Name(this.m_zone), (long)this.m_serial, (boolean)this.m_fallback, (String)this.m_url.getHost(), (int)this.m_port, (TSIG)this.m_key);
            records = this.getRecords(xfer);
        }
        catch (ZoneTransferException e) {
            String message = "IXFR not supported trying AXFR: " + (Object)((Object)e);
            LOG.warn(message, (Throwable)e);
            xfer = ZoneTransferIn.newAXFR((Name)new Name(this.m_zone), (String)this.m_url.getHost(), (TSIG)this.m_key);
            records = this.getRecords(xfer);
        }
        Requisition r = null;
        if (records.size() > 0) {
            r = new Requisition(this.getForeignSource());
            for (Record rec : records) {
                if (!this.matchingRecord(rec)) continue;
                r.insertNode(this.createRequisitionNode(rec));
            }
        }
        return r;
    }

    private List<Record> getRecords(ZoneTransferIn xfer) throws IOException, ZoneTransferException {
        return xfer.run();
    }

    private RequisitionNode createRequisitionNode(Record rec) {
        String addr = null;
        if ("A".equals(Type.string((int)rec.getType()))) {
            ARecord arec = (ARecord)rec;
            addr = StringUtils.stripStart((String)arec.getAddress().toString(), (String)"/");
        } else if ("AAAA".equals(Type.string((int)rec.getType()))) {
            AAAARecord aaaarec = (AAAARecord)rec;
            addr = aaaarec.rdataToString();
        } else {
            throw new IllegalArgumentException("Invalid record type " + Type.string((int)rec.getType()) + ". A or AAAA expected.");
        }
        RequisitionNode n = new RequisitionNode();
        String host = rec.getName().toString();
        String nodeLabel = StringUtils.stripEnd((String)StringUtils.stripStart((String)host, (String)"."), (String)".");
        n.setBuilding(this.getForeignSource());
        switch (this.m_foreignIdHashSource) {
            case 1: {
                n.setForeignId(this.computeHashCode(nodeLabel));
                LOG.debug("Generating foreignId from hash of nodelabel {}", (Object)nodeLabel);
                break;
            }
            case 2: {
                n.setForeignId(this.computeHashCode(addr));
                LOG.debug("Generating foreignId from hash of ipAddress {}", (Object)addr);
                break;
            }
            case 3: {
                n.setForeignId(this.computeHashCode(nodeLabel + addr));
                LOG.debug("Generating foreignId from hash of nodelabel+ipAddress {}{}", (Object)nodeLabel, (Object)addr);
                break;
            }
            default: {
                n.setForeignId(this.computeHashCode(nodeLabel));
                LOG.debug("Default case: Generating foreignId from hash of nodelabel {}", (Object)nodeLabel);
            }
        }
        n.setNodeLabel(nodeLabel);
        RequisitionInterface i = new RequisitionInterface();
        i.setDescr("DNS-" + Type.string((int)rec.getType()));
        i.setIpAddr(addr);
        i.setSnmpPrimary(PrimaryType.PRIMARY);
        i.setManaged(Boolean.TRUE);
        i.setStatus(Integer.valueOf(1));
        for (String service : this.m_services) {
            service = service.trim();
            i.insertMonitoredService(new RequisitionMonitoredService(service));
            LOG.debug("Adding provisioned service {}", (Object)service);
        }
        n.putInterface(i);
        return n;
    }

    private boolean matchingRecord(Record rec) {
        LOG.info("matchingRecord: checking rec: {} to see if it should be imported...", (Object)rec);
        boolean matches = false;
        if ("A".equals(Type.string((int)rec.getType())) || "AAAA".equals(Type.string((int)rec.getType()))) {
            LOG.debug("matchingRecord: record is an {} record, continuing...", (Object)Type.string((int)rec.getType()));
            String expression = DnsRequisitionUrlConnection.determineExpressionFromUrl(this.getUrl());
            if (expression != null) {
                Pattern p = Pattern.compile(expression);
                Matcher m = p.matcher(rec.getName().toString());
                LOG.debug("matchingRecord: attempting to match hostname: [{}] with expression: [ {} ]", (Object)rec.getName(), (Object)expression);
                if (m.matches()) {
                    matches = true;
                } else {
                    LOG.debug("matchingRecord: attempting to match record: [{} {}] with expression: [{}]", new Object[]{rec.getName(), rec.rdataToString(), expression});
                    m = p.matcher(rec.getName().toString() + " " + rec.rdataToString());
                    if (m.matches()) {
                        matches = true;
                    }
                }
                LOG.debug("matchingRecord: record matches expression: {}", (Object)matches);
            } else {
                LOG.debug("matchingRecord: no expression for this zone, returning valid match for this {} record...", (Object)Type.string((int)rec.getType()));
                matches = true;
            }
        }
        LOG.info("matchingRecord: record: {} matches: {}", (Object)matches, (Object)rec);
        return matches;
    }

    private String computeHashCode(String hashSource) {
        return String.valueOf(hashSource.hashCode());
    }

    private String jaxBMarshal(Requisition r) throws JAXBException {
        return JaxbUtils.marshal((Object)r);
    }

    public String getZone() {
        return this.m_zone;
    }

    public Long getSerial() {
        return this.m_serial;
    }

    public void setSerial(Long serial) {
        this.m_serial = serial;
    }

    public Boolean getFallback() {
        return this.m_fallback;
    }

    public void setFallback(Boolean fallback) {
        this.m_fallback = fallback;
    }

    public TSIG getKey() {
        return this.m_key;
    }

    public void setKey(TSIG key) {
        this.m_key = key;
    }

    public String getDescription() {
        return this.m_url.toString();
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public URL getUrl() {
        return this.m_url;
    }

    public static Map<String, String> getArgs() {
        return m_args;
    }

    protected static String determineExpressionFromUrl(URL url) {
        LOG.info("determineExpressionFromUrl: finding regex as parameter in query string of URL: {}", (Object)url);
        if (DnsRequisitionUrlConnection.getUrlArgs(url) == null) {
            return null;
        }
        return DnsRequisitionUrlConnection.getUrlArgs(url).get(EXPRESSION_ARG);
    }

    private static List<String> tokenizeQueryArgs(String query) throws IllegalArgumentException {
        if (query == null) {
            throw new IllegalArgumentException("The URL query is null");
        }
        List<String> queryArgs = Arrays.asList(StringUtils.split((String)query, (String)QUERY_ARG_SEPARATOR));
        return queryArgs;
    }

    protected static String decodeQueryString(URL url) {
        if (url == null || url.getQuery() == null) {
            throw new IllegalArgumentException("The URL or the URL query is null: " + url);
        }
        String query = null;
        try {
            query = URLDecoder.decode(url.getQuery(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("decodeQueryString", (Throwable)e);
        }
        return query;
    }

    protected static void validateDnsUrl(URL url) throws MalformedURLException {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        if ((path = StringUtils.removeEnd((String)path, (String)"/")) == null || StringUtils.countMatches((String)path, (String)"/") > 1) {
            throw new MalformedURLException("The specified DNS URL contains invalid path: " + url);
        }
        String query = url.getQuery();
        if (query != null && DnsRequisitionUrlConnection.determineExpressionFromUrl(url) == null && DnsRequisitionUrlConnection.getArgs().get(SERVICES_ARG) == null && DnsRequisitionUrlConnection.getArgs().get(FID_HASH_SRC_ARG) == null) {
            throw new MalformedURLException("The specified DNS URL contains an invalid query string: " + url);
        }
    }

    protected static String parseZone(URL url) {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        String zone = path = StringUtils.removeEnd((String)path, (String)"/");
        if (path != null && StringUtils.countMatches((String)path, (String)"/") == 1) {
            String[] paths = path.split("/");
            zone = paths[0];
        }
        return zone;
    }

    protected static String parseForeignSource(URL url) {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        String foreignSource = path = StringUtils.removeEnd((String)path, (String)"/");
        if (path != null && StringUtils.countMatches((String)path, (String)"/") == 1) {
            String[] paths = path.split("/");
            foreignSource = paths[1];
        }
        return foreignSource;
    }

    protected static Map<String, String> getUrlArgs(URL url) {
        if (url.getQuery() == null) {
            return null;
        }
        String query = DnsRequisitionUrlConnection.decodeQueryString(url);
        List<String> queryArgs = DnsRequisitionUrlConnection.tokenizeQueryArgs(query);
        HashMap<String, String> args = new HashMap<String, String>();
        for (String queryArg : queryArgs) {
            String[] argTokens = StringUtils.split((String)queryArg, (char)'=');
            if (argTokens.length < 2) {
                LOG.warn("getUrlArgs: syntax error in URL query string, missing '=' in query argument: {}", (Object)queryArg);
                continue;
            }
            LOG.debug("adding arg tokens {}, {}", (Object)argTokens[1], (Object)argTokens[0].toLowerCase());
            args.put(argTokens[0].toLowerCase(), argTokens[1]);
        }
        return args;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }
}

