/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventAccumulator
implements EventForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(EventAccumulator.class);
    private final EventForwarder m_eventForwarder;
    private final Queue<Event> m_events = new ConcurrentLinkedQueue<Event>();

    public EventAccumulator(EventForwarder forwarder) {
        this.m_eventForwarder = forwarder;
    }

    public void sendNow(Event event) {
        if (event != null) {
            this.m_events.add(event);
        }
    }

    public void sendNow(Log log) {
        if (log != null && log.getEvents() != null && log.getEvents().getEventCount() > 0) {
            this.m_events.addAll(log.getEvents().getEventCollection());
        }
    }

    public void flush() {
        Event event;
        int i = 0;
        while (!this.m_events.isEmpty() && (event = this.m_events.poll()) != null) {
            this.m_eventForwarder.sendNow(event);
            ++i;
        }
        LOG.debug("flush(): sent {} events: {}", (Object)i, this.m_events);
    }
}

