/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.opennms.netmgt.provision.service.snmp.SystemGroup;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

final class NodeInfoScan
implements RunInBatch {
    private static final Logger LOG = LoggerFactory.getLogger(NodeInfoScan.class);
    private final SnmpAgentConfigFactory m_agentConfigFactory;
    private final InetAddress m_agentAddress;
    private final String m_foreignSource;
    private OnmsNode m_node;
    private Integer m_nodeId;
    private final OnmsMonitoringLocation m_location;
    private boolean restoreCategories = false;
    private final ProvisionService m_provisionService;
    private final ScanProgress m_scanProgress;

    NodeInfoScan(OnmsNode node, InetAddress agentAddress, String foreignSource, OnmsMonitoringLocation location, ScanProgress scanProgress, SnmpAgentConfigFactory agentConfigFactory, ProvisionService provisionService, Integer nodeId) {
        this.m_node = node;
        this.m_agentAddress = agentAddress;
        this.m_foreignSource = foreignSource;
        this.m_location = location;
        this.m_scanProgress = scanProgress;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_provisionService = provisionService;
        this.m_nodeId = nodeId;
    }

    public void run(BatchTask phase) {
        phase.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

            public void run(BatchTask batch) {
                NodeInfoScan.this.collectNodeInfo();
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeInfoScan.this.doPersistNodeInfo();
            }
        }});
    }

    private InetAddress getAgentAddress() {
        return this.m_agentAddress;
    }

    private SnmpAgentConfig getAgentConfig(InetAddress primaryAddress) {
        return this.getAgentConfigFactory().getAgentConfig(primaryAddress);
    }

    private SnmpAgentConfigFactory getAgentConfigFactory() {
        return this.m_agentConfigFactory;
    }

    private String getForeignSource() {
        return this.m_foreignSource;
    }

    public OnmsMonitoringLocation getLocation() {
        return this.m_location;
    }

    private String getLocationName() {
        return this.m_location == null ? null : this.m_location.getLocationName();
    }

    private ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    private void abort(String reason) {
        this.m_scanProgress.abort(reason);
    }

    private OnmsNode getNode() {
        return this.m_node;
    }

    private Integer getNodeId() {
        return this.m_nodeId;
    }

    private void setNode(OnmsNode node) {
        this.m_node = node;
    }

    private void collectNodeInfo() {
        Assert.notNull((Object)this.getAgentConfigFactory(), (String)"agentConfigFactory was not injected");
        InetAddress primaryAddress = this.getAgentAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(primaryAddress);
        SystemGroup systemGroup = new SystemGroup(primaryAddress);
        try {
            try {
                this.m_provisionService.getLocationAwareSnmpClient().walk(agentConfig, (CollectionTracker)systemGroup).withDescription("systemGroup").withLocation(this.getLocationName()).execute().get();
                systemGroup.updateSnmpDataForNode(this.getNode());
            }
            catch (ExecutionException e) {
                this.abort("Aborting node scan : Agent failed while scanning the system table: " + e.getMessage());
            }
            List<NodePolicy> nodePolicies = this.getProvisionService().getNodePoliciesForForeignSource(this.getEffectiveForeignSource());
            OnmsNode node = null;
            if (this.isAborted()) {
                if (this.getNodeId() != null && nodePolicies.size() > 0) {
                    this.restoreCategories = true;
                    node = this.m_provisionService.getDbNodeInitCat(this.getNodeId());
                    LOG.debug("collectNodeInfo: checking {} node policies for restoration of categories", (Object)nodePolicies.size());
                }
            } else {
                node = this.getNode();
            }
            for (NodePolicy policy : nodePolicies) {
                if (node == null) continue;
                LOG.info("Applying NodePolicy {}({}) to {}", new Object[]{policy.getClass(), policy, node.getLabel()});
                node = policy.apply(node);
            }
            if (node == null) {
                this.restoreCategories = false;
                if (!this.isAborted()) {
                    String reason = "Aborted scan of node due to configured policy";
                    this.abort(reason);
                }
            } else {
                this.setNode(node);
            }
        }
        catch (InterruptedException e) {
            this.abort("Aborting node scan : Scan thread interrupted!");
            Thread.currentThread().interrupt();
        }
    }

    private String getEffectiveForeignSource() {
        return this.getForeignSource() == null ? "default" : this.getForeignSource();
    }

    private void doPersistNodeInfo() {
        if (this.restoreCategories) {
            LOG.debug("doPersistNodeInfo: Restoring {} categories to DB", (Object)this.getNode().getCategories().size());
        }
        if (!this.isAborted() || this.restoreCategories) {
            this.getProvisionService().updateNodeAttributes(this.getNode());
        }
    }

    private boolean isAborted() {
        return this.m_scanProgress.isAborted();
    }
}

