/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.ScanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class SaveOrUpdateOperation
extends ImportOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SaveOrUpdateOperation.class);
    private final OnmsNode m_node;
    private OnmsIpInterface m_currentInterface;
    private ScanManager m_scanManager;
    private String m_rescanExisting = Boolean.TRUE.toString();

    protected SaveOrUpdateOperation(Integer nodeId, String foreignSource, String foreignId, String nodeLabel, String building, String city, String location, ProvisionService provisionService, String rescanExisting) {
        super(provisionService);
        this.m_node = new OnmsNode(new OnmsMonitoringLocation(location, location), nodeLabel);
        this.m_node.setId(nodeId);
        this.m_node.setLabelSource(OnmsNode.NodeLabelSource.USER);
        this.m_node.setType(OnmsNode.NodeType.ACTIVE);
        this.m_node.setForeignSource(foreignSource);
        this.m_node.setForeignId(foreignId);
        this.m_node.getAssetRecord().setBuilding(building);
        this.m_node.getAssetRecord().setCity(city);
        this.m_rescanExisting = rescanExisting;
    }

    public ScanManager getScanManager() {
        return this.m_scanManager;
    }

    public void foundInterface(String ipAddr, Object descr, PrimaryType primaryType, boolean managed, int status) {
        if (ipAddr == null || "".equals(ipAddr.trim())) {
            LOG.error("Found interface on node {} with an empty ipaddr! Ignoring!", (Object)this.m_node.getLabel());
            return;
        }
        this.m_currentInterface = new OnmsIpInterface(ipAddr, this.m_node);
        this.m_currentInterface.setIsManaged(status == 3 ? "U" : "M");
        this.m_currentInterface.setIsSnmpPrimary(primaryType);
        if (PrimaryType.PRIMARY.equals((Object)primaryType)) {
            InetAddress addr = InetAddressUtils.addr((String)ipAddr);
            if (addr == null) {
                LOG.error("Unable to resolve address of snmpPrimary interface for node {} with address '{}'", (Object)this.m_node.getLabel(), (Object)ipAddr);
            } else {
                this.m_scanManager = new ScanManager(addr);
            }
        }
        this.m_node.addIpInterface(this.m_currentInterface);
    }

    @Override
    public void scan() {
        this.updateSnmpData();
    }

    protected void updateSnmpData() {
        if (this.m_scanManager != null) {
            this.m_scanManager.updateSnmpData(this.m_node);
        }
    }

    public void foundMonitoredService(String serviceName) {
        if (this.m_currentInterface != null) {
            OnmsServiceType svcType = this.getProvisionService().createServiceTypeIfNecessary(serviceName);
            OnmsMonitoredService service = new OnmsMonitoredService(this.m_currentInterface, svcType);
            service.setStatus("A");
            this.m_currentInterface.getMonitoredServices().add(service);
        }
    }

    public void foundCategory(String name) {
        OnmsCategory category = this.getProvisionService().createCategoryIfNecessary(name);
        this.m_node.getCategories().add(category);
    }

    protected OnmsNode getNode() {
        return this.m_node;
    }

    protected String getRescanExisting() {
        return this.m_rescanExisting;
    }

    public void foundAsset(String name, String value) {
        BeanWrapper w = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.m_node.getAssetRecord());
        try {
            w.setPropertyValue(name, (Object)value);
        }
        catch (BeansException e) {
            LOG.warn("Could not set property on object of type {}: {}", new Object[]{this.m_node.getClass().getName(), name, e});
        }
    }
}

