/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskCoordinator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.url.GenericURLFactory;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.provision.service.CoreImportActivities;
import org.opennms.netmgt.provision.service.ForceRescanScan;
import org.opennms.netmgt.provision.service.ImportScheduler;
import org.opennms.netmgt.provision.service.ModelImportException;
import org.opennms.netmgt.provision.service.NewSuspectScan;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ProvisioningAdapterManager;
import org.opennms.netmgt.provision.service.TimeTrackingMonitor;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleRepository;
import org.opennms.netmgt.provision.service.operations.NoOpProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.RequisitionImport;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@EventListener(name="Provisiond:EventListener", logPrefix="provisiond")
public class Provisioner
implements SpringServiceDaemon {
    private static final String SCHEDULE_RESCAN_FOR_UPDATED_NODES = "org.opennms.provisiond.scheduleRescanForUpdatedNodes";
    private static final String SCHEDULE_RESCAN_FOR_EXISTING_NODES = "org.opennms.provisiond.scheduleRescanForExistingNodes";
    private static final Logger LOG = LoggerFactory.getLogger(Provisioner.class);
    public static final String NAME = "Provisiond";
    private TaskCoordinator m_taskCoordinator;
    private CoreImportActivities m_importActivities;
    private LifeCycleRepository m_lifeCycleRepository;
    private ProvisionService m_provisionService;
    private ScheduledExecutorService m_scheduledExecutor;
    private final Map<Integer, ScheduledFuture<?>> m_scheduledNodes = new ConcurrentHashMap();
    private volatile EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private volatile TimeTrackingMonitor m_stats;
    @Autowired
    private ProvisioningAdapterManager m_manager;
    private ImportScheduler m_importSchedule;

    public void setProvisionService(ProvisionService provisionService) {
        this.m_provisionService = provisionService;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.m_scheduledExecutor = scheduledExecutor;
    }

    public void setLifeCycleRepository(LifeCycleRepository lifeCycleRepository) {
        this.m_lifeCycleRepository = lifeCycleRepository;
    }

    public void setImportSchedule(ImportScheduler schedule) {
        this.m_importSchedule = schedule;
    }

    public void setImportActivities(CoreImportActivities importActivities) {
        this.m_importActivities = importActivities;
    }

    public void setTaskCoordinator(TaskCoordinator taskCoordinator) {
        this.m_taskCoordinator = taskCoordinator;
    }

    public void setAgentConfigFactory(SnmpAgentConfigFactory agentConfigFactory) {
        this.m_agentConfigFactory = agentConfigFactory;
    }

    public ImportScheduler getImportSchedule() {
        return this.m_importSchedule;
    }

    public void start() throws Exception {
        this.m_manager.initializeAdapters();
        String enabled = System.getProperty(SCHEDULE_RESCAN_FOR_EXISTING_NODES, "true");
        if (Boolean.valueOf(enabled).booleanValue()) {
            this.scheduleRescanForExistingNodes();
        } else {
            LOG.warn("The schedule rescan for existing nodes is disabled.");
        }
        this.m_importSchedule.start();
    }

    public void destroy() throws Exception {
        this.m_importSchedule.stop();
        this.m_scheduledExecutor.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        GenericURLFactory.initialize();
    }

    protected void scheduleRescanForExistingNodes() {
        List<NodeScanSchedule> schedules = this.m_provisionService.getScheduleForNodes();
        this.checkNodeListForRemovals(schedules);
        for (NodeScanSchedule schedule : schedules) {
            if (!this.m_scheduledNodes.containsKey(schedule.getNodeId())) {
                this.addToScheduleQueue(schedule);
                continue;
            }
            this.updateNodeScheduleInQueue(schedule);
        }
    }

    public void doNodeScan(int nodeId) throws InterruptedException, ExecutionException {
    }

    public NodeScan createNodeScan(Integer nodeId, String foreignSource, String foreignId) {
        LOG.info("createNodeScan called");
        return new NodeScan(nodeId, foreignSource, foreignId, this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator);
    }

    public NewSuspectScan createNewSuspectScan(InetAddress ipAddress, String foreignSource) {
        LOG.info("createNewSuspectScan called with IP: " + ipAddress + "and foreignSource" + foreignSource == null ? "null" : foreignSource);
        return new NewSuspectScan(ipAddress, this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator, foreignSource);
    }

    public ForceRescanScan createForceRescanScan(Integer nodeId) {
        LOG.info("createForceRescanScan called with nodeId: " + nodeId);
        return new ForceRescanScan(nodeId, this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator);
    }

    protected void addToScheduleQueue(NodeScanSchedule schedule) {
        ScheduledFuture<?> future = this.scheduleNodeScan(schedule);
        LOG.warn("addToScheduleQueue future = {}", future);
        this.m_scheduledNodes.put(schedule.getNodeId(), future);
    }

    protected void updateNodeScheduleInQueue(NodeScanSchedule schedule) {
        ScheduledFuture<?> scheduledFuture = this.getScheduledFutureForNode(schedule.getNodeId());
        if (!scheduledFuture.isDone() && !scheduledFuture.isCancelled()) {
            scheduledFuture.cancel(true);
            scheduledFuture = this.scheduleNodeScan(schedule);
            this.m_scheduledNodes.put(schedule.getNodeId(), scheduledFuture);
        }
    }

    private ScheduledFuture<?> scheduleNodeScan(NodeScanSchedule schedule) {
        NodeScan nodeScan = this.createNodeScan(schedule.getNodeId(), schedule.getForeignSource(), schedule.getForeignId());
        LOG.warn("nodeScan = {}", (Object)nodeScan);
        return nodeScan.schedule(this.m_scheduledExecutor, schedule);
    }

    public ScheduledFuture<?> getScheduledFutureForNode(int nodeId) {
        return this.m_scheduledNodes.get(nodeId);
    }

    protected void removeNodeFromScheduleQueue(Integer nodeId) {
        ScheduledFuture<?> scheduledFuture = this.m_scheduledNodes.remove(nodeId);
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            scheduledFuture.cancel(true);
        }
    }

    protected void removeFromScheduleQueue(List<Integer> nodeIds) {
        for (Integer nodeId : nodeIds) {
            this.removeNodeFromScheduleQueue(nodeId);
        }
    }

    protected void checkNodeListForRemovals(List<NodeScanSchedule> schedules) {
        Set<Integer> keySet = this.m_scheduledNodes.keySet();
        ArrayList<Integer> markedForDelete = new ArrayList<Integer>();
        for (int nodeId : keySet) {
            boolean isDirty = false;
            for (NodeScanSchedule schedule : schedules) {
                if (schedule.getNodeId() != nodeId) continue;
                isDirty = true;
            }
            if (isDirty) continue;
            markedForDelete.add(nodeId);
        }
        this.removeFromScheduleQueue(markedForDelete);
    }

    public int getScheduleLength() {
        return this.m_scheduledNodes.size();
    }

    protected void importModelFromResource(Resource resource, String rescanExisting) throws Exception {
        this.importModelFromResource(resource, rescanExisting, new NoOpProvisionMonitor());
    }

    protected void importModelFromResource(Resource resource, String rescanExisting, ProvisionMonitor monitor) throws Exception {
        LifeCycleInstance doImport = this.m_lifeCycleRepository.createLifeCycleInstance("import", this.m_importActivities);
        doImport.setAttribute("resource", resource);
        doImport.setAttribute("rescanExisting", rescanExisting);
        doImport.trigger();
        doImport.waitFor();
        RequisitionImport ri = doImport.findAttributeByType(RequisitionImport.class);
        if (ri.isAborted()) {
            throw new ModelImportException("Import failed for resource " + resource.toString(), ri.getError());
        }
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void doImport() {
        Event e = null;
        this.doImport(e);
    }

    @EventHandler(uei="uei.opennms.org/internal/importer/reloadImport")
    public void doImport(Event event) {
        String url = this.getEventUrl(event);
        String rescanExistingOnImport = this.getEventRescanExistingOnImport(event);
        if (url != null) {
            this.doImport(url, rescanExistingOnImport);
        } else {
            String msg = "reloadImport event requires 'url' parameter";
            LOG.error("doImport: {}", (Object)"reloadImport event requires 'url' parameter");
            this.send(this.importFailedEvent("reloadImport event requires 'url' parameter", url, rescanExistingOnImport));
        }
    }

    public void doImport(String url, String rescanExisting) {
        try {
            Object resource;
            LOG.info("doImport: importing from url: {}, rescanExisting ? {}", (Object)url, (Object)rescanExisting);
            URL u = new URL(url);
            if ("file".equals(u.getProtocol())) {
                String filename;
                File file = new File(u.toURI());
                LOG.debug("doImport: file = {}", (Object)file);
                resource = file.exists() ? new FileSystemResource(file) : ((filename = file.getName()).contains("%20") ? new FileSystemResource(new File(file.getParentFile(), filename.replace("%20", " "))) : new UrlResource(url));
            } else {
                resource = new UrlResource(url);
            }
            this.m_stats = new TimeTrackingMonitor();
            this.send(this.importStartedEvent((Resource)resource, rescanExisting));
            this.importModelFromResource((Resource)resource, rescanExisting, this.m_stats);
            LOG.info("Finished Importing: {}", (Object)this.m_stats);
            this.send(this.importSuccessEvent(this.m_stats, url, rescanExisting));
        }
        catch (Throwable t) {
            String msg = "Exception importing " + url;
            LOG.error("Exception importing {} using rescanExisting={}", new Object[]{url, rescanExisting, t});
            this.send(this.importFailedEvent(msg + ": " + t.getMessage(), url, rescanExisting));
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAddedEvent(Event e) {
        NodeScanSchedule scheduleForNode = null;
        LOG.warn("node added event ({})", (Object)System.currentTimeMillis());
        try {
            scheduleForNode = this.getProvisionService().getScheduleForNode(e.getNodeid().intValue(), false);
        }
        catch (Throwable t) {
            LOG.error("getScheduleForNode fails", t);
        }
        LOG.warn("scheduleForNode is {}", (Object)scheduleForNode);
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(Event e) {
        final Integer nodeId = new Integer(e.getNodeid().intValue());
        this.removeNodeFromScheduleQueue(nodeId);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ForceRescanScan scan = Provisioner.this.createForceRescanScan(nodeId);
                    Task t = scan.createTask();
                    t.schedule();
                    t.waitFor();
                    NodeScanSchedule scheduleForNode = Provisioner.this.getProvisionService().getScheduleForNode(nodeId, false);
                    if (scheduleForNode != null) {
                        Provisioner.this.addToScheduleQueue(scheduleForNode);
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error("Task interrupted waiting for rescan of nodeId {} to finish", (Object)nodeId, (Object)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error("An expected execution occurred waiting for rescan of nodeId {} to finish", (Object)nodeId, (Object)ex);
                }
            }
        };
        this.m_scheduledExecutor.execute(r);
    }

    @EventHandler(uei="uei.opennms.org/internal/discovery/newSuspect")
    public void handleNewSuspectEvent(Event e) {
        String uei = e.getUei();
        final String ip = e.getInterface();
        String foreignSource = null;
        List parmCollection = e.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"foreignSource".equals(parm.getParmName())) continue;
            foreignSource = parm.getValue().getContent();
            break;
        }
        if (ip == null) {
            LOG.error("Received a {} event with a null ipAddress", (Object)uei);
            return;
        }
        if (!this.getProvisionService().isDiscoveryEnabled()) {
            LOG.info("Ignoring {} event for ip {} since discovery handling is disabled in provisiond", (Object)uei, (Object)ip);
            return;
        }
        final String fs = foreignSource;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress addr = InetAddressUtils.addr((String)ip);
                    if (addr == null) {
                        LOG.error("Unable to convert {} to an InetAddress.", (Object)ip);
                        return;
                    }
                    NewSuspectScan scan = Provisioner.this.createNewSuspectScan(addr, fs);
                    Task t = scan.createTask();
                    t.schedule();
                    t.waitFor();
                }
                catch (InterruptedException ex) {
                    LOG.error("Task interrupted waiting for new suspect scan of {} to finish", (Object)ip, (Object)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error("An expected execution occurred waiting for new suspect scan of {} to finish", (Object)ip, (Object)ex);
                }
            }
        };
        this.m_scheduledExecutor.execute(r);
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeUpdated")
    public void handleNodeUpdated(Event e) {
        LOG.debug("Node updated event received: {}", (Object)e);
        if (!Boolean.valueOf(System.getProperty(SCHEDULE_RESCAN_FOR_UPDATED_NODES, "true")).booleanValue()) {
            LOG.debug("Rescanning updated nodes is disabled via property: {}", (Object)SCHEDULE_RESCAN_FOR_UPDATED_NODES);
            return;
        }
        String rescanExisting = Boolean.TRUE.toString();
        for (Parm parm : e.getParmCollection()) {
            if (!"rescanExisting".equals(parm.getParmName()) || !"false".equalsIgnoreCase(parm.getValue().getContent()) && !"dbonly".equalsIgnoreCase(parm.getValue().getContent())) continue;
            rescanExisting = Boolean.FALSE.toString();
        }
        if (!Boolean.valueOf(rescanExisting).booleanValue()) {
            LOG.debug("Rescanning updated nodes is disabled via event parameter: {}", (Object)"rescanExisting");
            return;
        }
        this.removeNodeFromScheduleQueue(new Long(e.getNodeid()).intValue());
        NodeScanSchedule scheduleForNode = this.getProvisionService().getScheduleForNode(e.getNodeid().intValue(), true);
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeletedEvent(Event e) {
        this.removeNodeFromScheduleQueue(e.getNodeid().intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            LOG.info("handleReloadConfigEvent: reloading configuration...");
            EventBuilder ebldr = null;
            try {
                LOG.debug("handleReloadConfigEvent: lock acquired, unscheduling current reports...");
                this.m_importSchedule.rebuildImportSchedule();
                LOG.debug("handleRelodConfigEvent: reports rescheduled.");
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", NAME);
                ebldr.addParam("daemonName", NAME);
            }
            catch (Throwable exception) {
                LOG.error("handleReloadConfigurationEvent: Error reloading configuration", exception);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", NAME);
                ebldr.addParam("daemonName", NAME);
                ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.m_eventForwarder.sendNow(ebldr.getEvent());
            }
            LOG.info("handleReloadConfigEvent: configuration reloaded.");
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !NAME.equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Provisiond was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/addInterface")
    public void handleAddInterface(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doAddInterface(event.getNodeid(), event.getInterface());
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
            }
        }
    }

    private void doAddInterface(long nodeId, String ipAddr) {
        throw new UnsupportedOperationException("Provisioner.doAddInterface is not yet implemented");
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/addNode")
    public void handleAddNode(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doAddNode(event.getInterface(), EventUtils.getParm((Event)event, (String)"nodelabel"));
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
            }
        }
    }

    private void doAddNode(String ipAddr, String nodeLabel) {
        OnmsNode node = new OnmsNode();
        node.setLabel(nodeLabel);
        OnmsIpInterface iface = new OnmsIpInterface(InetAddressUtils.addr((String)ipAddr), node);
        iface.setIsManaged("M");
        iface.setPrimaryString("N");
        this.m_provisionService.insertNode(node);
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/changeService")
    public void handleChangeService(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doChangeService(event.getInterface(), event.getService(), EventUtils.getParm((Event)event, (String)"action"));
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
            }
        }
    }

    private void doChangeService(String ipAddr, String service, String action) {
        throw new UnsupportedOperationException("Provisioner.doChangeService is not yet implemented");
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteInterface")
    public void handleDeleteInterface(Event event) {
        try {
            this.doDeleteInterface(event.getNodeid(), event.getInterface());
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
        }
    }

    private void doDeleteInterface(long nodeId, String ipAddr) {
        this.m_provisionService.deleteInterface((int)nodeId, ipAddr);
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteNode")
    public void handleDeleteNode(Event event) {
        try {
            this.doDeleteNode(event.getNodeid());
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
        }
    }

    private void doDeleteNode(long nodeId) {
        this.m_provisionService.deleteNode((int)nodeId);
    }

    @EventHandler(uei="uei.opennms.org/nodes/deleteService")
    public void handleDeleteService(Event event) {
        try {
            this.doDeleteService(event.getNodeid(), event.getInterfaceAddress() == null ? null : event.getInterfaceAddress(), event.getService());
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
        }
    }

    private void doDeleteService(long nodeId, InetAddress addr, String service) {
        this.m_provisionService.deleteService((int)nodeId, addr, service);
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/updateServer")
    public void handleUpdateServer(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doUpdateServer(event.getInterface(), event.getHost(), EventUtils.getParm((Event)event, (String)"action"), EventUtils.getParm((Event)event, (String)"nodelabel"));
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
            }
        }
    }

    private void doUpdateServer(String ipAddr, String host, String action, String nodeLabel) {
        throw new UnsupportedOperationException("Provisioner.doUpdateServer is not yet implemented");
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/updateService")
    public void handleUpdateService(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doUpdateService(event.getInterface(), event.getService(), EventUtils.getParm((Event)event, (String)"action"), EventUtils.getParm((Event)event, (String)"nodelabel"));
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception processing event: {}", (Object)event.getUei(), (Object)e);
            }
        }
    }

    private void doUpdateService(String ipAddr, String service, String action, String nodeLabel) {
        throw new UnsupportedOperationException("Provisioner.doUpdateService is not yet implemented");
    }

    private String getEventUrl(Event event) {
        return EventUtils.getParm((Event)event, (String)"url");
    }

    private String getEventRescanExistingOnImport(Event event) {
        String rescanExisting = EventUtils.getParm((Event)event, (String)"importRescanExisting");
        if (rescanExisting == null) {
            String enabled = System.getProperty(SCHEDULE_RESCAN_FOR_UPDATED_NODES, "true");
            return enabled;
        }
        return rescanExisting;
    }

    public String getStats() {
        return this.m_stats == null ? "No Stats Availabile" : this.m_stats.toString();
    }

    private Event importSuccessEvent(TimeTrackingMonitor stats, String url, String rescanExisting) {
        return new EventBuilder("uei.opennms.org/internal/importer/importSuccessful", NAME).addParam("importResource", url).addParam("importRescanExisting", rescanExisting).addParam("importStats", stats.toString()).getEvent();
    }

    private void send(Event event) {
        this.m_eventForwarder.sendNow(event);
    }

    private Event importFailedEvent(String msg, String url, String rescanExisting) {
        return new EventBuilder("uei.opennms.org/internal/importer/importFailed", NAME).addParam("importResource", url).addParam("importRescanExisting", rescanExisting).addParam("failureMessage", msg).getEvent();
    }

    private Event importStartedEvent(Resource resource, String rescanExisting) {
        return new EventBuilder("uei.opennms.org/internal/importer/importStarted", NAME).addParam("importResource", resource.toString()).addParam("importRescanExisting", rescanExisting).getEvent();
    }

    protected String getEventForeignSource(Event event) {
        return EventUtils.getParm((Event)event, (String)"foreignSource");
    }

    public void waitFor() {
        ScheduledFuture<Void> future = this.m_scheduledExecutor.schedule(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        }, 0L, TimeUnit.SECONDS);
        try {
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

