/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.NeedsContainer;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskCoordinator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.service.IPAddressTableTracker;
import org.opennms.netmgt.provision.service.IPInterfaceTableTracker;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.service.NodeInfoScan;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.PhysInterfaceTableTracker;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.Scan;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class NodeScan
implements Scan {
    private static final Logger LOG = LoggerFactory.getLogger(NodeScan.class);
    private final Integer m_nodeId;
    private final String m_foreignSource;
    private final String m_foreignId;
    private final Date m_scanStamp;
    private final ProvisionService m_provisionService;
    private final EventForwarder m_eventForwarder;
    private final SnmpAgentConfigFactory m_agentConfigFactory;
    private final TaskCoordinator m_taskCoordinator;
    private boolean m_aborted = false;
    private OnmsNode m_node;
    private boolean m_agentFound = false;

    public NodeScan(Integer nodeId, String foreignSource, String foreignId, ProvisionService provisionService, EventForwarder eventForwarder, SnmpAgentConfigFactory agentConfigFactory, TaskCoordinator taskCoordinator) {
        this.m_nodeId = nodeId;
        this.m_foreignSource = foreignSource;
        this.m_foreignId = foreignId;
        this.m_scanStamp = new Date();
        this.m_provisionService = provisionService;
        this.m_eventForwarder = eventForwarder;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_taskCoordinator = taskCoordinator;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public OnmsNode getNode() {
        return this.m_node;
    }

    private void setAgentFound(boolean agentFound) {
        this.m_agentFound = agentFound;
    }

    private boolean isAgentFound() {
        return this.m_agentFound;
    }

    public Date getScanStamp() {
        return this.m_scanStamp;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public TaskCoordinator getTaskCoordinator() {
        return this.m_taskCoordinator;
    }

    public boolean isAborted() {
        return this.m_aborted;
    }

    public void abort(String reason) {
        this.m_aborted = true;
        LOG.info("Aborting Scan of node {} for the following reason: {}", (Object)this.m_nodeId, (Object)reason);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/provisiond/nodeScanAborted", "Provisiond");
        if (this.m_nodeId != null) {
            bldr.setNodeid((long)this.m_nodeId.intValue());
        }
        bldr.addParam("foreignSource", this.m_foreignSource);
        bldr.addParam("foreignId", this.m_foreignId);
        bldr.addParam("reason", reason);
        this.m_eventForwarder.sendNow(bldr.getEvent());
    }

    @Override
    public Task createTask() {
        return this.getTaskCoordinator().createBatch().add(new RunInBatch[]{this}).get();
    }

    public void run(BatchTask parent) {
        LOG.info("Scanning node {}/{}/{}", new Object[]{this.m_nodeId, this.m_foreignSource, this.m_foreignId});
        parent.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.loadNode(phase);
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.detectAgents(phase);
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.handleAgentUndetected(phase);
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeScan.this.scanCompleted(phase);
            }
        }});
    }

    ScheduledFuture<?> schedule(ScheduledExecutorService executor, NodeScanSchedule schedule) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Task t = NodeScan.this.createTask();
                    t.schedule();
                    t.waitFor();
                    LOG.info("Finished scanning node {}/{}/{}", new Object[]{NodeScan.this.getNodeId(), NodeScan.this.getForeignSource(), NodeScan.this.getForeignId()});
                }
                catch (InterruptedException e) {
                    LOG.warn("The node scan for node {}/{}/{} was interrupted", new Object[]{NodeScan.this.getNodeId(), NodeScan.this.getForeignSource(), NodeScan.this.getForeignId(), e});
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOG.warn("An error occurred while scanning node {}/{}/{}", new Object[]{NodeScan.this.getNodeId(), NodeScan.this.getForeignSource(), NodeScan.this.getForeignId(), e});
                }
            }
        };
        return executor.scheduleWithFixedDelay(r, schedule.getInitialDelay().getMillis(), schedule.getScanInterval().getMillis(), TimeUnit.MILLISECONDS);
    }

    public void loadNode(BatchTask loadNode) {
        if (this.getForeignSource() != null) {
            this.m_node = this.m_provisionService.getRequisitionedNode(this.getForeignSource(), this.getForeignId());
            if (this.m_node == null) {
                this.abort(String.format("Unable to get requisitioned node (%s/%s): aborted", this.m_foreignSource, this.m_foreignId));
            } else {
                for (OnmsIpInterface iface : this.m_node.getIpInterfaces()) {
                    loadNode.add((RunInBatch)new IpInterfaceScan(this.getNodeId(), iface.getIpAddress(), this.getForeignSource(), this.getProvisionService()));
                }
            }
        } else {
            this.m_node = this.m_provisionService.getNode(this.m_nodeId);
        }
    }

    public AgentScan createAgentScan(InetAddress agentAddress, String agentType) {
        return new AgentScan(this.getNodeId(), this.getNode(), agentAddress, agentType);
    }

    NoAgentScan createNoAgentScan() {
        return new NoAgentScan(this.getNodeId(), this.getNode());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("foreign source", (Object)this.m_foreignSource).append("foreign id", (Object)this.m_foreignId).append("node id", (Object)this.m_nodeId).append("aborted", this.m_aborted).append("provision service", (Object)this.m_provisionService).toString();
    }

    public void detectAgents(BatchTask currentPhase) {
        if (!this.isAborted()) {
            OnmsNode node = this.getNode();
            OnmsIpInterface primaryIface = this.getProvisionService().getPrimaryInterfaceForNode(node);
            if (primaryIface != null && primaryIface.getMonitoredServiceByServiceType("SNMP") != null) {
                LOG.debug("Found primary interface and SNMP service for node {}/{}/{}", new Object[]{node.getId(), node.getForeignSource(), node.getForeignId()});
                this.onAgentFound((ContainerTask<?>)currentPhase, primaryIface);
            } else {
                LOG.debug("Failed to locate primary interface and SNMP service for node {}/{}/{}", new Object[]{node.getId(), node.getForeignSource(), node.getForeignId()});
            }
        }
    }

    public void handleAgentUndetected(BatchTask currentPhase) {
        if (!this.isAgentFound()) {
            currentPhase.add((NeedsContainer)this.createNoAgentScan());
        }
    }

    private void onAgentFound(ContainerTask<?> currentPhase, OnmsIpInterface primaryIface) {
        currentPhase.add((NeedsContainer)this.createAgentScan(primaryIface.getIpAddress(), "SNMP"));
        this.setAgentFound(true);
    }

    public void scanCompleted(BatchTask currentPhase) {
        if (!this.isAborted()) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/provisiond/nodeScanCompleted", "Provisiond");
            bldr.setNodeid((long)this.getNodeId().intValue());
            bldr.addParam("foreignSource", this.getForeignSource());
            bldr.addParam("foreignId", this.getForeignId());
            this.getEventForwarder().sendNow(bldr.getEvent());
        }
    }

    public class BaseAgentScan {
        private OnmsNode m_node;
        private Integer m_nodeId;

        private BaseAgentScan(Integer nodeId, OnmsNode node) {
            this.m_nodeId = nodeId;
            this.m_node = node;
        }

        public Date getScanStamp() {
            return NodeScan.this.m_scanStamp;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public Integer getNodeId() {
            return this.m_nodeId;
        }

        public boolean isAborted() {
            return NodeScan.this.isAborted();
        }

        public void abort(String reason) {
            NodeScan.this.abort(reason);
        }

        public String getForeignSource() {
            return this.getNode() == null ? null : this.getNode().getForeignSource();
        }

        public String getForeignId() {
            return this.getNode() == null ? null : this.getNode().getForeignId();
        }

        public ProvisionService getProvisionService() {
            return NodeScan.this.m_provisionService;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("foreign source", (Object)this.getForeignSource()).append("foreign id", (Object)this.getForeignId()).append("node id", (Object)this.m_nodeId).append("scan stamp", (Object)NodeScan.this.m_scanStamp).toString();
        }

        void updateIpInterface(BatchTask currentPhase, OnmsIpInterface iface) {
            this.getProvisionService().updateIpInterfaceAttributes(this.getNodeId(), iface);
            if (iface.isManaged()) {
                currentPhase.add((RunInBatch)new IpInterfaceScan(this.getNodeId(), iface.getIpAddress(), this.getForeignSource(), this.getProvisionService()));
            }
        }

        protected Runnable ipUpdater(final BatchTask currentPhase, final OnmsIpInterface iface) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BaseAgentScan.this.updateIpInterface(currentPhase, iface);
                }
            };
            return r;
        }
    }

    public class NoAgentScan
    extends BaseAgentScan
    implements NeedsContainer {
        private NoAgentScan(Integer nodeId, OnmsNode node) {
            super(nodeId, node);
        }

        private void setNode(OnmsNode node) {
            NodeScan.this.m_node = node;
        }

        private void applyNodePolicies(BatchTask phase) {
            List<NodePolicy> nodePolicies = this.getProvisionService().getNodePoliciesForForeignSource(this.getForeignSource() == null ? "default" : this.getForeignSource());
            LOG.debug("NodeScan.applyNodePolicies: {}", nodePolicies);
            OnmsNode node = this.getNode();
            for (NodePolicy policy : nodePolicies) {
                if (node == null) continue;
                node = policy.apply(node);
            }
            if (node == null) {
                this.abort("Aborted scan of node due to configured policy");
            } else {
                this.setNode(node);
            }
        }

        void stampProvisionedInterfaces(BatchTask phase) {
            if (!this.isAborted()) {
                for (OnmsIpInterface iface : this.getNode().getIpInterfaces()) {
                    iface.setIpLastCapsdPoll(this.getScanStamp());
                    phase.add(this.ipUpdater(phase, iface), "write");
                }
            }
        }

        void deleteObsoleteResources(BatchTask phase) {
            if (!this.isAborted()) {
                this.getProvisionService().updateNodeScanStamp(this.getNodeId(), this.getScanStamp());
                this.getProvisionService().deleteObsoleteInterfaces(this.getNodeId(), this.getScanStamp());
            }
        }

        private void doPersistNodeInfo(BatchTask phase) {
            if (!this.isAborted()) {
                this.getProvisionService().updateNodeAttributes(this.getNode());
            }
            LOG.debug("Finished phase {}", (Object)phase);
        }

        public void run(ContainerTask<?> parent) {
            parent.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

                public void run(BatchTask phase) {
                    NoAgentScan.this.applyNodePolicies(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    NoAgentScan.this.stampProvisionedInterfaces(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    NoAgentScan.this.deleteObsoleteResources(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    NoAgentScan.this.doPersistNodeInfo(phase);
                }
            }});
        }
    }

    public class AgentScan
    extends BaseAgentScan
    implements NeedsContainer,
    ScanProgress {
        private final InetAddress m_agentAddress;
        private final String m_agentType;

        public AgentScan(Integer nodeId, OnmsNode node, InetAddress agentAddress, String agentType) {
            super(nodeId, node);
            this.m_agentAddress = agentAddress;
            this.m_agentType = agentType;
        }

        public InetAddress getAgentAddress() {
            return this.m_agentAddress;
        }

        public String getAgentType() {
            return this.m_agentType;
        }

        public void setNode(OnmsNode node) {
            NodeScan.this.m_node = node;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).append("address", (Object)this.m_agentAddress).append("type", (Object)this.m_agentType).toString();
        }

        public EventForwarder getEventForwarder() {
            return NodeScan.this.m_eventForwarder;
        }

        void completed() {
            if (!this.isAborted()) {
                EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "Provisiond");
                bldr.setNodeid((long)this.getNodeId().intValue());
                bldr.setInterface(this.getAgentAddress());
                this.getEventForwarder().sendNow(bldr.getEvent());
            }
        }

        void deleteObsoleteResources() {
            if (!this.isAborted()) {
                this.getProvisionService().updateNodeScanStamp(this.getNodeId(), this.getScanStamp());
                this.getProvisionService().deleteObsoleteInterfaces(this.getNodeId(), this.getScanStamp());
                LOG.debug("Finished deleteObsoleteResources for {}", (Object)this);
            }
        }

        public SnmpAgentConfigFactory getAgentConfigFactory() {
            return NodeScan.this.m_agentConfigFactory;
        }

        public void detectIpAddressTable(final BatchTask currentPhase) {
            OnmsNode node = this.getNode();
            LOG.debug("Attempting to scan the IPAddress table for node {}", (Object)node);
            final HashSet<InetAddress> provisionedIps = new HashSet<InetAddress>();
            if (this.getForeignSource() != null) {
                for (OnmsIpInterface provisioned : node.getIpInterfaces()) {
                    provisionedIps.add(provisioned.getIpAddress());
                }
            }
            IPAddressTableTracker ipAddressTracker = new IPAddressTableTracker(){

                @Override
                public void processIPAddressRow(IPAddressTableTracker.IPAddressRow row) {
                    String ipAddress = row.getIpAddress();
                    LOG.info("Processing IPAddress table row with ipAddr {}", (Object)ipAddress);
                    InetAddress address = InetAddressUtils.addr((String)ipAddress);
                    if (address == null) {
                        return;
                    }
                    if (address.isAnyLocalAddress()) {
                        LOG.debug("{}.isAnyLocalAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    if (address.isLinkLocalAddress()) {
                        LOG.debug("{}.isLinkLocalAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    if (address.isLoopbackAddress()) {
                        LOG.debug("{}.isLoopbackAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    if (address.isMulticastAddress()) {
                        LOG.debug("{}.isMulticastAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    provisionedIps.remove(ipAddress);
                    OnmsIpInterface iface = row.createInterfaceFromRow();
                    if (iface != null) {
                        iface.setIpLastCapsdPoll(AgentScan.this.getScanStamp());
                        iface.setIsManaged("M");
                        List<IpInterfacePolicy> policies = AgentScan.this.getProvisionService().getIpInterfacePoliciesForForeignSource(AgentScan.this.getForeignSource() == null ? "default" : AgentScan.this.getForeignSource());
                        for (IpInterfacePolicy policy : policies) {
                            if (iface == null) continue;
                            iface = policy.apply(iface);
                        }
                        if (iface != null) {
                            currentPhase.add(AgentScan.this.ipUpdater(currentPhase, iface), "write");
                        }
                    }
                }
            };
            this.walkTable(currentPhase, provisionedIps, ipAddressTracker);
        }

        public void detectIpInterfaceTable(final BatchTask currentPhase) {
            final OnmsNode node = this.getNode();
            LOG.debug("Attempting to scan the IPInterface table for node {}", (Object)node);
            final HashSet<InetAddress> provisionedIps = new HashSet<InetAddress>();
            if (this.getForeignSource() != null) {
                for (OnmsIpInterface provisioned : node.getIpInterfaces()) {
                    provisionedIps.add(provisioned.getIpAddress());
                }
            }
            IPInterfaceTableTracker ipIfTracker = new IPInterfaceTableTracker(){

                @Override
                public void processIPInterfaceRow(IPInterfaceTableTracker.IPInterfaceRow row) {
                    String ipAddress = row.getIpAddress();
                    LOG.info("Processing IPInterface table row with ipAddr {} for node {}/{}/{}", new Object[]{ipAddress, node.getId(), node.getForeignSource(), node.getForeignId()});
                    InetAddress address = InetAddressUtils.addr((String)ipAddress);
                    if (address == null) {
                        return;
                    }
                    if (address.isAnyLocalAddress()) {
                        LOG.debug("{}.isAnyLocalAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    if (address.isLinkLocalAddress()) {
                        LOG.debug("{}.isLinkLocalAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    if (address.isLoopbackAddress()) {
                        LOG.debug("{}.isLoopbackAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    if (address.isMulticastAddress()) {
                        LOG.debug("{}.isMulticastAddress() == true, Skipping.", (Object)ipAddress);
                        return;
                    }
                    provisionedIps.remove(ipAddress);
                    OnmsIpInterface iface = row.createInterfaceFromRow();
                    if (iface != null) {
                        iface.setIpLastCapsdPoll(AgentScan.this.getScanStamp());
                        iface.setIsManaged("M");
                        List<IpInterfacePolicy> policies = AgentScan.this.getProvisionService().getIpInterfacePoliciesForForeignSource(AgentScan.this.getForeignSource() == null ? "default" : AgentScan.this.getForeignSource());
                        for (IpInterfacePolicy policy : policies) {
                            if (iface == null) continue;
                            iface = policy.apply(iface);
                        }
                        if (iface != null) {
                            currentPhase.add(AgentScan.this.ipUpdater(currentPhase, iface), "write");
                        }
                    }
                }
            };
            this.walkTable(currentPhase, provisionedIps, ipIfTracker);
        }

        private void walkTable(BatchTask currentPhase, Set<InetAddress> provisionedIps, TableTracker tracker) {
            OnmsNode node = this.getNode();
            LOG.info("detecting IP interfaces for node {}/{}/{} using table tracker {}", new Object[]{node.getId(), node.getForeignSource(), node.getForeignId(), tracker});
            if (this.isAborted()) {
                LOG.debug("'{}' is marked as aborted; skipping scan of table {}", (Object)currentPhase, (Object)tracker);
            } else {
                Assert.notNull((Object)this.getAgentConfigFactory(), (String)"agentConfigFactory was not injected");
                SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(this.getAgentAddress());
                SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"IP address tables", (CollectionTracker)tracker);
                walker.start();
                try {
                    walker.waitFor();
                    if (walker.timedOut()) {
                        this.abort("Aborting node scan : Agent timed out while scanning the IP address tables");
                    } else if (walker.failed()) {
                        this.abort("Aborting node scan : Agent failed while scanning the IP address tables : " + walker.getErrorMessage());
                    } else {
                        for (InetAddress ipAddr : provisionedIps) {
                            OnmsIpInterface iface = node.getIpInterfaceByIpAddress(ipAddr);
                            if (iface == null) continue;
                            iface.setIpLastCapsdPoll(this.getScanStamp());
                            iface.setIsManaged("M");
                            currentPhase.add(this.ipUpdater(currentPhase, iface), "write");
                        }
                        LOG.debug("Finished phase {}", (Object)currentPhase);
                    }
                }
                catch (InterruptedException e) {
                    this.abort("Aborting node scan : Scan thread failed while waiting for the IP address tables");
                }
            }
        }

        public void detectPhysicalInterfaces(final BatchTask currentPhase) {
            if (this.isAborted()) {
                return;
            }
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(this.getAgentAddress());
            Assert.notNull((Object)this.getAgentConfigFactory(), (String)"agentConfigFactory was not injected");
            PhysInterfaceTableTracker physIfTracker = new PhysInterfaceTableTracker(){

                @Override
                public void processPhysicalInterfaceRow(PhysInterfaceTableTracker.PhysicalInterfaceRow row) {
                    LOG.info("Processing ifTable row for ifIndex {} on node {}/{}/{}", new Object[]{row.getIfIndex(), AgentScan.this.getNodeId(), AgentScan.this.getForeignSource(), AgentScan.this.getForeignId()});
                    OnmsSnmpInterface snmpIface = row.createInterfaceFromRow();
                    snmpIface.setLastCapsdPoll(AgentScan.this.getScanStamp());
                    List<SnmpInterfacePolicy> policies = AgentScan.this.getProvisionService().getSnmpInterfacePoliciesForForeignSource(AgentScan.this.getForeignSource() == null ? "default" : AgentScan.this.getForeignSource());
                    for (SnmpInterfacePolicy policy : policies) {
                        if (snmpIface == null) continue;
                        snmpIface = policy.apply(snmpIface);
                    }
                    if (snmpIface != null) {
                        final OnmsSnmpInterface snmpIfaceResult = snmpIface;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                AgentScan.this.getProvisionService().updateSnmpInterfaceAttributes(AgentScan.this.getNodeId(), snmpIfaceResult);
                            }
                        };
                        currentPhase.add(r, "write");
                    }
                }
            };
            SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"ifTable/ifXTable", (CollectionTracker)physIfTracker);
            walker.start();
            try {
                walker.waitFor();
                if (walker.timedOut()) {
                    this.abort("Aborting node scan : Agent timed out while scanning the interfaces table");
                } else if (walker.failed()) {
                    this.abort("Aborting node scan : Agent failed while scanning the interfaces table: " + walker.getErrorMessage());
                } else {
                    LOG.debug("Finished phase {}", (Object)currentPhase);
                }
            }
            catch (InterruptedException e) {
                this.abort("Aborting node scan : Scan thread interrupted while waiting for interfaces table");
                Thread.currentThread().interrupt();
            }
        }

        public void run(ContainerTask<?> parent) {
            parent.getBuilder().addSequence(new RunInBatch[]{new NodeInfoScan(this.getNode(), this.getAgentAddress(), this.getForeignSource(), this, this.getAgentConfigFactory(), this.getProvisionService(), this.getNodeId()), new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.detectPhysicalInterfaces(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.detectIpAddressTable(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.detectIpInterfaceTable(phase);
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.deleteObsoleteResources();
                }
            }, new RunInBatch(){

                public void run(BatchTask phase) {
                    AgentScan.this.completed();
                }
            }});
        }
    }
}

