/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.AbstractTask;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.PersistsAgentInfo;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.service.AsyncDetectorRunner;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpInterfaceScan
implements RunInBatch {
    private static final Logger LOG = LoggerFactory.getLogger(IpInterfaceScan.class);
    private final ProvisionService m_provisionService;
    private final InetAddress m_address;
    private final Integer m_nodeId;
    private final String m_foreignSource;

    public IpInterfaceScan(Integer nodeId, InetAddress address, String foreignSource, ProvisionService provisionService) {
        this.m_nodeId = nodeId;
        this.m_address = address;
        this.m_foreignSource = foreignSource;
        this.m_provisionService = provisionService;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("address", (Object)this.m_address).append("foreign source", (Object)this.m_foreignSource).append("node ID", (Object)this.m_nodeId).toString();
    }

    public static Callback<Boolean> servicePersister(final BatchTask currentPhase, final ProvisionService service, final ServiceDetector detector, final int nodeId, final InetAddress address) {
        return new Callback<Boolean>(){

            public void accept(Boolean serviceDetected) {
                final String hostAddress = InetAddressUtils.str((InetAddress)address);
                LOG.info("Attempted to detect service {} on address {}: {}", new Object[]{detector.getServiceName(), hostAddress, serviceDetected});
                if (serviceDetected.booleanValue()) {
                    currentPhase.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

                        public void run(BatchTask batch) {
                            if ("SNMP".equals(detector.getServiceName())) {
                                service.setIsPrimaryFlag(nodeId, hostAddress);
                            }
                        }
                    }, new RunInBatch(){

                        public void run(BatchTask batch) {
                            if (detector instanceof PersistsAgentInfo) {
                                ((PersistsAgentInfo)detector).persistAgentInfo(Integer.valueOf(nodeId), address);
                            }
                        }
                    }, new RunInBatch(){

                        public void run(BatchTask batch) {
                            service.addMonitoredService(nodeId, hostAddress, detector.getServiceName());
                        }
                    }, new RunInBatch(){

                        public void run(BatchTask batch) {
                            service.updateMonitoredServiceState(nodeId, hostAddress, detector.getServiceName());
                        }
                    }});
                }
            }

            public Boolean apply(Throwable t) {
                LOG.info("Exception occurred while trying to detect service {} on address {}", new Object[]{detector.getServiceName(), InetAddressUtils.str((InetAddress)address), t});
                return false;
            }
        };
    }

    protected static Runnable runDetector(final SyncServiceDetector detector, final InetAddress address, final Callback<Boolean> cb) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Attemping to detect service {} on address {}", (Object)detector.getServiceName(), (Object)InetAddressUtils.str((InetAddress)address));
                    cb.accept((Object)detector.isServiceDetected(address));
                }
                catch (Throwable t) {
                    cb.handleException(t);
                }
                finally {
                    detector.dispose();
                }
            }

            public String toString() {
                return String.format("Run detector %s on address %s", detector.getServiceName(), InetAddressUtils.str((InetAddress)address));
            }
        };
    }

    protected static Async<Boolean> runDetector(AsyncServiceDetector detector, InetAddress address) {
        return new AsyncDetectorRunner(detector, address);
    }

    protected static AbstractTask createDetectorTask(BatchTask currentPhase, ProvisionService service, ServiceDetector detector, int nodeId, InetAddress address) {
        if (detector instanceof SyncServiceDetector) {
            return IpInterfaceScan.createSyncDetectorTask(currentPhase, service, (SyncServiceDetector)detector, nodeId, address);
        }
        return IpInterfaceScan.createAsyncDetectorTask(currentPhase, service, (AsyncServiceDetector)detector, nodeId, address);
    }

    protected static AbstractTask createAsyncDetectorTask(BatchTask currentPhase, ProvisionService service, AsyncServiceDetector asyncDetector, int nodeId, InetAddress address) {
        return currentPhase.getCoordinator().createTask((ContainerTask)currentPhase, IpInterfaceScan.runDetector(asyncDetector, address), IpInterfaceScan.servicePersister(currentPhase, service, (ServiceDetector)asyncDetector, nodeId, address));
    }

    protected static AbstractTask createSyncDetectorTask(BatchTask currentPhase, ProvisionService service, SyncServiceDetector syncDetector, int nodeId, InetAddress address) {
        return currentPhase.getCoordinator().createTask((ContainerTask)currentPhase, IpInterfaceScan.runDetector(syncDetector, address, IpInterfaceScan.servicePersister(currentPhase, service, (ServiceDetector)syncDetector, nodeId, address)));
    }

    public void run(BatchTask currentPhase) {
        List<ServiceDetector> detectors = this.getProvisionService().getDetectorsForForeignSource(this.getForeignSource() == null ? "default" : this.getForeignSource());
        LOG.info("Detecting services for node {}/{} on address {}: found {} detectors", new Object[]{this.getNodeId(), this.getForeignSource(), InetAddressUtils.str((InetAddress)this.getAddress()), detectors.size()});
        for (ServiceDetector detector : detectors) {
            if (!IpInterfaceScan.shouldDetect(detector, this.getAddress())) continue;
            currentPhase.add(IpInterfaceScan.createDetectorTask(currentPhase, this.getProvisionService(), detector, this.getNodeId(), this.getAddress()));
        }
    }

    protected static boolean shouldDetect(ServiceDetector detector, InetAddress address) {
        String ipMatch = detector.getIpMatch();
        if (ipMatch == null || ipMatch.trim().isEmpty()) {
            return true;
        }
        if (ipMatch.startsWith("~")) {
            return address.getHostAddress().matches(ipMatch.substring(1));
        }
        return IpInterfaceScan.isIpMatching(address, ipMatch);
    }

    protected static boolean isIpMatching(InetAddress ip, String expr) {
        try {
            JexlEngine parser = new JexlEngine();
            Expression e = parser.createExpression(IpInterfaceScan.generateExpr(expr));
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("iplike", IPLike.class);
            context.put("ipaddr", ip.getHostAddress());
            Boolean out = (Boolean)e.evaluate((JexlContext)new MapContext(context));
            return out;
        }
        catch (Exception e) {
            LOG.error("Can't process rule '{}' while checking IP {} because {}", new Object[]{expr, ip, e});
            return false;
        }
    }

    protected static String generateExpr(String basicExpr) {
        LOG.debug("generateExpr: original expression {}", (Object)basicExpr);
        String data = basicExpr;
        Pattern p = Pattern.compile("[0-9a-f:.,\\-*]+");
        Matcher m = p.matcher(data);
        while (m.find()) {
            data = data.replace(m.group(), "iplike.matches(ipaddr,'" + m.group() + "')");
        }
        LOG.debug("generateExpr: computed expression {}", (Object)data);
        return data;
    }
}

