/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncDetectorRunner
implements Async<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDetectorRunner.class);
    private final InetAddress m_address;
    private final AsyncServiceDetector m_detector;

    public AsyncDetectorRunner(AsyncServiceDetector detector, InetAddress address) {
        this.m_detector = detector;
        this.m_address = address;
    }

    public void supplyAsyncThenAccept(Callback<Boolean> cb) {
        try {
            LOG.info("Attemping to detect service {} asynchronously on address {}", (Object)this.m_detector.getServiceName(), (Object)this.getHostAddress());
            DetectFuture future = this.m_detector.isServiceDetected(this.m_address);
            future.addListener((DetectFutureListener)new RunCallbackListener(cb));
            future.addListener((DetectFutureListener)new DisposeDetectorListener(this.m_detector));
        }
        catch (Throwable e) {
            cb.handleException(e);
            this.m_detector.dispose();
        }
    }

    private String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.m_address);
    }

    public String toString() {
        return String.format("Run detector %s on address %s", this.m_detector.getServiceName(), this.getHostAddress());
    }

    private static class DisposeDetectorListener
    implements DetectFutureListener<DetectFuture> {
        private final AsyncServiceDetector m_detector;

        public DisposeDetectorListener(AsyncServiceDetector detector) {
            this.m_detector = detector;
        }

        public void operationComplete(DetectFuture future) {
            this.m_detector.dispose();
        }
    }

    private static class RunCallbackListener
    implements DetectFutureListener<DetectFuture> {
        private final Callback<Boolean> m_callback;

        public RunCallbackListener(Callback<Boolean> cb) {
            this.m_callback = cb;
        }

        public void operationComplete(DetectFuture future) {
            if (future.getException() != null) {
                this.m_callback.handleException(future.getException());
            } else {
                this.m_callback.accept((Object)future.isServiceDetected());
            }
        }
    }
}

