/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.OnmsPolicy;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.service.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class DefaultPluginRegistry
implements PluginRegistry,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPluginRegistry.class);
    @Autowired(required=false)
    Set<SyncServiceDetector> m_syncDetectors;
    @Autowired(required=false)
    Set<AsyncServiceDetector> m_asyncDetectors;
    @Autowired(required=false)
    Set<NodePolicy> m_nodePolicies;
    @Autowired(required=false)
    Set<IpInterfacePolicy> m_ipInterfacePolicies;
    @Autowired(required=false)
    Set<SnmpInterfacePolicy> m_snmpInterfacePolicies;
    @Autowired
    ServiceRegistry m_serviceRegistry;
    @Autowired
    private ApplicationContext m_applicationContext;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        this.addAllExtensions(this.m_asyncDetectors, AsyncServiceDetector.class, ServiceDetector.class);
        this.addAllExtensions(this.m_syncDetectors, SyncServiceDetector.class, ServiceDetector.class);
        this.addAllExtensions(this.m_nodePolicies, NodePolicy.class, OnmsPolicy.class);
        this.addAllExtensions(this.m_ipInterfacePolicies, IpInterfacePolicy.class, OnmsPolicy.class);
        this.addAllExtensions(this.m_snmpInterfacePolicies, SnmpInterfacePolicy.class, OnmsPolicy.class);
    }

    private static void debug(String format, Object ... args) {
        LOG.debug(format, args);
    }

    private static void info(String format, Object ... args) {
        LOG.info(format, args);
    }

    private static void error(Throwable cause, String format, Object ... args) {
        if (cause == null) {
            LOG.error(format, args);
        } else {
            LOG.error(format, (Object)args, (Object)cause);
        }
    }

    private <T> void addAllExtensions(Collection<T> extensions, Class<?> ... extensionPoints) {
        if (extensions == null || extensions.isEmpty()) {
            DefaultPluginRegistry.info("Found NO Extensions for ExtensionPoints {}", Arrays.toString(extensionPoints));
            return;
        }
        for (T extension : extensions) {
            DefaultPluginRegistry.info("Register Extension {} for ExtensionPoints {}", extension, Arrays.toString(extensionPoints));
            this.m_serviceRegistry.register(extension, (Class[])extensionPoints);
        }
    }

    @Override
    public <T> Collection<T> getAllPlugins(Class<T> pluginClass) {
        return this.beansOfType(pluginClass).values();
    }

    @Override
    public <T> T getPluginInstance(Class<T> pluginClass, PluginConfig pluginConfig) {
        T pluginInstance = this.beanWithNameOfType(pluginConfig.getPluginClass(), pluginClass);
        if (pluginInstance == null) {
            return null;
        }
        HashMap parameters = new HashMap(pluginConfig.getParameterMap());
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(pluginInstance);
        try {
            wrapper.setPropertyValues(parameters);
        }
        catch (BeansException e) {
            DefaultPluginRegistry.error(e, "Could not set properties on report definition: {}", e.getMessage());
        }
        return pluginInstance;
    }

    private <T> Map<String, T> beansOfType(Class<T> pluginClass) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.m_applicationContext, pluginClass, (boolean)true, (boolean)true);
    }

    private <T> T beanWithNameOfType(String beanName, Class<T> pluginClass) {
        Map<String, T> beans = this.beansOfType(pluginClass);
        T bean = beans.get(beanName);
        if (bean != null) {
            DefaultPluginRegistry.debug("Found bean {} with name {} of type {}", bean, beanName, pluginClass);
        } else {
            DefaultPluginRegistry.debug("Failed to find bean {} with name {} of type {}", bean, beanName, pluginClass);
        }
        return bean;
    }
}

