/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.service.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IfTableEntry
extends SnmpTableEntry {
    private static final Logger LOG = LoggerFactory.getLogger(IfTableEntry.class);
    public static final String IF_INDEX = "ifIndex";
    public static final String IF_DESCR = "ifDescr";
    public static final String IF_TYPE = "ifType";
    public static final String IF_MTU = "ifMtu";
    public static final String IF_SPEED = "ifSpeed";
    public static final String IF_PHYS_ADDR = "ifPhysAddr";
    public static final String IF_ADMIN_STATUS = "ifAdminStatus";
    public static final String IF_OPER_STATUS = "ifOperStatus";
    public static final String IF_LAST_CHANGE = "ifLastChange";
    public static final String IF_IN_OCTETS = "ifInOctets";
    public static final String IF_IN_UCAST = "ifInUcastPkts";
    public static final String IF_IN_NUCAST = "ifInNUcastPkts";
    public static final String IF_IN_DISCARDS = "ifInDiscards";
    public static final String IF_IN_ERRORS = "ifInErrors";
    public static final String IF_IN_UKNOWN_PROTOS = "ifInUnknownProtos";
    public static final String IF_OUT_OCTETS = "ifOutOctets";
    public static final String IF_OUT_UCAST = "ifOutUcastPkts";
    public static final String IF_OUT_NUCAST = "ifOutNUcastPkts";
    public static final String IF_OUT_DISCARDS = "ifOutDiscards";
    public static final String IF_OUT_ERRORS = "ifOutErrors";
    public static final String IF_OUT_QLEN = "ifOutQLen";
    public static final String IF_SPECIFIC = "ifSpecific";
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String TABLE_OID = ".1.3.6.1.2.1.2.2.1";

    public IfTableEntry() {
        super(ms_elemList);
    }

    public Integer getIfType() {
        return this.getInt32(IF_TYPE);
    }

    public Integer getIfAdminStatus() {
        return this.getInt32(IF_ADMIN_STATUS);
    }

    public String getIfDescr() {
        return this.getDisplayString(IF_DESCR);
    }

    public String getPhysAddr() {
        try {
            String hexString = this.getHexString(IF_PHYS_ADDR);
            if (hexString != null && hexString.length() == 12) {
                return hexString;
            }
            String mac = this.getDisplayString(IF_PHYS_ADDR);
            return mac == null || mac.trim().isEmpty() ? null : InetAddressUtils.normalizeMacAddress((String)mac);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return this.getDisplayString(IF_PHYS_ADDR);
        }
    }

    public Integer getIfOperStatus() {
        return this.getInt32(IF_OPER_STATUS);
    }

    public Long getIfSpeed() {
        return this.getUInt32(IF_SPEED);
    }

    static {
        ms_elemList = new NamedSnmpVar[9];
        int ndx = 0;
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", IF_INDEX, ".1.3.6.1.2.1.2.2.1.1", 1);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", IF_DESCR, ".1.3.6.1.2.1.2.2.1.2", 2);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", IF_TYPE, ".1.3.6.1.2.1.2.2.1.3", 3);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", IF_MTU, ".1.3.6.1.2.1.2.2.1.4", 4);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpGauge32", IF_SPEED, ".1.3.6.1.2.1.2.2.1.5", 5);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", IF_PHYS_ADDR, ".1.3.6.1.2.1.2.2.1.6", 6);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", IF_ADMIN_STATUS, ".1.3.6.1.2.1.2.2.1.7", 7);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", IF_OPER_STATUS, ".1.3.6.1.2.1.2.2.1.8", 8);
        IfTableEntry.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpTimeTicks", IF_LAST_CHANGE, ".1.3.6.1.2.1.2.2.1.9", 9);
    }
}

