/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventAccumulator
implements EventForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(EventAccumulator.class);
    private final EventForwarder m_eventForwarder;
    private final List<Event> m_events = new ArrayList<Event>();

    public EventAccumulator(EventForwarder forwarder) {
        this.m_eventForwarder = forwarder;
    }

    public synchronized void sendNow(Event event) {
        this.m_events.add(event);
    }

    public synchronized void sendNow(Log log) {
        if (log != null && log.getEvents() != null && log.getEvents().getEventCount() > 0) {
            for (Event e : log.getEvents().getEventCollection()) {
                this.m_events.add(e);
            }
        }
    }

    public synchronized void flush() {
        LOG.debug("flush(): sending {} events: {}", (Object)this.m_events.size(), this.m_events);
        for (Event e : this.m_events) {
            this.m_eventForwarder.sendNow(e);
        }
        this.m_events.clear();
    }
}

