/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.service.NodeInfoScan;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.Scan;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceRescanScan
implements Scan {
    private static final Logger LOG = LoggerFactory.getLogger(ForceRescanScan.class);
    private Integer m_nodeId;
    private ProvisionService m_provisionService;
    private EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private DefaultTaskCoordinator m_taskCoordinator;

    public ForceRescanScan(Integer nodeId, ProvisionService provisionService, EventForwarder eventForwarder, SnmpAgentConfigFactory agentConfigFactory, DefaultTaskCoordinator taskCoordinator) {
        this.m_nodeId = nodeId;
        this.m_provisionService = provisionService;
        this.m_eventForwarder = eventForwarder;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_taskCoordinator = taskCoordinator;
    }

    @Override
    public Task createTask() {
        return this.m_taskCoordinator.createBatch().add(new RunInBatch[]{this}).get();
    }

    public void run(BatchTask phase) {
        this.scanExistingNode(phase);
    }

    protected void scanExistingNode(BatchTask phase) {
        LOG.info("Attempting to re-scan node with Id {}", (Object)this.m_nodeId);
        OnmsNode node = this.m_provisionService.getNode(this.m_nodeId);
        if (node != null) {
            OnmsIpInterface iface = this.m_provisionService.getPrimaryInterfaceForNode(node);
            if (iface == null) {
                iface = node.getIpInterfaces().isEmpty() ? null : (OnmsIpInterface)node.getIpInterfaces().iterator().next();
            } else {
                LOG.info("The node with ID OP does not have a primary interface", (Object)this.m_nodeId);
            }
            if (iface == null) {
                LOG.info("The node with ID {} does not have any IP addresses", (Object)this.m_nodeId);
            } else {
                phase.getBuilder().addSequence(new RunInBatch[]{new NodeInfoScan(node, iface.getIpAddress(), node.getForeignSource(), this.createScanProgress(), this.m_agentConfigFactory, this.m_provisionService, node.getId()), new IpInterfaceScan(node.getId(), iface.getIpAddress(), node.getForeignSource(), this.m_provisionService), new NodeScan(node.getId(), node.getForeignSource(), node.getForeignId(), this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator)});
            }
        } else {
            LOG.info("Can't find node with ID {}", (Object)this.m_nodeId);
        }
    }

    private ScanProgress createScanProgress() {
        return new ScanProgress(){
            private boolean m_aborted = false;

            @Override
            public void abort(String message) {
                this.m_aborted = true;
                LOG.info(message);
            }

            @Override
            public boolean isAborted() {
                return this.m_aborted;
            }
        };
    }

    protected void reparentNodes(BatchTask batch, Integer nodeId) {
        LOG.debug("reparenting node ID {} not supported", (Object)nodeId);
    }
}

