/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.SequenceTask;
import org.opennms.core.tasks.Task;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleRepository;
import org.opennms.netmgt.provision.service.lifecycle.Phase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultLifeCycleInstance
extends SequenceTask
implements LifeCycleInstance {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLifeCycleInstance.class);
    final BatchTask m_containingPhase;
    final LifeCycleRepository m_repository;
    final DefaultTaskCoordinator m_coordinator;
    final String m_name;
    final Phase[] m_phases;
    final Object[] m_providers;
    final Map<String, Object> m_attributes = new HashMap<String, Object>();

    public DefaultLifeCycleInstance(BatchTask containingPhase, LifeCycleRepository repository, DefaultTaskCoordinator coordinator, String lifeCycleName, String[] phaseNames, Object[] providers) {
        super(coordinator, (ContainerTask)containingPhase);
        this.m_containingPhase = containingPhase;
        this.m_repository = repository;
        this.m_coordinator = coordinator;
        this.m_name = lifeCycleName;
        this.m_providers = providers;
        LOG.debug("Set up default lifecycle instance");
        this.m_phases = new Phase[phaseNames.length];
        for (int i = 0; i < phaseNames.length; ++i) {
            this.m_phases[i] = new Phase((ContainerTask<?>)this, this, phaseNames[i], this.m_providers);
            LOG.debug("Adding phase {} to lifecycle", (Object)this.m_phases[i].getName());
            this.add((Task)this.m_phases[i]);
        }
        this.setAttribute("lifeCycleInstance", this);
    }

    public DefaultLifeCycleInstance(LifeCycleRepository repository, DefaultTaskCoordinator coordinator, String lifeCycleName, String[] phaseNames, Object[] providers) {
        this(null, repository, coordinator, lifeCycleName, Arrays.copyOf(phaseNames, phaseNames.length), Arrays.copyOf(providers, providers.length));
    }

    @Override
    public List<String> getPhaseNames() {
        ArrayList<String> phaseNames = new ArrayList<String>(this.m_phases.length);
        for (Phase phase : this.m_phases) {
            phaseNames.add(phase.getName());
        }
        return phaseNames;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Object getAttribute(String key) {
        return this.m_attributes.get(key);
    }

    @Override
    public <T> T getAttribute(String key, T defaultValue) {
        if (this.getAttribute(key) == null) {
            return defaultValue;
        }
        return this.getAttribute(key, this.getClass(defaultValue));
    }

    public <T> Class<T> getClass(T t) {
        return t.getClass();
    }

    @Override
    public <T> T getAttribute(String key, Class<T> type) {
        return type.cast(this.getAttribute(key));
    }

    @Override
    public LifeCycleInstance setAttribute(String key, Object value) {
        this.m_attributes.put(key, value);
        return this;
    }

    @Override
    public <T> T findAttributeByType(Class<T> clazz) {
        T result = null;
        for (Map.Entry<String, Object> entry : this.m_attributes.entrySet()) {
            if (!clazz.isInstance(entry.getValue())) continue;
            if (result != null) {
                throw new IllegalStateException("More than one attribute of type " + clazz + " in lifecycle " + this);
            }
            result = clazz.cast(entry.getValue());
        }
        return result;
    }

    @Override
    public LifeCycleInstance createNestedLifeCycle(BatchTask containingPhase, String lifeCycleName) {
        return this.m_repository.createNestedLifeCycleInstance(containingPhase, lifeCycleName, this.m_providers);
    }

    @Override
    public void trigger() {
        if (this.m_containingPhase != null) {
            this.m_containingPhase.add((Task)this);
        } else {
            this.schedule();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.m_name).append("containing phase", (Object)this.m_containingPhase).append("repository", (Object)this.m_repository).append("coordinator", (Object)this.m_coordinator).toString();
    }
}

