/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.service.HostnameResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public final class DefaultHostnameResolver
implements HostnameResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHostnameResolver.class);

    @Override
    public String getHostname(InetAddress addr) {
        String hostName = addr.getCanonicalHostName();
        if (InetAddressUtils.str((InetAddress)addr).equals(hostName)) {
            try {
                hostName = Address.getHostName((InetAddress)addr);
            }
            catch (UnknownHostException e) {
                LOG.warn("Failed to retrieve the fully qualified domain name for {}. Using the textual representation of the IP address.", (Object)addr);
            }
        }
        return hostName;
    }
}

