/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.netmgt.provision.service.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnmpTable<T extends SnmpTableEntry>
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTable.class);
    private Map<SnmpInstId, T> m_results = new TreeMap<SnmpInstId, T>();
    private InetAddress m_address;
    private String m_tableName;

    protected SnmpTable(InetAddress address, String tableName, NamedSnmpVar[] columns) {
        this(address, tableName, columns, null);
    }

    protected SnmpTable(InetAddress address, String tableName, NamedSnmpVar[] columns, Set<SnmpInstId> instances) {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])columns, instances));
        this.m_address = address;
        this.m_tableName = tableName;
    }

    protected void storeResult(SnmpResult res) {
        SnmpTableEntry entry = (SnmpTableEntry)((Object)this.m_results.get(res.getInstance()));
        if (entry == null) {
            entry = this.createTableEntry(res.getBase(), res.getInstance(), res.getValue());
            this.m_results.put(res.getInstance(), (T)((Object)entry));
        }
        entry.storeResult(res);
    }

    protected abstract T createTableEntry(SnmpObjId var1, SnmpInstId var2, Object var3);

    public Set<SnmpInstId> getInstances() {
        return this.m_results.keySet();
    }

    public List<T> getEntries() {
        return new ArrayList<T>(this.m_results.values());
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving {} from {}. {}", new Object[]{msg, this.m_tableName, this.m_address});
    }

    public T getEntry(SnmpInstId inst) {
        if (this.failed()) {
            return null;
        }
        return (T)((Object)((SnmpTableEntry)((Object)this.m_results.get(inst))));
    }

    public T getEntry(int inst) {
        return this.getEntry(new SnmpInstId(inst));
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving {} from {}. {}", new Object[]{msg, this.m_tableName, this.m_address});
    }
}

