/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.List;
import org.opennms.netmgt.provision.service.WorkDuration;
import org.opennms.netmgt.provision.service.WorkEffort;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.SaveOrUpdateOperation;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.core.io.Resource;

public class TimeTrackingMonitor
implements ProvisionMonitor {
    private WorkDuration m_importDuration = new WorkDuration("Importing");
    private WorkDuration m_auditDuration = new WorkDuration("Auditing");
    private WorkDuration m_loadingDuration = new WorkDuration("Loading");
    private WorkDuration m_processingDuration = new WorkDuration("Processing");
    private WorkDuration m_preprocessingDuration = new WorkDuration("Scanning");
    private WorkDuration m_relateDuration = new WorkDuration("Relating");
    private WorkEffort m_preprocessingEffort = new WorkEffort("Scan Effort");
    private WorkEffort m_processingEffort = new WorkEffort("Write Effort");
    private WorkEffort m_eventEffort = new WorkEffort("Event Sending Effort");
    private int m_deleteCount;
    private int m_insertCount;
    private int m_updateCount;
    private int m_eventCount;

    @Override
    public void beginProcessingOps(int deleteCount, int updateCount, int insertCount) {
        this.m_deleteCount = deleteCount;
        this.m_updateCount = updateCount;
        this.m_insertCount = insertCount;
        this.m_processingDuration.start();
    }

    @Override
    public void finishProcessingOps() {
        this.m_processingDuration.end();
    }

    @Override
    public void beginPreprocessingOps() {
        this.m_preprocessingDuration.start();
    }

    @Override
    public void finishPreprocessingOps() {
        this.m_preprocessingDuration.end();
    }

    @Override
    public void beginPreprocessing(ImportOperation oper) {
        if (oper instanceof SaveOrUpdateOperation) {
            this.m_preprocessingEffort.begin();
        }
    }

    @Override
    public void finishPreprocessing(ImportOperation oper) {
        if (oper instanceof SaveOrUpdateOperation) {
            this.m_preprocessingEffort.end();
        }
    }

    @Override
    public void beginPersisting(ImportOperation oper) {
        this.m_processingEffort.begin();
    }

    @Override
    public void finishPersisting(ImportOperation oper) {
        this.m_processingEffort.end();
    }

    @Override
    public void beginSendingEvents(ImportOperation oper, List<Event> events) {
        if (events != null) {
            this.m_eventCount += events.size();
        }
        this.m_eventEffort.begin();
    }

    @Override
    public void finishSendingEvents(ImportOperation oper, List<Event> events) {
        this.m_eventEffort.end();
    }

    @Override
    public void beginLoadingResource(Resource resource) {
        this.m_loadingDuration.setName("Loading Resource: " + resource);
        this.m_loadingDuration.start();
    }

    @Override
    public void finishLoadingResource(Resource resource) {
        this.m_loadingDuration.end();
    }

    @Override
    public void beginImporting() {
        this.m_importDuration.start();
    }

    @Override
    public void finishImporting() {
        this.m_importDuration.end();
    }

    @Override
    public void beginAuditNodes() {
        this.m_auditDuration.start();
    }

    @Override
    public void finishAuditNodes() {
        this.m_auditDuration.end();
    }

    @Override
    public void beginRelateNodes() {
        this.m_relateDuration.start();
    }

    @Override
    public void finishRelateNodes() {
        this.m_relateDuration.end();
    }

    public String toString() {
        StringBuffer stats = new StringBuffer();
        stats.append("Deletes: ").append(this.m_deleteCount).append(", ");
        stats.append("Updates: ").append(this.m_updateCount).append(", ");
        stats.append("Inserts: ").append(this.m_insertCount).append("\n");
        stats.append(this.m_importDuration).append(", ");
        stats.append(this.m_loadingDuration).append(", ");
        stats.append(this.m_auditDuration).append('\n');
        stats.append(this.m_preprocessingDuration).append(", ");
        stats.append(this.m_processingDuration).append(", ");
        stats.append(this.m_relateDuration).append("\n");
        stats.append(this.m_preprocessingEffort).append(", ");
        stats.append(this.m_processingEffort).append(", ");
        stats.append(this.m_eventEffort);
        if (this.m_eventCount > 0) {
            stats.append(", Avg ").append((double)this.m_eventEffort.getTotalTime() / (double)this.m_eventCount).append(" ms per event");
        }
        return stats.toString();
    }
}

