/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.service.AsyncDetectorRunner;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpInterfaceScan
implements RunInBatch {
    private static final Logger LOG = LoggerFactory.getLogger(IpInterfaceScan.class);
    private ProvisionService m_provisionService;
    private InetAddress m_address;
    private Integer m_nodeId;
    private String m_foreignSource;

    public IpInterfaceScan(Integer nodeId, InetAddress address, String foreignSource, ProvisionService provisionService) {
        this.m_nodeId = nodeId;
        this.m_address = address;
        this.m_foreignSource = foreignSource;
        this.m_provisionService = provisionService;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("address", (Object)this.m_address).append("foreign source", (Object)this.m_foreignSource).append("node ID", (Object)this.m_nodeId).toString();
    }

    public Callback<Boolean> servicePersister(final BatchTask currentPhase, final String serviceName) {
        return new Callback<Boolean>(){

            public void complete(Boolean serviceDetected) {
                final String hostAddress = InetAddressUtils.str((InetAddress)IpInterfaceScan.this.getAddress());
                LOG.info("Attempted to detect service {} on address {}: {}", new Object[]{serviceName, hostAddress, serviceDetected});
                if (serviceDetected.booleanValue()) {
                    currentPhase.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

                        public void run(BatchTask batch) {
                            if ("SNMP".equals(serviceName)) {
                                IpInterfaceScan.this.setupAgentInfo(currentPhase);
                            }
                        }
                    }, new RunInBatch(){

                        public void run(BatchTask batch) {
                            IpInterfaceScan.this.getProvisionService().addMonitoredService(IpInterfaceScan.this.getNodeId(), hostAddress, serviceName);
                        }
                    }});
                }
                IpInterfaceScan.this.getProvisionService().updateMonitoredServiceState(IpInterfaceScan.this.getNodeId(), hostAddress, serviceName);
            }

            public void handleException(Throwable t) {
                LOG.info("Exception occurred while trying to detect service {} on address {}", new Object[]{serviceName, InetAddressUtils.str((InetAddress)IpInterfaceScan.this.getAddress()), t});
            }
        };
    }

    Runnable runDetector(final SyncServiceDetector detector, final Callback<Boolean> cb) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Attemping to detect service {} on address {}", (Object)detector.getServiceName(), (Object)InetAddressUtils.str((InetAddress)IpInterfaceScan.this.getAddress()));
                    cb.complete((Object)detector.isServiceDetected(IpInterfaceScan.this.getAddress()));
                }
                catch (Throwable t) {
                    cb.handleException(t);
                }
                finally {
                    detector.dispose();
                }
            }

            public String toString() {
                return String.format("Run detector %s on address %s", detector.getServiceName(), InetAddressUtils.str((InetAddress)IpInterfaceScan.this.getAddress()));
            }
        };
    }

    Async<Boolean> runDetector(AsyncServiceDetector detector) {
        return new AsyncDetectorRunner(this, detector);
    }

    Task createDetectorTask(BatchTask currentPhase, ServiceDetector detector) {
        if (detector instanceof SyncServiceDetector) {
            return this.createSyncDetectorTask(currentPhase, (SyncServiceDetector)detector);
        }
        return this.createAsyncDetectorTask(currentPhase, (AsyncServiceDetector)detector);
    }

    private Task createAsyncDetectorTask(BatchTask currentPhase, AsyncServiceDetector asyncDetector) {
        return currentPhase.getCoordinator().createTask((ContainerTask)currentPhase, this.runDetector(asyncDetector), this.servicePersister(currentPhase, asyncDetector.getServiceName()));
    }

    private Task createSyncDetectorTask(BatchTask currentPhase, SyncServiceDetector syncDetector) {
        return currentPhase.getCoordinator().createTask((ContainerTask)currentPhase, this.runDetector(syncDetector, this.servicePersister(currentPhase, syncDetector.getServiceName())));
    }

    public void run(BatchTask currentPhase) {
        List<ServiceDetector> detectors = this.getProvisionService().getDetectorsForForeignSource(this.getForeignSource() == null ? "default" : this.getForeignSource());
        LOG.info("Detecting services for node {}/{} on address {}: found {} detectors", new Object[]{this.getNodeId(), this.getForeignSource(), InetAddressUtils.str((InetAddress)this.getAddress()), detectors.size()});
        for (ServiceDetector detector : detectors) {
            if (!this.shouldDetect(detector)) continue;
            currentPhase.add(this.createDetectorTask(currentPhase, detector));
        }
    }

    private void setupAgentInfo(BatchTask currentphase) {
        this.getProvisionService().setIsPrimaryFlag(this.getNodeId(), InetAddressUtils.str((InetAddress)this.getAddress()));
    }

    protected boolean shouldDetect(ServiceDetector detector) {
        String ipMatch = detector.getIpMatch();
        if (ipMatch == null || ipMatch.trim().isEmpty()) {
            return true;
        }
        if (ipMatch.startsWith("~")) {
            return this.getAddress().getHostAddress().matches(ipMatch.substring(1));
        }
        return this.isIpMatching(this.getAddress(), ipMatch);
    }

    private boolean isIpMatching(InetAddress ip, String expr) {
        try {
            JexlEngine parser = new JexlEngine();
            Expression e = parser.createExpression(this.generateExpr(expr));
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("iplike", IPLike.class);
            context.put("ipaddr", ip.getHostAddress());
            Boolean out = (Boolean)e.evaluate((JexlContext)new MapContext(context));
            return out;
        }
        catch (Exception e) {
            LOG.error("Can't process rule '{}' while checking IP {} because {}", new Object[]{expr, ip, e});
            return false;
        }
    }

    private String generateExpr(String basicExpr) {
        LOG.debug("generateExpr: original expression {}", (Object)basicExpr);
        String data = basicExpr;
        Pattern p = Pattern.compile("[0-9a-f:.,\\-*]+");
        Matcher m = p.matcher(data);
        while (m.find()) {
            data = data.replace(m.group(), "iplike.matches(ipaddr,'" + m.group() + "')");
        }
        LOG.debug("generateExpr: computed expression {}", (Object)data);
        return data;
    }
}

