/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.service.NodeInfoScan;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.Scan;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewSuspectScan
implements Scan {
    private static final Logger LOG = LoggerFactory.getLogger(NewSuspectScan.class);
    private InetAddress m_ipAddress;
    private ProvisionService m_provisionService;
    private EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private DefaultTaskCoordinator m_taskCoordinator;
    private String m_foreignSource;

    public NewSuspectScan(InetAddress ipAddress, ProvisionService provisionService, EventForwarder eventForwarder, SnmpAgentConfigFactory agentConfigFactory, DefaultTaskCoordinator taskCoordinator, String foreignSource) {
        this.m_ipAddress = ipAddress;
        this.m_provisionService = provisionService;
        this.m_eventForwarder = eventForwarder;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_taskCoordinator = taskCoordinator;
        this.m_foreignSource = foreignSource;
    }

    @Override
    public Task createTask() {
        return this.m_taskCoordinator.createBatch().add(new RunInBatch[]{this}).get();
    }

    public void run(BatchTask phase) {
        this.scanUndiscoveredNode(phase);
    }

    protected void scanUndiscoveredNode(BatchTask phase) {
        String addrString = InetAddressUtils.str((InetAddress)this.m_ipAddress);
        LOG.info("Attempting to scan new suspect address {} for foreign source {}", (Object)addrString, (Object)this.m_foreignSource);
        OnmsNode node = this.m_provisionService.createUndiscoveredNode(addrString, this.m_foreignSource);
        if (node != null) {
            phase.getBuilder().addSequence(new RunInBatch[]{new NodeInfoScan(node, this.m_ipAddress, null, this.createScanProgress(), this.m_agentConfigFactory, this.m_provisionService, null), new IpInterfaceScan(node.getId(), this.m_ipAddress, null, this.m_provisionService), new NodeScan(node.getId(), null, null, this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator)});
        }
    }

    private ScanProgress createScanProgress() {
        return new ScanProgress(){
            private boolean m_aborted = false;

            @Override
            public void abort(String message) {
                this.m_aborted = true;
                LOG.info(message);
            }

            @Override
            public boolean isAborted() {
                return this.m_aborted;
            }
        };
    }

    protected void reparentNodes(BatchTask batch, Integer nodeId) {
        LOG.debug("reparenting node ID {} not supported", (Object)nodeId);
    }
}

