/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectFutureListener;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncDetectorRunner
implements Async<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDetectorRunner.class);
    private final IpInterfaceScan m_ifaceScan;
    private final AsyncServiceDetector m_detector;

    public AsyncDetectorRunner(IpInterfaceScan ifaceScan, AsyncServiceDetector detector) {
        this.m_ifaceScan = ifaceScan;
        this.m_detector = detector;
    }

    public void submit(Callback<Boolean> cb) {
        try {
            LOG.info("Attemping to detect service {} on address {}", (Object)this.m_detector.getServiceName(), (Object)this.getHostAddress());
            DetectFuture future = this.m_detector.isServiceDetected(this.m_ifaceScan.getAddress());
            future.addListener(this.listener(cb));
        }
        catch (Throwable e) {
            cb.handleException(e);
        }
    }

    private String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.m_ifaceScan.getAddress());
    }

    public String toString() {
        return String.format("Run detector %s on address %s", this.m_detector.getServiceName(), this.getHostAddress());
    }

    private DetectFutureListener<DetectFuture> listener(final Callback<Boolean> cb) {
        return new DetectFutureListener<DetectFuture>(){

            public void operationComplete(DetectFuture future) {
                try {
                    if (future.getException() != null) {
                        cb.handleException(future.getException());
                    } else {
                        cb.complete((Object)future.isServiceDetected());
                    }
                }
                finally {
                    AsyncDetectorRunner.this.m_detector.dispose();
                }
            }
        };
    }
}

