/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.service.IPAddressTableTracker;
import org.opennms.netmgt.provision.service.snmp.NamedSnmpVar;
import org.opennms.netmgt.provision.service.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;

public final class IpAddressTableEntry
extends SnmpTableEntry {
    public static final String IP_ADDRESS_IF_INDEX = "ipAddressIfIndex";
    public static final String IP_ADDR_ENT_NETMASK = "ipAddressPrefix";
    public static final String IP_ADDR_TYPE = "ipAddressType";
    public static final String TABLE_OID = "..1.3.6.1.2.1.4.34.1";
    public static NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpObjectId", "ipAddressIfIndex", "..1.3.6.1.2.1.4.34.1.3", 1), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpObjectId", "ipAddressPrefix", "..1.3.6.1.2.1.4.34.1.5", 2), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpObjectId", "ipAddressType", "..1.3.6.1.2.1.4.34.1.4", 3)};
    private InetAddress m_inetAddress = null;

    public IpAddressTableEntry() {
        super(ms_elemList);
    }

    public InetAddress getIpAddress() {
        return this.m_inetAddress;
    }

    public Integer getIpAddressIfIndex() {
        return this.getInt32(IP_ADDRESS_IF_INDEX);
    }

    public InetAddress getIpAddressNetMask() {
        SnmpValue value = this.getValue(IP_ADDR_ENT_NETMASK);
        SnmpInstId netmaskRef = value.toSnmpObjId().getInstance(IPAddressTableTracker.IP_ADDRESS_PREFIX_ORIGIN_INDEX);
        if (netmaskRef == null) {
            LogUtils.warnf((Object)((Object)this), (String)"Unable to get netmask reference from instance.", (Object[])new Object[0]);
            return null;
        }
        int[] rawIds = netmaskRef.getIds();
        int addressType = rawIds[1];
        int addressLength = rawIds[2];
        InetAddress address = InetAddressUtils.getInetAddress((int[])rawIds, (int)3, (int)addressLength);
        int mask = rawIds[rawIds.length - 1];
        if (addressType == 1) {
            return InetAddressUtils.convertCidrToInetAddressV4((int)mask);
        }
        if (addressType == 2) {
            return InetAddressUtils.convertCidrToInetAddressV6((int)mask);
        }
        if (addressType == 4) {
            LogUtils.debugf((Object)((Object)this), (String)"Got an IPv6z address, returning %s", (Object[])new Object[]{address});
        } else {
            LogUtils.warnf((Object)((Object)this), (String)"Unsure how to handle IP address type (%d)", (Object[])new Object[]{addressType});
        }
        return address;
    }

    @Override
    public void storeResult(SnmpResult result) {
        int[] instanceIds = result.getInstance().getIds();
        int addressType = instanceIds[1];
        if (addressType == 1 || addressType == 2 || addressType == 4) {
            this.m_inetAddress = InetAddressUtils.getInetAddress((int[])instanceIds, (int)2, (int)addressType);
        } else {
            LogUtils.warnf((Object)((Object)this), (String)"Unable to determine IP address type (%d)", (Object[])new Object[]{addressType});
        }
        super.storeResult(result);
    }
}

