/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.core.tasks.Task;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.url.GenericURLFactory;
import org.opennms.netmgt.config.SnmpAgentConfigFactory;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.service.CoreImportActivities;
import org.opennms.netmgt.provision.service.ImportScheduler;
import org.opennms.netmgt.provision.service.ModelImportException;
import org.opennms.netmgt.provision.service.NewSuspectScan;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ProvisioningAdapterManager;
import org.opennms.netmgt.provision.service.TimeTrackingMonitor;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleRepository;
import org.opennms.netmgt.provision.service.operations.NoOpProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.RequisitionImport;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@EventListener(name="Provisiond:EventListener")
public class Provisioner
implements SpringServiceDaemon {
    public static final String NAME = "Provisiond";
    private DefaultTaskCoordinator m_taskCoordinator;
    private CoreImportActivities m_importActivities;
    private LifeCycleRepository m_lifeCycleRepository;
    private ProvisionService m_provisionService;
    private ScheduledExecutorService m_scheduledExecutor;
    private final Map<Integer, ScheduledFuture<?>> m_scheduledNodes = new ConcurrentHashMap();
    private volatile EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private volatile TimeTrackingMonitor m_stats;
    @Autowired
    private ProvisioningAdapterManager m_manager;
    private ImportScheduler m_importSchedule;

    public void setProvisionService(ProvisionService provisionService) {
        this.m_provisionService = provisionService;
    }

    public ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.m_scheduledExecutor = scheduledExecutor;
    }

    public void setLifeCycleRepository(LifeCycleRepository lifeCycleRepository) {
        this.m_lifeCycleRepository = lifeCycleRepository;
    }

    public void setImportSchedule(ImportScheduler schedule) {
        this.m_importSchedule = schedule;
    }

    public void setImportActivities(CoreImportActivities importActivities) {
        this.m_importActivities = importActivities;
    }

    public void setTaskCoordinator(DefaultTaskCoordinator taskCoordinator) {
        this.m_taskCoordinator = taskCoordinator;
    }

    public void setAgentConfigFactory(SnmpAgentConfigFactory agentConfigFactory) {
        this.m_agentConfigFactory = agentConfigFactory;
    }

    public ImportScheduler getImportSchedule() {
        return this.m_importSchedule;
    }

    public void start() throws Exception {
        this.m_manager.initializeAdapters();
        this.scheduleRescanForExistingNodes();
        this.m_importSchedule.start();
    }

    public void destroy() throws Exception {
        this.m_importSchedule.stop();
        this.m_scheduledExecutor.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        GenericURLFactory.initialize();
    }

    protected void scheduleRescanForExistingNodes() {
        List<NodeScanSchedule> schedules = this.m_provisionService.getScheduleForNodes();
        this.checkNodeListForRemovals(schedules);
        for (NodeScanSchedule schedule : schedules) {
            if (!this.m_scheduledNodes.containsKey(schedule.getNodeId())) {
                this.addToScheduleQueue(schedule);
                continue;
            }
            this.updateNodeScheduleInQueue(schedule);
        }
    }

    public void doNodeScan(int nodeId) throws InterruptedException, ExecutionException {
    }

    public NodeScan createNodeScan(Integer nodeId, String foreignSource, String foreignId) {
        this.log().info("createNodeScan called");
        return new NodeScan(nodeId, foreignSource, foreignId, this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator);
    }

    public NewSuspectScan createNewSuspectScan(InetAddress ipAddress) {
        this.log().info("createNewSuspectScan called");
        return new NewSuspectScan(ipAddress, this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator);
    }

    protected void addToScheduleQueue(NodeScanSchedule schedule) {
        ScheduledFuture<?> future = this.scheduleNodeScan(schedule);
        this.log().warn("addToScheduleQueue future = " + future);
        this.m_scheduledNodes.put(schedule.getNodeId(), future);
    }

    protected void updateNodeScheduleInQueue(NodeScanSchedule schedule) {
        ScheduledFuture<?> scheduledFuture = this.getScheduledFutureForNode(schedule.getNodeId());
        if (!scheduledFuture.isDone() && !scheduledFuture.isCancelled()) {
            scheduledFuture.cancel(true);
            scheduledFuture = this.scheduleNodeScan(schedule);
            this.m_scheduledNodes.put(schedule.getNodeId(), scheduledFuture);
        }
    }

    private ScheduledFuture<?> scheduleNodeScan(NodeScanSchedule schedule) {
        NodeScan nodeScan = this.createNodeScan(schedule.getNodeId(), schedule.getForeignSource(), schedule.getForeignId());
        this.log().warn("nodeScan = " + nodeScan);
        return nodeScan.schedule(this.m_scheduledExecutor, schedule);
    }

    public ScheduledFuture<?> getScheduledFutureForNode(int nodeId) {
        ScheduledFuture<?> scheduledFuture = this.m_scheduledNodes.get(nodeId);
        return scheduledFuture;
    }

    protected void removeNodeFromScheduleQueue(Integer nodeId) {
        ScheduledFuture<?> scheduledFuture = this.m_scheduledNodes.remove(nodeId);
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            scheduledFuture.cancel(true);
        }
    }

    protected void removeFromScheduleQueue(List<Integer> nodeIds) {
        for (Integer nodeId : nodeIds) {
            this.removeNodeFromScheduleQueue(nodeId);
        }
    }

    protected void checkNodeListForRemovals(List<NodeScanSchedule> schedules) {
        Set<Integer> keySet = this.m_scheduledNodes.keySet();
        ArrayList<Integer> markedForDelete = new ArrayList<Integer>();
        for (int nodeId : keySet) {
            boolean isDirty = false;
            for (NodeScanSchedule schedule : schedules) {
                if (schedule.getNodeId() != nodeId) continue;
                isDirty = true;
            }
            if (isDirty) continue;
            markedForDelete.add(nodeId);
        }
        this.removeFromScheduleQueue(markedForDelete);
    }

    public int getScheduleLength() {
        return this.m_scheduledNodes.size();
    }

    protected void importModelFromResource(Resource resource, Boolean rescanExisting) throws Exception {
        this.importModelFromResource(resource, rescanExisting, new NoOpProvisionMonitor());
    }

    protected void importModelFromResource(Resource resource, Boolean rescanExisting, ProvisionMonitor monitor) throws Exception {
        LifeCycleInstance doImport = this.m_lifeCycleRepository.createLifeCycleInstance("import", this.m_importActivities);
        doImport.setAttribute("resource", resource);
        doImport.setAttribute("rescanExisting", (boolean)rescanExisting);
        doImport.trigger();
        doImport.waitFor();
        RequisitionImport ri = doImport.findAttributeByType(RequisitionImport.class);
        if (ri.isAborted()) {
            throw new ModelImportException("Import failed for resource " + resource.toString(), ri.getError());
        }
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void doImport() {
        Event e = null;
        this.doImport(e);
    }

    @EventHandler(uei="uei.opennms.org/internal/importer/reloadImport")
    public void doImport(Event event) {
        String url = this.getEventUrl(event);
        boolean rescanExistingOnImport = this.getEventRescanExistingOnImport(event);
        if (url != null) {
            this.doImport(url, rescanExistingOnImport);
        } else {
            String msg = "reloadImport event requires 'url' parameter";
            this.log().error("doImport: reloadImport event requires 'url' parameter");
            this.send(this.importFailedEvent("reloadImport event requires 'url' parameter", url));
        }
    }

    public void doImport(String url, boolean rescanExisting) {
        try {
            this.log().info("doImport: importing from url: " + url + "...");
            UrlResource resource = new UrlResource(url);
            this.m_stats = new TimeTrackingMonitor();
            this.send(this.importStartedEvent((Resource)resource));
            this.importModelFromResource((Resource)resource, rescanExisting, this.m_stats);
            this.log().info("Finished Importing: " + this.m_stats);
            this.send(this.importSuccessEvent(this.m_stats, url));
        }
        catch (Throwable t) {
            String msg = "Exception importing " + url;
            this.log().error(msg, t);
            this.send(this.importFailedEvent(msg + ": " + t.getMessage(), url));
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAddedEvent(Event e) {
        NodeScanSchedule scheduleForNode = null;
        this.log().warn("node added event (" + System.currentTimeMillis() + ")");
        try {
            scheduleForNode = this.getProvisionService().getScheduleForNode(new Long(e.getNodeid()).intValue(), false);
        }
        catch (Throwable t) {
            this.log().error("getScheduleForNode fails", t);
        }
        this.log().warn("scheduleForNode is " + scheduleForNode);
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(Event e) {
        this.removeNodeFromScheduleQueue(new Long(e.getNodeid()).intValue());
        NodeScanSchedule scheduleForNode = this.getProvisionService().getScheduleForNode(new Long(e.getNodeid()).intValue(), true);
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/discovery/newSuspect")
    public void handleNewSuspectEvent(Event e) {
        String uei = e.getUei();
        final String ip = e.getInterface();
        if (ip == null) {
            this.log().error("Received a " + uei + " event with a null ipAddress");
            return;
        }
        if (!this.getProvisionService().isDiscoveryEnabled()) {
            this.log().info("Ignoring " + uei + " event for ip " + ip + " since discovery handling is disabled in provisiond");
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress addr = InetAddressUtils.addr((String)ip);
                    if (addr == null) {
                        Provisioner.this.log().error("Unable to convert " + ip + " to an InetAddress.");
                        return;
                    }
                    NewSuspectScan scan = Provisioner.this.createNewSuspectScan(addr);
                    Task t = scan.createTask();
                    t.schedule();
                    t.waitFor();
                }
                catch (InterruptedException ex) {
                    Provisioner.this.log().error("Task interrupted waiting for new suspect scan of " + ip + " to finish", (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Provisioner.this.log().error("An expected execution occurred waiting for new suspect scan of " + ip + " to finish", (Throwable)ex);
                }
            }
        };
        this.m_scheduledExecutor.execute(r);
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeUpdated")
    public void handleNodeUpdated(Event e) {
        this.removeNodeFromScheduleQueue(new Long(e.getNodeid()).intValue());
        NodeScanSchedule scheduleForNode = this.getProvisionService().getScheduleForNode(new Long(e.getNodeid()).intValue(), true);
        if (scheduleForNode != null) {
            this.addToScheduleQueue(scheduleForNode);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeletedEvent(Event e) {
        this.removeNodeFromScheduleQueue(new Long(e.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            this.log().info("handleReloadConfigEvent: reloading configuration...");
            EventBuilder ebldr = null;
            try {
                this.log().debug("handleReloadConfigEvent: lock acquired, unscheduling current reports...");
                this.m_importSchedule.rebuildImportSchedule();
                this.log().debug("handleRelodConfigEvent: reports rescheduled.");
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", NAME);
                ebldr.addParam("daemonName", NAME);
            }
            catch (Throwable exception) {
                this.log().error("handleReloadConfigurationEvent: Error reloading configuration:" + exception, exception);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", NAME);
                ebldr.addParam("daemonName", NAME);
                ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.m_eventForwarder.sendNow(ebldr.getEvent());
            }
            this.log().info("handleReloadConfigEvent: configuration reloaded.");
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !NAME.equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        this.log().debug("isReloadConfigEventTarget: Provisiond was target of reload event: " + isTarget);
        return isTarget;
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/addInterface")
    public void handleAddInterface(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doAddInterface(event.getNodeid(), event.getInterface());
            }
            catch (Throwable e) {
                this.log().error("Unexpected exception processing event: " + event.getUei(), e);
            }
        }
    }

    private void doAddInterface(long nodeId, String ipAddr) {
        throw new UnsupportedOperationException("Provisioner.doAddInterface is not yet implemented");
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/addNode")
    public void handleAddNode(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doAddNode(event.getInterface(), EventUtils.getParm((Event)event, (String)"nodelabel"));
            }
            catch (Throwable e) {
                this.log().error("Unexpected exception processing event: " + event.getUei(), e);
            }
        }
    }

    private void doAddNode(String ipAddr, String nodeLabel) {
        OnmsNode node = new OnmsNode();
        node.setLabel(nodeLabel);
        OnmsIpInterface iface = new OnmsIpInterface(ipAddr, node);
        iface.setIsManaged("M");
        iface.setPrimaryString("N");
        this.m_provisionService.insertNode(node);
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/changeService")
    public void handleChangeService(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doChangeService(event.getInterface(), event.getService(), EventUtils.getParm((Event)event, (String)"action"));
            }
            catch (Throwable e) {
                this.log().error("Unexpected exception processing event: " + event.getUei(), e);
            }
        }
    }

    private void doChangeService(String ipAddr, String service, String action) {
        throw new UnsupportedOperationException("Provisioner.doChangeService is not yet implemented");
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteInterface")
    public void handleDeleteInterface(Event event) {
        try {
            this.doDeleteInterface(event.getNodeid(), event.getInterface());
        }
        catch (Throwable e) {
            this.log().error("Unexpected exception processing event: " + event.getUei(), e);
        }
    }

    private void doDeleteInterface(long nodeId, String ipAddr) {
        this.m_provisionService.deleteInterface((int)nodeId, ipAddr);
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteNode")
    public void handleDeleteNode(Event event) {
        try {
            this.doDeleteNode(event.getNodeid());
        }
        catch (Throwable e) {
            this.log().error("Unexpected exception processing event: " + event.getUei(), e);
        }
    }

    private void doDeleteNode(long nodeId) {
        this.m_provisionService.deleteNode((int)nodeId);
    }

    @EventHandler(uei="uei.opennms.org/nodes/deleteService")
    public void handleDeleteService(Event event) {
        try {
            this.doDeleteService(event.getNodeid(), event.getInterfaceAddress() == null ? null : event.getInterfaceAddress(), event.getService());
        }
        catch (Throwable e) {
            this.log().error("Unexpected exception processing event: " + event.getUei(), e);
        }
    }

    private void doDeleteService(long nodeId, InetAddress addr, String service) {
        this.m_provisionService.deleteService((int)nodeId, addr, service);
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/updateServer")
    public void handleUpdateServer(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doUpdateServer(event.getInterface(), event.getHost(), EventUtils.getParm((Event)event, (String)"action"), EventUtils.getParm((Event)event, (String)"nodelabel"));
            }
            catch (Throwable e) {
                this.log().error("Unexpected exception processing event: " + event.getUei(), e);
            }
        }
    }

    private void doUpdateServer(String ipAddr, String host, String action, String nodeLabel) {
        throw new UnsupportedOperationException("Provisioner.doUpdateServer is not yet implemented");
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/updateService")
    public void handleUpdateService(Event event) {
        if (this.m_provisionService.isDiscoveryEnabled()) {
            try {
                this.doUpdateService(event.getInterface(), event.getService(), EventUtils.getParm((Event)event, (String)"action"), EventUtils.getParm((Event)event, (String)"nodelabel"));
            }
            catch (Throwable e) {
                this.log().error("Unexpected exception processing event: " + event.getUei(), e);
            }
        }
    }

    private void doUpdateService(String ipAddr, String service, String action, String nodeLabel) {
        throw new UnsupportedOperationException("Provisioner.doUpdateService is not yet implemented");
    }

    private String getEventUrl(Event event) {
        return EventUtils.getParm((Event)event, (String)"url");
    }

    private boolean getEventRescanExistingOnImport(Event event) {
        String rescanExisting = EventUtils.getParm((Event)event, (String)"importRescanExisting");
        if (rescanExisting == null) {
            return true;
        }
        return Boolean.parseBoolean(rescanExisting);
    }

    public String getStats() {
        return this.m_stats == null ? "No Stats Availabile" : this.m_stats.toString();
    }

    private Event importSuccessEvent(TimeTrackingMonitor stats, String url) {
        return new EventBuilder("uei.opennms.org/internal/importer/importSuccessful", NAME).addParam("importResource", url).addParam("importStats", stats.toString()).getEvent();
    }

    private void send(Event event) {
        this.m_eventForwarder.sendNow(event);
    }

    private Event importFailedEvent(String msg, String url) {
        return new EventBuilder("uei.opennms.org/internal/importer/importFailed", NAME).addParam("importResource", url).addParam("failureMessage", msg).getEvent();
    }

    private Event importStartedEvent(Resource resource) {
        return new EventBuilder("uei.opennms.org/internal/importer/importStarted", NAME).addParam("importResource", resource.toString()).getEvent();
    }

    protected String getEventForeignSource(Event event) {
        return EventUtils.getParm((Event)event, (String)"foreignSource");
    }
}

