/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.dao.support.CreateIfNecessaryTemplate;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PathElement;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.events.AddEventVisitor;
import org.opennms.netmgt.model.events.DeleteEventVisitor;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.UpdateEventVisitor;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.NodeScanSchedule;
import org.opennms.netmgt.provision.service.PluginRegistry;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DefaultProvisionService
implements ProvisionService,
InitializingBean {
    private static final String FOREIGN_SOURCE_FOR_DISCOVERED_NODES = null;
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    @Qualifier(value="transactionAware")
    private EventForwarder m_eventForwarder;
    @Autowired
    @Qualifier(value="fused")
    private ForeignSourceRepository m_foreignSourceRepository;
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    @Autowired
    private PluginRegistry m_pluginRegistry;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private final ThreadLocal<HashMap<String, OnmsServiceType>> m_typeCache = new ThreadLocal();
    private final ThreadLocal<HashMap<String, OnmsCategory>> m_categoryCache = new ThreadLocal();

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        RequisitionFileUtils.deleteAllSnapshots((ForeignSourceRepository)this.m_pendingForeignSourceRepository);
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return System.getProperty("org.opennms.provisiond.enableDiscovery", "false").equalsIgnoreCase("true");
    }

    @Override
    public boolean isRequisitionedEntityDeletionEnabled() {
        return System.getProperty("org.opennms.provisiond.enableDeletionOfRequisitionedEntities", "false").equalsIgnoreCase("true");
    }

    @Override
    @Transactional
    public void insertNode(OnmsNode node) {
        node.setDistPoller(this.createDistPollerIfNecessary("localhost", "127.0.0.1"));
        this.m_nodeDao.save((Object)node);
        this.m_nodeDao.flush();
        AddEventVisitor eventAccumlator = new AddEventVisitor(this.m_eventForwarder);
        node.visit((EntityVisitor)eventAccumlator);
    }

    @Override
    @Transactional
    public void updateNode(OnmsNode node) {
        OnmsNode dbNode = this.m_nodeDao.getHierarchy(node.getId());
        dbNode.mergeNode(node, this.m_eventForwarder, false);
        this.m_nodeDao.update((Object)dbNode);
        this.m_nodeDao.flush();
        UpdateEventVisitor eventAccumlator = new UpdateEventVisitor(this.m_eventForwarder);
        node.visit((EntityVisitor)eventAccumlator);
    }

    @Override
    @Transactional
    public void deleteNode(Integer nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        if (node != null && this.shouldDelete(node)) {
            this.m_nodeDao.delete((Object)node);
            node.visit((EntityVisitor)new DeleteEventVisitor(this.m_eventForwarder));
        }
    }

    private boolean shouldDelete(OnmsNode node) {
        String foreignSource = node.getForeignSource();
        if (foreignSource == null) {
            return this.isDiscoveryEnabled();
        }
        if (this.isRequisitionedEntityDeletionEnabled()) {
            return true;
        }
        return !this.isRequisitioned(node);
    }

    @Override
    @Transactional
    public void deleteInterface(Integer nodeId, String ipAddr) {
        OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddr);
        if (iface != null && this.shouldDelete(iface)) {
            this.m_ipInterfaceDao.delete((Object)iface);
            iface.visit((EntityVisitor)new DeleteEventVisitor(this.m_eventForwarder));
        }
    }

    private boolean shouldDelete(OnmsIpInterface iface) {
        String foreignSource = iface.getNode().getForeignSource();
        if (foreignSource == null) {
            return this.isDiscoveryEnabled();
        }
        if (this.isRequisitionedEntityDeletionEnabled()) {
            return true;
        }
        return !this.isRequisitioned(iface);
    }

    @Override
    @Transactional
    public void deleteService(Integer nodeId, InetAddress addr, String service) {
        OnmsMonitoredService monSvc = this.m_monitoredServiceDao.get(nodeId, addr, service);
        if (monSvc != null && this.shouldDelete(monSvc)) {
            this.m_monitoredServiceDao.delete((Object)monSvc);
            monSvc.visit((EntityVisitor)new DeleteEventVisitor(this.m_eventForwarder));
        }
    }

    private boolean shouldDelete(OnmsMonitoredService monSvc) {
        String foreignSource = monSvc.getIpInterface().getNode().getForeignSource();
        if (foreignSource == null) {
            return this.isDiscoveryEnabled();
        }
        if (this.isRequisitionedEntityDeletionEnabled()) {
            return true;
        }
        return !this.isRequisitioned(monSvc);
    }

    public boolean isRequisitioned(OnmsNode node) {
        String foreignSource = node.getForeignSource();
        String foreignId = node.getForeignId();
        if (foreignSource == null) {
            return false;
        }
        OnmsNode reqNode = this.getRequisitionedNode(foreignSource, foreignId);
        if (reqNode == null) {
            LogUtils.errorf((Object)"No requistion exists for node with foreignSource %s and foreignId %s.  Treating node as unrequistioned", (String)foreignSource, (Object[])new Object[]{foreignId});
            return false;
        }
        return true;
    }

    public boolean isRequisitioned(OnmsIpInterface ip) {
        String foreignSource = ip.getNode().getForeignSource();
        String foreignId = ip.getNode().getForeignId();
        if (foreignSource == null) {
            return false;
        }
        OnmsNode reqNode = this.getRequisitionedNode(foreignSource, foreignId);
        if (reqNode == null) {
            LogUtils.errorf((Object)"No requistion exists for node with foreignSource %s and foreignId %s.  Treating node as unrequistioned", (String)foreignSource, (Object[])new Object[]{foreignId});
            return false;
        }
        OnmsIpInterface reqIp = reqNode.getIpInterfaceByIpAddress(ip.getIpAddress());
        return reqIp != null;
    }

    public boolean isRequisitioned(OnmsMonitoredService monSvc) {
        String foreignSource = monSvc.getIpInterface().getNode().getForeignSource();
        String foreignId = monSvc.getIpInterface().getNode().getForeignId();
        if (foreignSource == null) {
            return false;
        }
        OnmsNode reqNode = this.getRequisitionedNode(foreignSource, foreignId);
        if (reqNode == null) {
            LogUtils.errorf((Object)"No requistion exists for node with foreignSource %s and foreignId %s.  Treating node as unrequistioned", (String)foreignSource, (Object[])new Object[]{foreignId});
            return false;
        }
        OnmsIpInterface reqIp = reqNode.getIpInterfaceByIpAddress(monSvc.getIpAddress());
        if (reqIp == null) {
            return false;
        }
        OnmsMonitoredService reqSvc = reqIp.getMonitoredServiceByServiceType(monSvc.getServiceName());
        return reqSvc != null;
    }

    private void assertNotNull(Object o, String format, Object ... args) {
        if (o == null) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    @Override
    @Transactional
    public OnmsIpInterface updateIpInterfaceAttributes(final Integer nodeId, final OnmsIpInterface scannedIface) {
        OnmsSnmpInterface snmpInterface = scannedIface.getSnmpInterface();
        if (snmpInterface != null && snmpInterface.getIfIndex() != null) {
            scannedIface.setSnmpInterface(this.updateSnmpInterfaceAttributes(nodeId, snmpInterface));
        }
        return (OnmsIpInterface)new UpsertTemplate<OnmsIpInterface, IpInterfaceDao>(this.m_transactionManager, this.m_ipInterfaceDao){

            protected OnmsIpInterface query() {
                OnmsIpInterface dbIface = DefaultProvisionService.this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, InetAddressUtils.str((InetAddress)scannedIface.getIpAddress()));
                LogUtils.debugf((Object)((Object)this), (String)"Updating interface attributes for DB interface %s for node %d with ip %s", (Object[])new Object[]{dbIface, nodeId, InetAddressUtils.str((InetAddress)scannedIface.getIpAddress())});
                return dbIface;
            }

            protected OnmsIpInterface doUpdate(OnmsIpInterface dbIface) {
                if (dbIface.isManaged() && !scannedIface.isManaged()) {
                    Set monSvcs = dbIface.getMonitoredServices();
                    for (OnmsMonitoredService monSvc : monSvcs) {
                        monSvc.visit((EntityVisitor)new DeleteEventVisitor(DefaultProvisionService.this.m_eventForwarder));
                    }
                    monSvcs.clear();
                }
                dbIface.mergeInterfaceAttributes(scannedIface);
                LogUtils.infof((Object)((Object)this), (String)"Updating IpInterface %s", (Object[])new Object[]{dbIface});
                DefaultProvisionService.this.m_ipInterfaceDao.update((Object)dbIface);
                DefaultProvisionService.this.m_ipInterfaceDao.flush();
                return dbIface;
            }

            protected OnmsIpInterface doInsert() {
                OnmsNode dbNode = (OnmsNode)DefaultProvisionService.this.m_nodeDao.load((Serializable)nodeId);
                DefaultProvisionService.this.assertNotNull(dbNode, "no node found with nodeId %d", new Object[]{nodeId});
                scannedIface.setNode(dbNode);
                DefaultProvisionService.this.saveOrUpdate(scannedIface);
                AddEventVisitor visitor = new AddEventVisitor(DefaultProvisionService.this.m_eventForwarder);
                scannedIface.visit((EntityVisitor)visitor);
                DefaultProvisionService.this.m_ipInterfaceDao.flush();
                return scannedIface;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsSnmpInterface updateSnmpInterfaceAttributes(final Integer nodeId, final OnmsSnmpInterface snmpInterface) {
        return (OnmsSnmpInterface)new UpsertTemplate<OnmsSnmpInterface, SnmpInterfaceDao>(this.m_transactionManager, this.m_snmpInterfaceDao){

            public OnmsSnmpInterface query() {
                OnmsSnmpInterface dbSnmpIface = DefaultProvisionService.this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(nodeId, snmpInterface.getIfIndex());
                LogUtils.debugf((Object)((Object)this), (String)"nodeId = %d, ifIndex = %d, dbSnmpIface = %s", (Object[])new Object[]{nodeId, snmpInterface.getIfIndex(), dbSnmpIface});
                return dbSnmpIface;
            }

            public OnmsSnmpInterface doUpdate(OnmsSnmpInterface dbSnmpIface) {
                dbSnmpIface.mergeSnmpInterfaceAttributes(snmpInterface);
                LogUtils.infof((Object)((Object)this), (String)"Updating SnmpInterface %s", (Object[])new Object[]{dbSnmpIface});
                DefaultProvisionService.this.m_snmpInterfaceDao.update((Object)dbSnmpIface);
                DefaultProvisionService.this.m_snmpInterfaceDao.flush();
                return dbSnmpIface;
            }

            public OnmsSnmpInterface doInsert() {
                OnmsNode dbNode = (OnmsNode)DefaultProvisionService.this.m_nodeDao.load((Serializable)nodeId);
                DefaultProvisionService.this.assertNotNull(dbNode, "no node found with nodeId %d", new Object[]{nodeId});
                snmpInterface.setNode(dbNode);
                LogUtils.infof((Object)((Object)this), (String)"Saving SnmpInterface %s", (Object[])new Object[]{snmpInterface});
                DefaultProvisionService.this.m_snmpInterfaceDao.save((Object)snmpInterface);
                DefaultProvisionService.this.m_snmpInterfaceDao.flush();
                return snmpInterface;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsMonitoredService addMonitoredService(Integer ipInterfaceId, String svcName) {
        OnmsIpInterface iface = (OnmsIpInterface)this.m_ipInterfaceDao.get((Serializable)ipInterfaceId);
        this.assertNotNull(iface, "could not find interface with id %d", ipInterfaceId);
        return this.addMonitoredService(iface, svcName);
    }

    private OnmsMonitoredService addMonitoredService(final OnmsIpInterface iface, final String svcName) {
        final OnmsServiceType svcType = this.createServiceTypeIfNecessary(svcName);
        return (OnmsMonitoredService)new CreateIfNecessaryTemplate<OnmsMonitoredService, MonitoredServiceDao>(this.m_transactionManager, this.m_monitoredServiceDao){

            protected OnmsMonitoredService query() {
                return iface.getMonitoredServiceByServiceType(svcName);
            }

            protected OnmsMonitoredService doInsert() {
                OnmsMonitoredService svc = new OnmsMonitoredService(iface, svcType);
                svc.setStatus("A");
                DefaultProvisionService.this.m_ipInterfaceDao.saveOrUpdate((Object)iface);
                DefaultProvisionService.this.m_ipInterfaceDao.flush();
                AddEventVisitor visitor = new AddEventVisitor(DefaultProvisionService.this.m_eventForwarder);
                svc.visit((EntityVisitor)visitor);
                return svc;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsMonitoredService addMonitoredService(Integer nodeId, String ipAddress, String svcName) {
        OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
        this.assertNotNull(iface, "could not find interface with nodeid %d and ipAddr %s", nodeId, ipAddress);
        return this.addMonitoredService(iface, svcName);
    }

    @Override
    @Transactional
    public OnmsMonitoredService updateMonitoredServiceState(Integer nodeId, String ipAddress, final String svcName) {
        final OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
        this.assertNotNull(iface, "could not find interface with nodeid %d and ipAddr %s", nodeId, ipAddress);
        return (OnmsMonitoredService)new UpsertTemplate<OnmsMonitoredService, MonitoredServiceDao>(this.m_transactionManager, this.m_monitoredServiceDao){

            protected OnmsMonitoredService query() {
                return iface.getMonitoredServiceByServiceType(svcName);
            }

            protected OnmsMonitoredService doUpdate(OnmsMonitoredService dbObj) {
                LogUtils.debugf((Object)((Object)this), (String)"current status of service %s on node with IP %s is %s ", (Object[])new Object[]{dbObj.getServiceName(), dbObj.getIpAddress().getHostAddress(), dbObj.getStatus()});
                if ("S".equals(dbObj.getStatus())) {
                    LogUtils.debugf((Object)((Object)this), (String)"suspending polling for service %s on node with IP %s", (Object[])new Object[]{dbObj.getServiceName(), dbObj.getIpAddress().getHostAddress()});
                    dbObj.setStatus("F");
                    DefaultProvisionService.this.m_monitoredServiceDao.update((Object)dbObj);
                    this.sendEvent("uei.opennms.org/internal/poller/suspendPollingService", dbObj);
                }
                if ("R".equals(dbObj.getStatus())) {
                    LogUtils.debugf((Object)((Object)this), (String)"resume polling for service %s on node with IP %s", (Object[])new Object[]{dbObj.getServiceName(), dbObj.getIpAddress().getHostAddress()});
                    dbObj.setStatus("A");
                    DefaultProvisionService.this.m_monitoredServiceDao.update((Object)dbObj);
                    this.sendEvent("uei.opennms.org/internal/poller/resumePollingService", dbObj);
                }
                return dbObj;
            }

            protected OnmsMonitoredService doInsert() {
                return null;
            }

            private void sendEvent(String eventUEI, OnmsMonitoredService dbObj) {
                EventBuilder bldr = new EventBuilder(eventUEI, "ProvisionService");
                bldr.setNodeid((long)dbObj.getNodeId().intValue());
                bldr.setInterface(dbObj.getIpAddress());
                bldr.setService(dbObj.getServiceName());
                DefaultProvisionService.this.m_eventForwarder.sendNow(bldr.getEvent());
            }
        }.execute();
    }

    @Override
    @Transactional
    public void clearCache() {
        this.m_nodeDao.clear();
        this.m_nodeDao.flush();
    }

    @Override
    public OnmsDistPoller createDistPollerIfNecessary(String dpName, String dpAddr) {
        return this.createDistPollerIfNecessary(new OnmsDistPoller(dpName, dpAddr));
    }

    public OnmsDistPoller createDistPollerIfNecessary(OnmsDistPoller scannedDistPoller) {
        final OnmsDistPoller distPoller = scannedDistPoller == null ? new OnmsDistPoller("localhost", "127.0.0.1") : scannedDistPoller;
        return (OnmsDistPoller)new CreateIfNecessaryTemplate<OnmsDistPoller, DistPollerDao>(this.m_transactionManager, this.m_distPollerDao){

            protected OnmsDistPoller query() {
                return (OnmsDistPoller)DefaultProvisionService.this.m_distPollerDao.get((Serializable)((Object)distPoller.getName()));
            }

            public OnmsDistPoller doInsert() {
                DefaultProvisionService.this.m_distPollerDao.save((Object)distPoller);
                DefaultProvisionService.this.m_distPollerDao.flush();
                return distPoller;
            }
        }.execute();
    }

    @Override
    @Transactional
    public OnmsNode getRequisitionedNode(String foreignSource, String foreignId) throws ForeignSourceRepositoryException {
        OnmsNodeRequisition nodeReq = this.m_foreignSourceRepository.getNodeRequisition(foreignSource, foreignId);
        if (nodeReq == null) {
            LogUtils.warnf((Object)this, (String)"nodeReq for node %s:%s cannot be null!", (Object[])new Object[]{foreignSource, foreignId});
            return null;
        }
        OnmsNode node = nodeReq.constructOnmsNodeFromRequisition();
        HashSet<OnmsCategory> dbCategories = new HashSet<OnmsCategory>();
        for (OnmsCategory category : node.getCategories()) {
            dbCategories.add(this.createCategoryIfNecessary(category.getName()));
        }
        node.setCategories(dbCategories);
        node.visit((EntityVisitor)new ServiceTypeFulfiller());
        return node;
    }

    @Override
    @Transactional
    public OnmsServiceType createServiceTypeIfNecessary(String serviceName) {
        this.preloadExistingTypes();
        OnmsServiceType type = this.m_typeCache.get().get(serviceName);
        if (type == null) {
            type = this.loadServiceType(serviceName);
            this.m_typeCache.get().put(serviceName, type);
        }
        return type;
    }

    @Override
    @Transactional
    public OnmsCategory createCategoryIfNecessary(String name) {
        this.preloadExistingCategories();
        OnmsCategory category = this.m_categoryCache.get().get(name);
        if (category == null) {
            category = this.loadCategory(name);
            this.m_categoryCache.get().put(category.getName(), category);
        }
        return category;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Integer> getForeignIdToNodeIdMap(String foreignSource) {
        return this.m_nodeDao.getForeignIdToNodeIdMap(foreignSource);
    }

    @Override
    @Transactional
    public void setNodeParentAndDependencies(String foreignSource, String foreignId, String parentForeignSource, String parentForeignId, String parentNodeLabel) {
        OnmsNode node = this.findNodebyForeignId(foreignSource, foreignId);
        if (node == null) {
            return;
        }
        OnmsNode parent = this.findParent(parentForeignSource, parentForeignId, parentNodeLabel);
        this.setParent(node, parent);
        this.setPathDependency(node, parent);
        this.m_nodeDao.update((Object)node);
        this.m_nodeDao.flush();
    }

    private void preloadExistingTypes() {
        if (this.m_typeCache.get() == null) {
            this.m_typeCache.set(this.loadServiceTypeMap());
        }
    }

    @Transactional(readOnly=true)
    private HashMap<String, OnmsServiceType> loadServiceTypeMap() {
        HashMap<String, OnmsServiceType> serviceTypeMap = new HashMap<String, OnmsServiceType>();
        for (OnmsServiceType svcType : this.m_serviceTypeDao.findAll()) {
            serviceTypeMap.put(svcType.getName(), svcType);
        }
        return serviceTypeMap;
    }

    @Transactional
    private OnmsServiceType loadServiceType(final String serviceName) {
        return (OnmsServiceType)new CreateIfNecessaryTemplate<OnmsServiceType, ServiceTypeDao>(this.m_transactionManager, this.m_serviceTypeDao){

            protected OnmsServiceType query() {
                return DefaultProvisionService.this.m_serviceTypeDao.findByName(serviceName);
            }

            public OnmsServiceType doInsert() {
                OnmsServiceType type = new OnmsServiceType(serviceName);
                DefaultProvisionService.this.m_serviceTypeDao.save((Object)type);
                DefaultProvisionService.this.m_serviceTypeDao.flush();
                return type;
            }
        }.execute();
    }

    private void preloadExistingCategories() {
        if (this.m_categoryCache.get() == null) {
            this.m_categoryCache.set(this.loadCategoryMap());
        }
    }

    @Transactional(readOnly=true)
    private HashMap<String, OnmsCategory> loadCategoryMap() {
        HashMap<String, OnmsCategory> categoryMap = new HashMap<String, OnmsCategory>();
        for (OnmsCategory category : this.m_categoryDao.findAll()) {
            categoryMap.put(category.getName(), category);
        }
        return categoryMap;
    }

    @Transactional
    private OnmsCategory loadCategory(final String name) {
        return (OnmsCategory)new CreateIfNecessaryTemplate<OnmsCategory, CategoryDao>(this.m_transactionManager, this.m_categoryDao){

            protected OnmsCategory query() {
                return DefaultProvisionService.this.m_categoryDao.findByName(name);
            }

            public OnmsCategory doInsert() {
                OnmsCategory category = new OnmsCategory(name);
                DefaultProvisionService.this.m_categoryDao.save((Object)category);
                DefaultProvisionService.this.m_categoryDao.flush();
                return category;
            }
        }.execute();
    }

    @Transactional(readOnly=true)
    private OnmsNode findNodebyNodeLabel(String label) {
        List nodes = this.m_nodeDao.findByLabel(label);
        if (nodes.size() == 1) {
            return (OnmsNode)nodes.iterator().next();
        }
        LogUtils.errorf((Object)this, (String)"Unable to locate a unique node using label %s: %d nodes found.  Ignoring relationship.", (Object[])new Object[]{label, nodes.size()});
        return null;
    }

    @Transactional(readOnly=true)
    private OnmsNode findNodebyForeignId(String foreignSource, String foreignId) {
        return this.m_nodeDao.findByForeignId(foreignSource, foreignId);
    }

    @Transactional(readOnly=true)
    private OnmsNode findParent(String foreignSource, String parentForeignId, String parentNodeLabel) {
        if (parentForeignId != null) {
            return this.findNodebyForeignId(foreignSource, parentForeignId);
        }
        if (parentNodeLabel != null) {
            return this.findNodebyNodeLabel(parentNodeLabel);
        }
        return null;
    }

    private void setPathDependency(OnmsNode node, OnmsNode parent) {
        if (node == null) {
            return;
        }
        OnmsIpInterface critIface = null;
        if (parent != null) {
            critIface = parent.getCriticalInterface();
        }
        LogUtils.infof((Object)this, (String)"Setting criticalInterface of node: %s to: %s", (Object[])new Object[]{node, critIface});
        node.setPathElement(critIface == null ? null : new PathElement(InetAddressUtils.str((InetAddress)critIface.getIpAddress()), "ICMP"));
    }

    @Transactional
    private void setParent(OnmsNode node, OnmsNode parent) {
        if (node == null) {
            return;
        }
        LogUtils.infof((Object)this, (String)"Setting parent of node: %s to: %s", (Object[])new Object[]{node, parent});
        node.setParent(parent);
        this.m_nodeDao.update((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional(readOnly=true)
    public NodeScanSchedule getScheduleForNode(int nodeId, boolean force) {
        return this.createScheduleForNode((OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId)), force);
    }

    @Override
    @Transactional(readOnly=true)
    public List<NodeScanSchedule> getScheduleForNodes() {
        Assert.notNull((Object)this.m_nodeDao, (String)"Node DAO is null and is not supposed to be");
        List nodes = this.isDiscoveryEnabled() ? this.m_nodeDao.findAll() : this.m_nodeDao.findAllProvisionedNodes();
        ArrayList<NodeScanSchedule> scheduledNodes = new ArrayList<NodeScanSchedule>();
        for (OnmsNode node : nodes) {
            NodeScanSchedule nodeScanSchedule = this.createScheduleForNode(node, false);
            if (nodeScanSchedule == null) continue;
            scheduledNodes.add(nodeScanSchedule);
        }
        return scheduledNodes;
    }

    private NodeScanSchedule createScheduleForNode(OnmsNode node, boolean force) {
        Assert.notNull((Object)node, (String)"Node may not be null");
        String actualForeignSource = node.getForeignSource();
        if (actualForeignSource == null && !this.isDiscoveryEnabled()) {
            LogUtils.infof((Object)this, (String)"Not scheduling node %s to be scanned since it has a null foreignSource and handling of discovered nodes is disabled in provisiond", (Object[])new Object[]{node});
            return null;
        }
        String effectiveForeignSource = actualForeignSource == null ? "default" : actualForeignSource;
        try {
            DateTime now;
            DateTime nextPoll;
            ForeignSource fs = this.m_foreignSourceRepository.getForeignSource(effectiveForeignSource);
            Duration scanInterval = fs.getScanInterval();
            Duration initialDelay = Duration.ZERO;
            if (node.getLastCapsdPoll() != null && !force && (nextPoll = new DateTime(node.getLastCapsdPoll().getTime()).plus((ReadableDuration)scanInterval)).isAfter((ReadableInstant)(now = new DateTime()))) {
                initialDelay = new Duration((ReadableInstant)now, (ReadableInstant)nextPoll);
            }
            return new NodeScanSchedule(node.getId(), actualForeignSource, node.getForeignId(), initialDelay, scanInterval);
        }
        catch (ForeignSourceRepositoryException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to get foreign source '%s' from repository", (Object[])new Object[]{effectiveForeignSource});
            return null;
        }
    }

    @Override
    public void setForeignSourceRepository(ForeignSourceRepository foreignSourceRepository) {
        this.m_foreignSourceRepository = foreignSourceRepository;
    }

    public ForeignSourceRepository getForeignSourceRepository() {
        return this.m_foreignSourceRepository;
    }

    @Override
    public Requisition loadRequisition(Resource resource) {
        Requisition r = this.m_foreignSourceRepository.importResourceRequisition(resource);
        r.updateLastImported();
        this.m_foreignSourceRepository.save(r);
        return r;
    }

    @Override
    @Transactional
    public OnmsNode updateNodeAttributes(final OnmsNode node) {
        return (OnmsNode)new UpsertTemplate<OnmsNode, NodeDao>(this.m_transactionManager, this.m_nodeDao){

            protected OnmsNode query() {
                return DefaultProvisionService.this.getDbNode(node);
            }

            protected OnmsNode doUpdate(OnmsNode dbNode) {
                dbNode.mergeNodeAttributes(node, DefaultProvisionService.this.m_eventForwarder);
                return DefaultProvisionService.this.saveOrUpdate(dbNode);
            }

            protected OnmsNode doInsert() {
                node.setDistPoller(DefaultProvisionService.this.createDistPollerIfNecessary(node.getDistPoller()));
                return DefaultProvisionService.this.saveOrUpdate(node);
            }
        }.execute();
    }

    @Transactional(readOnly=true)
    private OnmsNode getDbNode(OnmsNode node) {
        OnmsNode dbNode = node.getId() != null ? (OnmsNode)this.m_nodeDao.get((Serializable)node.getId()) : this.m_nodeDao.findByForeignId(node.getForeignSource(), node.getForeignId());
        return dbNode;
    }

    @Transactional
    private OnmsNode saveOrUpdate(OnmsNode node) {
        HashSet<OnmsCategory> updatedCategories = new HashSet<OnmsCategory>();
        Iterator it = node.getCategories().iterator();
        while (it.hasNext()) {
            OnmsCategory category = (OnmsCategory)it.next();
            if (category.getId() != null) continue;
            it.remove();
            updatedCategories.add(this.createCategoryIfNecessary(category.getName()));
        }
        node.getCategories().addAll(updatedCategories);
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
        return node;
    }

    @Transactional
    private OnmsIpInterface saveOrUpdate(OnmsIpInterface iface) {
        iface.visit((EntityVisitor)new ServiceTypeFulfiller());
        LogUtils.infof((Object)this, (String)"SaveOrUpdating IpInterface %s", (Object[])new Object[]{iface});
        this.m_ipInterfaceDao.saveOrUpdate((Object)iface);
        this.m_ipInterfaceDao.flush();
        return iface;
    }

    @Override
    public List<ServiceDetector> getDetectorsForForeignSource(String foreignSourceName) {
        ForeignSource foreignSource = this.m_foreignSourceRepository.getForeignSource(foreignSourceName);
        this.assertNotNull(foreignSource, "Expected a foreignSource with name %s", foreignSourceName);
        List detectorConfigs = foreignSource.getDetectors();
        if (detectorConfigs == null) {
            return new ArrayList<ServiceDetector>(this.m_pluginRegistry.getAllPlugins(ServiceDetector.class));
        }
        ArrayList<ServiceDetector> detectors = new ArrayList<ServiceDetector>(detectorConfigs.size());
        for (PluginConfig detectorConfig : detectorConfigs) {
            ServiceDetector detector = this.m_pluginRegistry.getPluginInstance(ServiceDetector.class, detectorConfig);
            if (detector == null) {
                LogUtils.errorf((Object)this, (String)"Configured plugin does not exist: %s", (Object[])new Object[]{detectorConfig});
                continue;
            }
            detector.setServiceName(detectorConfig.getName());
            detector.init();
            detectors.add(detector);
        }
        return detectors;
    }

    @Override
    public List<NodePolicy> getNodePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(NodePolicy.class, foreignSourceName);
    }

    @Override
    public List<IpInterfacePolicy> getIpInterfacePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(IpInterfacePolicy.class, foreignSourceName);
    }

    @Override
    public List<SnmpInterfacePolicy> getSnmpInterfacePoliciesForForeignSource(String foreignSourceName) {
        return this.getPluginsForForeignSource(SnmpInterfacePolicy.class, foreignSourceName);
    }

    public <T> List<T> getPluginsForForeignSource(Class<T> pluginClass, String foreignSourceName) {
        ForeignSource foreignSource = this.m_foreignSourceRepository.getForeignSource(foreignSourceName);
        this.assertNotNull(foreignSource, "Expected a foreignSource with name %s", foreignSourceName);
        List configs = foreignSource.getPolicies();
        if (configs == null) {
            return Collections.emptyList();
        }
        ArrayList<T> plugins = new ArrayList<T>(configs.size());
        for (PluginConfig config : configs) {
            T plugin = this.m_pluginRegistry.getPluginInstance(pluginClass, config);
            if (plugin == null) {
                LogUtils.debugf((Object)this, (String)"Configured plugin is not appropropriate for policy class %s: %s", (Object[])new Object[]{pluginClass, config});
                continue;
            }
            plugins.add(plugin);
        }
        return plugins;
    }

    @Override
    @Transactional
    public void deleteObsoleteInterfaces(Integer nodeId, Date scanStamp) {
        List obsoleteInterfaces = this.m_nodeDao.findObsoleteIpInterfaces(nodeId, scanStamp);
        for (OnmsIpInterface iface : obsoleteInterfaces) {
            iface.visit((EntityVisitor)new DeleteEventVisitor(this.m_eventForwarder));
        }
        this.m_nodeDao.deleteObsoleteInterfaces(nodeId, scanStamp);
    }

    @Override
    @Transactional
    public void updateNodeScanStamp(Integer nodeId, Date scanStamp) {
        this.m_nodeDao.updateNodeScanStamp(nodeId, scanStamp);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional
    public OnmsIpInterface setIsPrimaryFlag(Integer nodeId, String ipAddress) {
        if (nodeId == null) {
            LogUtils.debugf((Object)this, (String)"nodeId is null!", (Object[])new Object[0]);
            return null;
        }
        if (ipAddress == null) {
            LogUtils.debugf((Object)this, (String)"ipAddress is null!", (Object[])new Object[0]);
            return null;
        }
        OnmsIpInterface svcIface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeId, ipAddress);
        if (svcIface == null) {
            LogUtils.infof((Object)this, (String)"unable to find IPInterface for nodeId=%s, ipAddress=%s", (Object[])new Object[]{nodeId, ipAddress});
            return null;
        }
        OnmsIpInterface primaryIface = null;
        if (svcIface.isPrimary()) {
            primaryIface = svcIface;
        } else if (svcIface.getNode().getPrimaryInterface() == null) {
            svcIface.setIsSnmpPrimary(PrimaryType.PRIMARY);
            this.m_ipInterfaceDao.saveOrUpdate((Object)svcIface);
            this.m_ipInterfaceDao.flush();
            primaryIface = svcIface;
        } else {
            svcIface.setIsSnmpPrimary(PrimaryType.SECONDARY);
            this.m_ipInterfaceDao.saveOrUpdate((Object)svcIface);
            this.m_ipInterfaceDao.flush();
        }
        this.m_ipInterfaceDao.initialize((Object)primaryIface);
        return primaryIface;
    }

    @Override
    @Transactional
    public OnmsIpInterface getPrimaryInterfaceForNode(OnmsNode node) {
        OnmsNode dbNode = this.getDbNode(node);
        if (dbNode == null) {
            return null;
        }
        OnmsIpInterface primaryIface = dbNode.getPrimaryInterface();
        if (primaryIface != null) {
            this.m_ipInterfaceDao.initialize((Object)primaryIface);
            this.m_ipInterfaceDao.initialize((Object)primaryIface.getMonitoredServices());
        }
        return primaryIface;
    }

    @Override
    @Transactional
    public OnmsNode createUndiscoveredNode(final String ipAddress) {
        OnmsNode node = (OnmsNode)new UpsertTemplate<OnmsNode, NodeDao>(this.m_transactionManager, this.m_nodeDao){

            protected OnmsNode query() {
                List nodes = DefaultProvisionService.this.m_nodeDao.findByForeignSourceAndIpAddress(FOREIGN_SOURCE_FOR_DISCOVERED_NODES, ipAddress);
                return nodes.size() > 0 ? (OnmsNode)nodes.get(0) : null;
            }

            protected OnmsNode doUpdate(OnmsNode existingNode) {
                return null;
            }

            protected OnmsNode doInsert() {
                Date now = new Date();
                String hostname = DefaultProvisionService.this.getHostnameForIp(ipAddress);
                OnmsNode node = new OnmsNode(DefaultProvisionService.this.createDistPollerIfNecessary("localhost", "127.0.0.1"));
                node.setLabel(hostname == null ? ipAddress : hostname);
                node.setLabelSource(hostname == null ? "A" : "H");
                node.setForeignSource(FOREIGN_SOURCE_FOR_DISCOVERED_NODES);
                node.setType("A");
                node.setLastCapsdPoll(now);
                OnmsIpInterface iface = new OnmsIpInterface(InetAddressUtils.addr((String)ipAddress), node);
                iface.setIsManaged("M");
                iface.setIpHostName(hostname);
                iface.setIsSnmpPrimary(PrimaryType.NOT_ELIGIBLE);
                iface.setIpLastCapsdPoll(now);
                DefaultProvisionService.this.m_nodeDao.save((Object)node);
                DefaultProvisionService.this.m_nodeDao.flush();
                return node;
            }
        }.execute();
        if (node != null) {
            node.visit((EntityVisitor)new AddEventVisitor(this.m_eventForwarder));
        }
        return node;
    }

    private String getHostnameForIp(String address) {
        return InetAddressUtils.addr((String)address).getCanonicalHostName();
    }

    @Override
    @Transactional
    public OnmsNode getNode(Integer nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        this.m_nodeDao.initialize((Object)node);
        this.m_nodeDao.initialize((Object)node.getCategories());
        this.m_nodeDao.initialize((Object)node.getIpInterfaces());
        return node;
    }

    @Override
    @Transactional
    public OnmsNode getDbNodeInitCat(Integer nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeId);
        this.m_nodeDao.initialize((Object)node.getCategories());
        this.m_nodeDao.initialize((Object)node.getDistPoller());
        return node;
    }

    private final class ServiceTypeFulfiller
    extends AbstractEntityVisitor {
        private ServiceTypeFulfiller() {
        }

        public void visitMonitoredService(OnmsMonitoredService monSvc) {
            OnmsServiceType dbType = monSvc.getServiceType();
            if (dbType.getId() == null) {
                dbType = DefaultProvisionService.this.createServiceTypeIfNecessary(dbType.getName());
            }
            monSvc.setServiceType(dbType);
        }
    }
}

