/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectFutureListener;
import org.opennms.netmgt.provision.service.IpInterfaceScan;

class AsyncDetectorRunner
implements Async<Boolean> {
    private final IpInterfaceScan m_ifaceScan;
    private final AsyncServiceDetector m_detector;

    public AsyncDetectorRunner(IpInterfaceScan ifaceScan, AsyncServiceDetector detector) {
        this.m_ifaceScan = ifaceScan;
        this.m_detector = detector;
    }

    public void submit(Callback<Boolean> cb) {
        try {
            LogUtils.infof((Object)this, (String)"Attemping to detect service %s on address %s", (Object[])new Object[]{this.m_detector.getServiceName(), this.getHostAddress()});
            DetectFuture future = this.m_detector.isServiceDetected(this.m_ifaceScan.getAddress());
            future.addListener(this.listener(cb));
        }
        catch (Throwable e) {
            cb.handleException(e);
        }
    }

    private String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.m_ifaceScan.getAddress());
    }

    public String toString() {
        return String.format("Run detector %s on address %s", this.m_detector.getServiceName(), this.getHostAddress());
    }

    private DetectFutureListener<DetectFuture> listener(final Callback<Boolean> cb) {
        return new DetectFutureListener<DetectFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(DetectFuture future) {
                try {
                    if (future.getException() != null) {
                        cb.handleException(future.getException());
                    } else {
                        cb.complete((Object)future.isServiceDetected());
                    }
                }
                finally {
                    AsyncDetectorRunner.this.m_detector.dispose();
                }
            }
        };
    }
}

