/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.operations.ScanResource;
import org.opennms.netmgt.provision.service.snmp.NamedSnmpVar;
import org.opennms.netmgt.provision.service.snmp.SnmpStore;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpResult;

public final class SystemGroup
extends AggregateTracker {
    public static final String SYS_OBJECTID_ALIAS = "sysObjectID";
    private static final String SYS_OBJECTID = ".1.3.6.1.2.1.1.2";
    public static final String SYS_UPTIME_ALIAS = "sysUptime";
    private static final String SYS_UPTIME = ".1.3.6.1.2.1.1.3";
    public static final String SYS_NAME_ALIAS = "sysName";
    private static final String SYS_NAME = ".1.3.6.1.2.1.1.5";
    public static final String SYS_DESCR_ALIAS = "sysDescr";
    private static final String SYS_DESCR = ".1.3.6.1.2.1.1.1";
    public static final String SYS_LOCATION_ALIAS = "sysLocation";
    private static final String SYS_LOCATION = ".1.3.6.1.2.1.1.6";
    public static final String SYS_CONTACT_ALIAS = "sysContact";
    private static final String SYS_CONTACT = ".1.3.6.1.2.1.1.4";
    public static NamedSnmpVar[] ms_elemList = null;
    public static final String SYSTEM_OID = ".1.3.6.1.2.1.1";
    private final SnmpStore m_store;
    private final InetAddress m_address;

    public SystemGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    public String getSysName() {
        return this.m_store.getDisplayString(SYS_NAME);
    }

    public String getSysObjectID() {
        return this.m_store.getObjectID(SYS_OBJECTID);
    }

    public String getSysDescr() {
        return this.m_store.getDisplayString(SYS_DESCR);
    }

    public String getSysLocation() {
        return this.m_store.getDisplayString(SYS_LOCATION);
    }

    public String getSysContact() {
        return this.m_store.getDisplayString(SYS_CONTACT);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        this.log().warn("Error retrieving systemGroup from " + this.m_address + ". " + msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info("Error retrieving systemGroup from " + this.m_address + ". " + msg);
    }

    private final ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public void updateSnmpDataForResource(ScanResource sr) {
        if (!this.failed()) {
            sr.setAttribute(SYS_NAME_ALIAS, this.getSysName());
            sr.setAttribute(SYS_CONTACT_ALIAS, this.getSysContact());
            sr.setAttribute("sysDescription", this.getSysDescr());
            sr.setAttribute(SYS_LOCATION_ALIAS, this.getSysLocation());
            sr.setAttribute("sysObjectId", this.getSysObjectID());
        }
    }

    public void updateSnmpDataForNode(OnmsNode node) {
        ScanResource sr = new ScanResource("SNMP");
        sr.setNode(node);
        this.updateSnmpDataForResource(sr);
    }

    static {
        ms_elemList = new NamedSnmpVar[6];
        int ndx = 0;
        SystemGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", SYS_DESCR_ALIAS, SYS_DESCR);
        SystemGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpObjectId", SYS_OBJECTID_ALIAS, SYS_OBJECTID);
        SystemGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpTimeTicks", SYS_UPTIME_ALIAS, SYS_UPTIME);
        SystemGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", SYS_CONTACT_ALIAS, SYS_CONTACT);
        SystemGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", SYS_NAME_ALIAS, SYS_NAME);
        SystemGroup.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", SYS_LOCATION_ALIAS, SYS_LOCATION);
    }
}

