/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.Arrays;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;

public class IPAddressTableTracker
extends TableTracker {
    public static final SnmpObjId IP_ADDRESS_PREFIX_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.32.1");
    public static final SnmpObjId IP_ADDRESS_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.34.1");
    public static final SnmpObjId IP_ADDRESS_IF_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId IP_ADDRESS_TYPE_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId IP_ADDRESS_PREFIX_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId IP_ADDRESS_PREFIX_ORIGIN_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_PREFIX_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId IP_ADDRESS_ORIGIN_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId IP_ADDRESS_STATUS_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId IP_ADDRESS_CREATED_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId IP_ADDRESS_LAST_CHANGED_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId IP_ADDRESS_ROW_STATUS_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"10");
    public static final SnmpObjId IP_ADDRESS_STORAGE_TYPE_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"11");
    public static final int TYPE_IPV4 = 1;
    public static final int TYPE_IPV6 = 2;
    public static final int TYPE_IPV4Z = 3;
    public static final int TYPE_IPV6Z = 4;
    public static final int TYPE_DNS = 16;
    private static final int IP_ADDRESS_TYPE_UNICAST = 1;
    private static SnmpObjId[] s_tableColumns = new SnmpObjId[]{IP_ADDRESS_IF_INDEX, IP_ADDRESS_PREFIX_INDEX, IP_ADDRESS_TYPE_INDEX};

    public IPAddressTableTracker() {
        super(s_tableColumns);
    }

    public IPAddressTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_tableColumns);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IPAddressRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIPAddressRow((IPAddressRow)row);
    }

    public void processIPAddressRow(IPAddressRow row) {
    }

    class IPAddressRow
    extends SnmpRowResult {
        public IPAddressRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LogUtils.debugf((Object)((Object)this), (String)"column count = %d, instance = %s", (Object[])new Object[]{columnCount, instance});
        }

        public Integer getIfIndex() {
            SnmpValue value = this.getValue(IP_ADDRESS_IF_INDEX);
            return value.toInt();
        }

        public String getIpAddress() {
            SnmpResult result = this.getResult(IP_ADDRESS_IF_INDEX);
            SnmpInstId instance = result.getInstance();
            int[] instanceIds = instance.getIds();
            int addressType = instanceIds[0];
            int addressIndex = 2;
            int addressLength = instanceIds[1];
            if (addressType == 1 && instanceIds.length != 6) {
                LogUtils.warnf((Object)((Object)this), (String)"BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess!", (Object[])new Object[0]);
                addressIndex = instanceIds.length - 4;
                addressLength = 4;
            }
            if (addressType == 2 && instanceIds.length != 18) {
                LogUtils.warnf((Object)((Object)this), (String)"BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess!", (Object[])new Object[0]);
                addressIndex = instanceIds.length - 16;
                addressLength = 16;
            }
            if (addressType == 3) {
                addressLength = 4;
            } else if (addressType == 4) {
                addressLength = 16;
            }
            if (addressIndex < 0 || addressIndex + addressLength > instanceIds.length) {
                LogUtils.warnf((Object)((Object)this), (String)"BAD AGENT: Returned instanceId %s does not enough bytes to contain address!. Skipping.", (Object[])new Object[]{instance});
                return null;
            }
            if (addressType == 1 || addressType == 2 || addressType == 4) {
                try {
                    InetAddress address = InetAddressUtils.getInetAddress((int[])instanceIds, (int)addressIndex, (int)addressLength);
                    return InetAddressUtils.str((InetAddress)address);
                }
                catch (IllegalArgumentException e) {
                    LogUtils.warnf((Object)((Object)this), (Throwable)e, (String)"Failed to parse address: %s, index %d, length %d", (Object[])new Object[]{Arrays.toString(instanceIds), addressIndex, addressLength});
                }
            }
            return null;
        }

        public Integer getType() {
            SnmpValue value = this.getValue(IP_ADDRESS_TYPE_INDEX);
            return value.toInt();
        }

        private InetAddress getNetMask() {
            SnmpValue value = this.getValue(IP_ADDRESS_PREFIX_INDEX);
            SnmpInstId netmaskRef = value.toSnmpObjId().getInstance(IP_ADDRESS_PREFIX_ORIGIN_INDEX);
            if (netmaskRef == null) {
                LogUtils.warnf((Object)((Object)this), (String)"BAD AGENT: Null netmask instanceId", (Object[])new Object[0]);
                return null;
            }
            int[] rawIds = netmaskRef.getIds();
            int addressType = rawIds[1];
            int mask = rawIds[rawIds.length - 1];
            int addressLength = rawIds[2];
            int addressIndex = 3;
            if (addressType == 1 && rawIds.length != 8) {
                LogUtils.warnf((Object)((Object)this), (String)"BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess!", (Object[])new Object[0]);
                addressIndex = rawIds.length - 5;
                addressLength = 4;
            }
            if (addressType == 2 && rawIds.length != 20) {
                LogUtils.warnf((Object)((Object)this), (String)"BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess!", (Object[])new Object[0]);
                addressIndex = rawIds.length - 17;
                addressLength = 16;
            }
            if (addressIndex < 0 || addressIndex + addressLength > rawIds.length) {
                LogUtils.warnf((Object)((Object)this), (String)"BAD AGENT: Returned instanceId %s does not enough bytes to contain address!. Skipping.", (Object[])new Object[]{netmaskRef});
                return null;
            }
            if (addressType == 1) {
                return InetAddressUtils.convertCidrToInetAddressV4((int)mask);
            }
            if (addressType == 2) {
                return InetAddressUtils.convertCidrToInetAddressV6((int)mask);
            }
            LogUtils.warnf((Object)((Object)this), (String)"unknown address type, expected 1 (IPv4) or 2 (IPv6), but got %d", (Object[])new Object[]{addressType});
            return null;
        }

        public OnmsIpInterface createInterfaceFromRow() {
            Integer ifIndex = this.getIfIndex();
            String ipAddr = this.getIpAddress();
            Integer type = this.getType();
            InetAddress netMask = this.getNetMask();
            LogUtils.debugf((Object)((Object)this), (String)"createInterfaceFromRow: ifIndex = %s, ipAddress = %s, type = %s, netmask = %s", (Object[])new Object[]{ifIndex, ipAddr, type, netMask});
            if (type != 1 || ipAddr == null) {
                return null;
            }
            OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(null, ifIndex);
            snmpIface.setNetMask(netMask);
            snmpIface.setCollectionEnabled(true);
            OnmsIpInterface iface = new OnmsIpInterface(ipAddr, null);
            iface.setSnmpInterface(snmpIface);
            iface.setIfIndex(ifIndex);
            String hostName = InetAddressUtils.normalize((String)ipAddr);
            LogUtils.debugf((Object)((Object)this), (String)"setIpHostName: %s", (Object[])new Object[]{hostName});
            iface.setIpHostName(hostName == null ? ipAddr : hostName);
            return iface;
        }

        private SnmpResult getResult(SnmpObjId base) {
            for (SnmpResult result : this.getResults()) {
                if (!base.equals((Object)result.getBase())) continue;
                return result;
            }
            return null;
        }
    }
}

