/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.dns.command;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;

@Command(scope="opennms-dns", name="lookup", description="DNS lookup for the specified host")
@Service
public class DnsLookup
implements Action {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String m_location;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String m_systemId;
    @Argument(index=0, name="host", description="Hostname", required=true, multiValued=false)
    String m_host;
    @Reference
    public LocationAwareDnsLookupClient client;

    public Object execute() throws Exception {
        CompletableFuture future = this.client.lookup(this.m_host, this.m_location, this.m_systemId);
        while (true) {
            try {
                try {
                    String ipAddress = (String)future.get(1L, TimeUnit.SECONDS);
                    System.out.printf("\n%s resolves to: %s\n", this.m_host, ipAddress);
                }
                catch (InterruptedException e) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\nDNS lookup failed with: %s\n", e);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }
}

