/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.requisition.command;

import com.google.common.base.Strings;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.requisition.command.ProviderTypeNameCompleter;

@Command(scope="provision", name="import-requisition", description="Import the requisition from given url")
@Service
public class ImportRequisition
implements Action {
    public static final String EVENT_SOURCE = "karaf-shell";
    public static final String URI_SCHEME = "requisition";
    @Reference
    private EventForwarder eventForwarder;
    @Option(name="-r", aliases={"--rescan"}, description="Specify rescanExisting value, valid values : 'yes', 'no', 'dbonly'")
    private String rescanExisting;
    @Argument(index=0, name="type", description="Type", required=true)
    @Completion(value=ProviderTypeNameCompleter.class)
    private String type;
    @Argument(index=1, name="parameters", description="Provide parameters in key=value form", multiValued=true)
    private List<String> parameters = new LinkedList<String>();

    public Object execute() throws Exception {
        return ImportRequisition.sendImportRequisitionEvent(this.eventForwarder, this.type, this.parameters, this.rescanExisting);
    }

    public static Object sendImportRequisitionEvent(EventForwarder eventForwarder, String type, List<String> parameters, String rescanExisting) throws URISyntaxException {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", EVENT_SOURCE);
        URIBuilder builder = new URIBuilder().setScheme(URI_SCHEME).setHost(type);
        ImportRequisition.parse(parameters, builder);
        String url = builder.build().toString();
        eventBuilder.addParam("url", url);
        if (!Strings.isNullOrEmpty((String)rescanExisting)) {
            List<String> validValues = Arrays.asList("yes", "dbonly", "no");
            if (validValues.contains(rescanExisting)) {
                eventBuilder.addParam("importRescanExisting", rescanExisting);
            } else {
                System.out.printf("Not a valid rescanExisting value, valid values are: %s\n", validValues);
                return null;
            }
        }
        eventForwarder.sendNow(eventBuilder.getEvent());
        System.out.printf("Requisition import triggered asynchronously for URL:\n\t%s\n", url);
        return null;
    }

    private static void parse(List<String> attributeList, URIBuilder builder) {
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                builder.addParameter(key, value);
            }
        }
    }
}

