/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.dns.command;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;

@Command(scope="dns", name="reverse-lookup", description="DNS reverse lookup for the specified ipaddress")
public class DnsReverseLookup
extends OsgiCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String m_location;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String m_systemId;
    @Argument(index=0, name="ipAddress", description="ip-address", required=true, multiValued=false)
    String ipAddress;
    private LocationAwareDnsLookupClient client;

    protected Object doExecute() throws Exception {
        CompletableFuture future = this.client.reverseLookup(InetAddressUtils.addr((String)this.ipAddress), this.m_location, this.m_systemId);
        while (true) {
            try {
                try {
                    String hostName = (String)future.get(1L, TimeUnit.SECONDS);
                    System.out.printf("\n%s resolves to: %s\n", this.ipAddress, hostName);
                }
                catch (InterruptedException e) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\n DNS reverse lookup failed with: %s\n", e);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    public void setClient(LocationAwareDnsLookupClient client) {
        this.client = client;
    }
}

