/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.requisition.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.LocationAwareRequisitionClient;
import org.opennms.netmgt.provision.persist.requisition.Requisition;

@Command(scope="provision", name="show-import", description="Display the resulting requisition generated by a given URL")
public class ShowImport
extends OsgiCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String location;
    @Option(name="-t", aliases={"--ttl"}, description="Time to live", required=false, multiValued=false)
    Long ttlInMs;
    @Option(name="-x", aliases={"--xml"}, description="XML Output", required=false, multiValued=false)
    boolean xmlOutput = false;
    @Argument(index=0, name="type", description="Type", required=true, multiValued=false)
    String type;
    @Argument(index=1, name="parameters", description="Provider parameters in key=value form", multiValued=true)
    List<String> parameters;
    private LocationAwareRequisitionClient client;

    protected Object doExecute() throws Exception {
        CompletableFuture future = this.client.requisition().withRequisitionProviderType(this.type).withParameters(ShowImport.parse(this.parameters)).withLocation(this.location).withTimeToLive(this.ttlInMs).execute();
        while (true) {
            try {
                try {
                    Requisition requisition = (Requisition)future.get(1L, TimeUnit.SECONDS);
                    if (this.xmlOutput) {
                        return JaxbUtils.marshal((Object)requisition);
                    }
                    return requisition;
                }
                catch (InterruptedException e) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\nRequisition retrieval failed with: %s\n", e);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    public void setClient(LocationAwareRequisitionClient client) {
        this.client = client;
    }

    private static Map<String, String> parse(List<String> attributeList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }
}

