/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.dns.command;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;

@Command(scope="dns", name="lookup", description="DNS lookup for the specified host")
public class DnsLookup
extends OsgiCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String m_location;
    @Argument(index=0, name="host", description="Hostname", required=true, multiValued=false)
    String m_host;
    private LocationAwareDnsLookupClient client;

    protected Object doExecute() throws Exception {
        CompletableFuture future = this.client.lookup(this.m_host, this.m_location);
        while (true) {
            try {
                try {
                    String ipAddress = (String)future.get(1L, TimeUnit.SECONDS);
                    System.out.printf("IpAddress returned for the %s  is  %s \n", this.m_host, ipAddress);
                }
                catch (InterruptedException e) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\n DNS lookup failed with: %s\n", e);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    public void setClient(LocationAwareDnsLookupClient client) {
        this.client = client;
    }
}

