/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.persist.policies.MatchingSnmpInterfacePolicy;
import org.opennms.netmgt.provision.persist.policies.NodeCategorySettingPolicy;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml"})
@JUnitConfigurationEnvironment
public class CollectionPolicyTest
implements InitializingBean {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private DatabasePopulator m_populator;
    private List<OnmsSnmpInterface> m_interfaces;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.m_populator.populateDatabase();
        this.m_interfaces = this.m_snmpInterfaceDao.findAll();
    }

    @After
    public void tearDown() {
        this.m_populator.resetDatabase();
    }

    @Test
    @Transactional
    public void testMatchingIfDescr() {
        MatchingSnmpInterfacePolicy p = this.createPolicy();
        p.setIfDescr("~^ATM.*");
        CollectionPolicyTest.matchPolicy(this.m_interfaces, p, InetAddressUtils.addr((String)"192.168.1.1"));
    }

    private MatchingSnmpInterfacePolicy createPolicy() {
        MatchingSnmpInterfacePolicy policy = new MatchingSnmpInterfacePolicy();
        policy.setMatchBehavior(BasePolicy.Match.NO_PARAMETERS.toString());
        return policy;
    }

    @Test
    @Transactional
    public void testMatchingIfName() {
        MatchingSnmpInterfacePolicy p = this.createPolicy();
        p.setIfName("eth0");
        CollectionPolicyTest.matchPolicy(this.m_interfaces, p, InetAddressUtils.addr((String)"192.168.1.2"));
    }

    @Test
    @Transactional
    public void testMatchingIfType() {
        MatchingSnmpInterfacePolicy p = this.createPolicy();
        p.setIfType("6");
        CollectionPolicyTest.matchPolicy(this.m_interfaces, p, InetAddressUtils.addr((String)"192.168.1.2"));
    }

    @Test
    @Transactional
    public void testCategoryAssignment() {
        String TEST_CATEGORY = "TestCategory";
        NodeCategorySettingPolicy policy = new NodeCategorySettingPolicy();
        policy.setCategory("TestCategory");
        policy.setLabel("~n.*2");
        OnmsNode node1 = (OnmsNode)this.m_nodeDao.get((Serializable)this.m_populator.getNode1().getId());
        Assert.assertNotNull((Object)node1);
        Assert.assertEquals((Object)"node1", (Object)node1.getLabel());
        OnmsNode node2 = (OnmsNode)this.m_nodeDao.get((Serializable)this.m_populator.getNode2().getId());
        Assert.assertNotNull((Object)node2);
        Assert.assertEquals((Object)"node2", (Object)node2.getLabel());
        node1 = (OnmsNode)policy.apply((Object)node1, Collections.emptyMap());
        Assert.assertNotNull((Object)node1);
        Assert.assertFalse((boolean)node1.hasCategory("TestCategory"));
        node2 = (OnmsNode)policy.apply((Object)node2, Collections.emptyMap());
        Assert.assertNotNull((Object)node1);
        Assert.assertTrue((boolean)node2.getRequisitionedCategories().contains("TestCategory"));
    }

    private static void matchPolicy(List<OnmsSnmpInterface> interfaces, MatchingSnmpInterfacePolicy p, InetAddress matchingIp) {
        ArrayList<OnmsSnmpInterface> populatedInterfaces = new ArrayList<OnmsSnmpInterface>();
        ArrayList<OnmsSnmpInterface> matchedInterfaces = new ArrayList<OnmsSnmpInterface>();
        for (OnmsSnmpInterface iface : interfaces) {
            System.err.println(iface);
            OnmsSnmpInterface o = (OnmsSnmpInterface)p.apply((Object)iface, Collections.emptyMap());
            if (o != null) {
                matchedInterfaces.add(o);
            }
            for (OnmsIpInterface ipif : iface.getIpInterfaces()) {
                if (!ipif.getIpAddress().equals(matchingIp)) continue;
                populatedInterfaces.add(iface);
            }
        }
        Assert.assertEquals(populatedInterfaces, matchedInterfaces);
    }
}

