/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.provision.persist.DirectoryWatcher;
import org.opennms.netmgt.provision.persist.FileSystemBuilder;
import org.springframework.core.io.Resource;

public class DirectoryWatcherTest {
    private FileSystemBuilder m_bldr;
    private DirectoryWatcher<String> m_watcher;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_bldr = new FileSystemBuilder("target", "DirectoryWatcherTest");
        this.m_bldr.file("file1.xml", "file1Contents").file("file2.xml", "file2Contents");
        File dir = this.m_bldr.getCurrentDir();
        FileReloadCallback<String> loader = new FileReloadCallback<String>(){

            public String reload(String object, Resource resource) throws IOException {
                return FileUtils.readFileToString((File)resource.getFile());
            }
        };
        this.m_watcher = new DirectoryWatcher(dir, (FileReloadCallback)loader);
    }

    @After
    public void tearDown() throws Exception {
        this.m_bldr.cleanup();
        this.m_watcher.stop();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testGetContents() throws FileNotFoundException {
        Assert.assertEquals((Object)"file1Contents", (Object)this.m_watcher.getContents("file1.xml"));
        Assert.assertEquals((Object)"file2Contents", (Object)this.m_watcher.getContents("file2.xml"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testFileDoesntExist() throws FileNotFoundException {
        this.m_watcher.getContents("doesnotexist.xml");
    }

    @Test
    public void testFileAdded() throws IOException {
        Assert.assertEquals((Object)"file2Contents", (Object)this.m_watcher.getContents("file2.xml"));
        this.m_bldr.file("file3.xml", "file3Contents");
        Assert.assertEquals((Object)"file3Contents", (Object)this.m_watcher.getContents("file3.xml"));
    }

    @Test
    public void testFilUpdated() throws Exception {
        Assert.assertEquals((Object)"file2Contents", (Object)this.m_watcher.getContents("file2.xml"));
        this.m_bldr.file("file2.xml", "updated-content");
        Assert.assertEquals((Object)"updated-content", (Object)this.m_watcher.getContents("file2.xml"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testFileDeleted() throws IOException {
        Assert.assertEquals((Object)"file2Contents", (Object)this.m_watcher.getContents("file2.xml"));
        File file2 = new File(this.m_bldr.getCurrentDir(), "file2.xml");
        file2.delete();
        this.m_watcher.getContents("file2.xml");
        Assert.fail((String)"This should not get here!");
    }

    @Test
    public void testGetFilesNames() {
        Assert.assertEquals(DirectoryWatcherTest.set("file1.xml", "file2.xml"), (Object)this.m_watcher.getFileNames());
        Assert.assertEquals(DirectoryWatcherTest.set("file1", "file2"), (Object)this.m_watcher.getBaseNamesWithExtension(".xml"));
        Assert.assertEquals(Collections.emptySet(), (Object)this.m_watcher.getBaseNamesWithExtension(".txt"));
    }

    private static Set<String> set(String ... items) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Collections.addAll(set, items);
        return set;
    }
}

