/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.persist.policies.NodeCategorySettingPolicy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;

public class NodeCategoryPolicyTest
implements InitializingBean {
    private List<OnmsNode> m_nodes;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.m_nodes = new ArrayList<OnmsNode>();
        OnmsNode node1 = new OnmsNode();
        node1.setNodeId("1");
        node1.setForeignSource("a");
        node1.setForeignId("1");
        node1.setLabel("Node 1");
        this.m_nodes.add(node1);
    }

    @Test
    @Transactional
    public void testMatchingLabel() {
        NodeCategorySettingPolicy p = new NodeCategorySettingPolicy();
        p.setForeignId("1");
        p.setCategory("PolicyTest");
        List<OnmsNode> matchedNodes = this.matchPolicy(p, "1");
        Assert.assertTrue((boolean)matchedNodes.get(0).getRequisitionedCategories().contains("PolicyTest"));
    }

    @Test
    @Transactional
    public void testMatchingNothing() {
        NodeCategorySettingPolicy p = new NodeCategorySettingPolicy();
        p.setLabel("~^wankerdoodle$");
        p.setCategory("PolicyTest");
        List<OnmsNode> matchedNodes = this.matchPolicy(p, null);
        Assert.assertEquals((long)0L, (long)matchedNodes.size());
    }

    private List<OnmsNode> matchPolicy(NodeCategorySettingPolicy p, String matchingId) {
        ArrayList<OnmsNode> populatedNodes = new ArrayList<OnmsNode>();
        ArrayList<OnmsNode> matchedNodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.m_nodes) {
            System.err.println(node);
            OnmsNode o = (OnmsNode)p.apply((Object)node);
            if (o != null && o.getRequisitionedCategories().contains(p.getCategory())) {
                matchedNodes.add(o);
            }
            if (!node.getNodeId().equals(matchingId)) continue;
            populatedNodes.add(node);
        }
        Assert.assertEquals(populatedNodes, matchedNodes);
        return matchedNodes;
    }
}

